%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 3.24
%define xdg_name org.gnome.Totem
%define nautilus_extdir %_libdir/nautilus/extensions-3.0

%define parser_ver 3.10.1
%define gst_api_ver 1.0
%define gst_ver 1.4.2
%define gst_plugins_ver 1.2.4
%define gtk_ver 3.16.0
%define grilo_ver 0.2.12
%define glib_ver 2.36.0
%define clutter_ver 1.17.3
%define clutter_gtk_ver 1.5.5
%define clutter_gst_ver 2.99.2
%define peas_ver 1.1.0


%def_disable static
%def_enable vala
%if_enabled vala
%def_enable rotation
%def_enable zeitgeist
%endif
%def_enable introspection
%def_enable nautilus
%def_enable lirc
%def_disable tracker
%def_enable python
%def_disable coherence_upnp
%def_disable jamendo
%def_disable gromit

Name: totem
Version: %ver_major.0
Release: alt0.M80P.1

Summary: Movie player for GNOME 3
Group: Video
License: GPLv2/LGPL
Url: https://wiki.gnome.org/Apps/Videos

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%endif

Obsoletes: %name-gstreamer < %version %name-backend-gstreamer < %version %name-backend-xine < %version
Obsoletes: %name-plugins-mythtv  %name-plugins-galago
Obsoletes: %name-plugins-bemused  %name-plugins-youtube
Obsoletes: %name-plugins-publish  %name-plugins-iplayer %name-plugins-grilo
Obsoletes: mozilla-plugin-%name
Provides: %name-backend = %version %name-backend-gstreamer = %version %name-backend-xine = %version

Requires: lib%name = %version-%release
Requires: libpeas-python3-loader
Requires: %name-video-thumbnailer = %version-%release
Requires: dconf gnome-icon-theme
Requires: gstreamer%gst_api_ver >= %gst_ver
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-bad%gst_api_ver
Requires: gst-plugins-ugly%gst_api_ver
Requires: gst-libav
Requires: iso-codes
Requires: grilo-plugins

# use python3
AutoReqProv: nopython
%define __python %nil
%add_python3_compile_include %_libdir/%name/plugins

BuildPreReq: rpm-build-gnome gnome-common gtk-doc
BuildPreReq: intltool >= 0.40.0
BuildRequires: libappstream-glib-devel
%{?_enable_nvtv:BuildRequires: libnvtv-devel >= 0.4.5}

BuildRequires: gstreamer%gst_api_ver-devel >= %gst_ver
BuildRequires: gst-plugins%gst_api_ver-devel >= %gst_plugins_ver
BuildRequires: gstreamer%gst_api_ver-utils >= %gst_ver
BuildRequires: gst-plugins-base%gst_api_ver
BuildRequires: gst-plugins-good%gst_api_ver
BuildRequires: gst-plugins-bad%gst_api_ver-devel

BuildPreReq: iso-codes-devel gnome-icon-theme
BuildPreReq: glib2-devel >= %glib_ver libgtk+3-devel >= %gtk_ver libgio-devel libpeas-devel >= %peas_ver
BuildPreReq: libtotem-pl-parser-devel >= %parser_ver
BuildPreReq: libXtst-devel libXrandr-devel libXxf86vm-devel xorg-xproto-devel
BuildPreReq: libclutter-devel >= %clutter_ver
BuildPreReq: libclutter-gtk3-devel >= %clutter_gtk_ver
BuildPreReq: libclutter-gst3.0-devel >= %clutter_gst_ver
BuildRequires: libgrilo-devel >= %grilo_ver
BuildRequires: libgnome-desktop3-devel
%{?_enable_python:BuildRequires: rpm-build-python3 python3-devel python3-module-pygobject3-devel pylint-py3}
%{?_enable_vala:BuildRequires: libvala-devel >= 0.14 vala-tools}
BuildRequires: libdbus-devel gsettings-desktop-schemas-devel
%{?_enable_lirc:BuildRequires: liblirc-devel}
%{?_enable_tracker:BuildRequires: tracker-devel}
%{?_enable_nautilus:BuildRequires: libnautilus-devel}
%{?_enable_zeitgeist:BuildRequires: libzeitgeist2.0-devel}
%{?_enable_introspection:BuildRequires: libtotem-pl-parser-gir-devel libgtk+3-gir-devel libclutter-gtk3-gir-devel libpeas-gir-devel}

BuildRequires: desktop-file-utils db2latex-xsl yelp-tools gcc-c++
BuildRequires: libX11-devel libXext-devel libXi-devel

%description
Totem is simple movie player for the Gnome desktop.
It features a simple playlist, a full-screen mode, seek and volume
controls, as well as a pretty complete keyboard navigation.

%package -n lib%name
Summary: Totem Library
License: LGPLv2+
Group: System/Libraries

%description -n lib%name
This package provides shared library for Totem movie player.

%package -n lib%name-devel
Summary: Development files for Totem Library
License: LGPLv2+
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides files required to develop programs that use
Totem library.

%package -n lib%name-gir
Summary: GObject introspection data for the Totem library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Totem library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Totem library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Totem library

%package plugins
Summary: default plugins for Totem
Group: Video
Requires: %name = %version-%release

%description plugins
A default plugins for Totem:
	ontop
	screensaver
	skipto
	properties
	media-player-keys
	pythonconsole
	opensubtitles

%package plugins-lirc
Summary: LIRC (Infrared remote) plugin for Totem
Group: Video
Requires: %name = %version-%release

%description plugins-lirc
A plugin to add LIRC (Infrared remote) support to Totem.

%package plugins-rotation
Summary: Rotation plugin for Totem
Group: Video
Requires: %name = %version-%release

%description plugins-rotation
A plugin to allow videos to be rotated if they're in the wrong orientation.

%package plugins-zeitgeist
Summary: Zeitgeist plugin for Totem
Group: Video
Requires: %name = %version-%release
Requires: zeitgeist

%description plugins-zeitgeist
A plugin sending events to Zeitgeist

%package plugins-tracker
Summary: Tracker-based video search plugin for Totem
Group: Video
Requires: %name = %version-%release

%description plugins-tracker
A plugin to allow searching local videos, based on their tags, metadata,
or filenames, as indexing by the Tracker indexer.

%package plugins-jamendo
Summary: Plugin for jamendo.com music collection
Group: Video
Requires: %name = %version-%release
%py_requires json

%description plugins-jamendo
A plugin to allow you to listen to the large collection of Creative
Commons licensed music on Jamendo

%package plugins-coherence_upnp
Summary: Coherence DLNA/UPnP totem plugin
Group: Video
Requires: %name = %version-%release
Requires: python-module-coherence coherence

%description plugins-coherence_upnp
This package contains a DLNA/UPnP client for Totem powered by Coherence

%package plugins-gromit
Summary: Gromit Annotations plugin for totem
Group: Video
Requires: %name = %version-%release

%description plugins-gromit
This package contains presentation helper to make annotations on screen

%package plugins-brasero
Summary: Video disc recorder plugin for Totem
Group: Video
Requires: %name = %version-%release
Requires: brasero

%description plugins-brasero
This package contains plugin that allow record (S)VCDs or video DVDs
with Brasero

%package devel-doc
Summary: Development documentation for Totem
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides Totem reference manual

%package nautilus
Summary: Nautilus extension for the Totem media player
Group: Video
Requires: %name-video-thumbnailer = %version-%release
Provides: totem-gstreamer-nautilus = %version-%release
Provides: totem-xine-nautilus = %version-%release
Provides: totem-nautilus = %version
Provides: nautilus-totem-gstreamer = %version-%release
Provides: nautilus-totem-xine = %version-%release
Provides: nautilus-totem = %version-%release
Obsoletes: totem-gstreamer-nautilus < %version-%release
Obsoletes: totem-xine-nautilus < %version-%release
Obsoletes: totem-nautilus < %version-%release

%description nautilus
This package provides integration with the Totem media player for
the Nautilus file manager.

%package video-thumbnailer
Summary: Totem video thumbnailer
Group: Video
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-bad%gst_api_ver
Requires: gst-plugins-ugly%gst_api_ver
Requires: gst-libav
Requires: iso-codes

%description video-thumbnailer
This package provides a video thumbnailer from Totem package that can be
used by other applications like filemanagers.

%prep
%setup
[ ! -d m4 ] && mkdir m4

%build
export ac_cv_path_PYLINT=%_bindir/pylint.py3
%autoreconf
%configure \
	%{subst_enable static} \
	--disable-schemas-compile \
	%{subst_enable python} \
	%{subst_enable vala} \
	%{?_enable_nautilus:--enable-nautilus=yes} \
	--disable-static \
	%{?_enable_snapshot:--enable-gtk-doc}

%make_build

%install
%makeinstall_std
find %buildroot%_libdir -name \*.la -delete

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%exclude %_bindir/%name-video-thumbnailer
%dir %_libdir/%name
# depends on pygtk
#%_libexecdir/%name/totem-bugreport.py
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/*.png
%_iconsdir/hicolor/*/*/*.svg
%_datadir/%name/
%_man1dir/*
%exclude %_man1dir/%name-video-thumbnailer.1.*
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/org.gnome.totem.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.totem.enums.xml
%_datadir/GConf/gsettings/totem.convert
%_datadir/appdata/%xdg_name.appdata.xml
%doc AUTHORS NEWS README TODO COPYING

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*.pc

%if_enabled introspection
%files -n lib%name-gir
%_libdir/girepository-1.0/*.typelib

%files -n lib%name-gir-devel
%_datadir/gir-1.0/*.gir
%endif

%files plugins
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/dbus/
%_libdir/%name/plugins/ontop/
%_libdir/%name/plugins/screensaver/
%_libdir/%name/plugins/skipto/
%_libdir/%name/plugins/properties/
%_libdir/%name/plugins/media-player-keys/
%_libdir/%name/plugins/pythonconsole/
%_libdir/%name/plugins/opensubtitles/
%_libdir/%name/plugins/screenshot/
%_libdir/%name/plugins/save-file/
%_libdir/%name/plugins/im-status/
%_libdir/%name/plugins/apple-trailers/
%_libdir/%name/plugins/autoload-subtitles/
%_libdir/%name/plugins/recent/
%_libdir/%name/plugins/variable-rate/
%_libdir/%name/plugins/vimeo/
%config %_datadir/glib-2.0/schemas/org.gnome.totem.plugins.opensubtitles.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.totem.plugins.pythonconsole.gschema.xml
%_datadir/GConf/gsettings/opensubtitles.convert
%_datadir/GConf/gsettings/pythonconsole.convert

%if_enabled lirc
%files plugins-lirc
%_libdir/%name/plugins/lirc/
%endif

%if_enabled rotation
%files plugins-rotation
%_libdir/%name/plugins/rotation/
%endif

%if_enabled zeitgeist
%files plugins-zeitgeist
%_libdir/%name/plugins/zeitgeist-dp/
%endif

%if_enabled tracker
%files plugins-tracker
%_libdir/%name/plugins/tracker/
%endif

%if_enabled jamendo
%files plugins-jamendo
%_libdir/%name/plugins/jamendo/
%_datadir/glib-2.0/schemas/org.gnome.totem.plugins.jamendo.gschema.xml
%_datadir/GConf/gsettings/jamendo.convert
%endif

%if_enabled gromit
%files plugins-gromit
%_libdir/%name/plugins/gromit/
%endif

%files nautilus
%nautilus_extdir/*

%if_enabled coherence_upnp
%files plugins-coherence_upnp
%_libdir/%name/plugins/coherence_upnp/
%endif

%files plugins-brasero
%_libdir/%name/plugins/brasero-disc-recorder/

%files devel-doc
%_datadir/gtk-doc/html/*

%files video-thumbnailer
%_bindir/%name-video-thumbnailer
%_man1dir/%name-video-thumbnailer.1.*
%_datadir/thumbnailers/%name.thumbnailer

%changelog
