%define origname trafshow

Name: %origname-linux
Version: 1.3
Release: alt6

Summary: An ncurses-based IP traffic monitoring tool
License: GPL
Group: Monitoring

Source0: ftp://sunsite.unc.edu/pub/linux/system/network/management/%origname-%version.tar.gz
Source1: %name.init
Source2: %name.control
Patch0: trafshow-1.3-glibc.patch
Patch1: trafshow-1.3-config.patch
Patch2: trafshow-1.3-make.patch
Patch3: trafshow-1.3-uptime-fix
Patch4: trafshow-1.3-buffer-overhead.asp.patch
ExclusiveArch: %ix86

PreReq: control

# Automatically added by buildreq on Sat Jan 25 2003
BuildRequires: libncurses-devel libtinfo-devel

Summary(ru_RU.KOI8-R):    IP-
Summary(uk_UA.KOI8-U):  ̦ Φ IP-Ʀ

%description
Trafshow will continuously display an ncurses-based graphic
representation of packet traffic on network interfaces.  Trafshow will
also periodically sort and update the traffic information, and may be
useful for monitoring suspicious traffic on your network.

This is Linux (1.3.x) version which is less featureful compared
to BSD version (3.x) but it can monitor PPP links and is still useful.

%description -l ru_RU.KOI8-R
Trafshow       ,
    .

 Linux- (1.3.x),       BSD-
(3.x),     PPP-    .

%description -l uk_UA.KOI8-U
Trafshow դ צ  Ʀ   ,
    æ.

 Linux-Ӧ (1.3.x),     BSD-Ӧ (3.x),  
  PPP-   ¦ .

%prep
%setup -q -n %origname-%version
%patch0 -p1 -b .glibc
%patch1 -p1 -b .config
%patch2 -p1 -b .make
%patch4 -p1 -b .bof

%build
%make_build

%install
install -pD -m755 %origname %buildroot%_bindir/%name
install -pD -m644 %origname.1 %buildroot%_man1dir/%name.1
#install -pD -m755 %SOURCE1 %buildroot%_initdir/%name
install -pD -m755 %SOURCE2 %buildroot%_sysconfdir/control.d/facilities/%name

%pre
/usr/sbin/groupadd -r -f netadmin >/dev/null 2>&1
[ $1 -eq 1 ] || /usr/sbin/control-dump %name

%post
if [ $1 -ge 2 ]; then
	/usr/sbin/control-restore %name
else
	/usr/sbin/control %name public
fi

%files
%_bindir/*
%_man1dir/*
#_initdir/*
%config %_sysconfdir/control.d/facilities/%name
%doc TODO trafshow.lsm

# TODO: make configurable and not hardwire VT & params in initscript?

%changelog
