%define _optlevel s
%def_disable wxgtk
%def_enable qt

%define rname Transmission
%define dname transmission-daemon

Name: transmission
Version: 2.94
Release: alt2%ubt

Group: Networking/File transfer
Summary: Llightweight BitTorrent client
License: GPLv2 + MIT
Url: http://www.transmissionbt.com/

Provides: %rname = %version-%release

Obsoletes: %name-benc2php
Obsoletes: %name-proxy

Requires: %name-gui = %version-%release
Requires: %name-cli = %version-%release
Requires: %name-remote = %version-%release
Requires: %name-daemon = %version-%release

Requires(post,postun): desktop-file-utils

Source: http://download.m0k.org/%name/files/%name-%version.tar
Patch0: %name-%version-alt.patch
Source1: %dname.init
Source2: %dname.logrotate
Source3: %dname.service

BuildPreReq: desktop-file-utils

BuildRequires: gcc-c++ glibc-devel intltool libcurl-devel libevent-devel libnotify-devel libcanberra-devel libdbus-glib-devel libgtk+3-devel
BuildRequires(pre): rpm-utils desktop-file-utils libalternatives-devel rpm-build-ubt openssl-devel
%if "%(rpmvercmp '%{get_version glibc-core}' '2.9')" >= "0"
BuildRequires: libgio-devel
%endif
%if_enabled qt
BuildRequires: qt5-base-devel qt5-tools
%endif

%if_enabled wxgtk
BuildRequires: wxGTK2u-devel
%endif

%description
Transmission has been built from the ground up to be a lightweight,
yet powerful BitTorrent client. Its simple, intuitive interface
strikes a balance between providing useful functionality without
feature bloat. Furthermore, it is free for anyone to use or modify.

%package common
Group: Networking/File transfer
Summary: Common files for %name
Conflicts: %name < 1.00-alt10
%description common
Common files for %name

%package gui-common
Group: Networking/File transfer
Summary: Common files for %name
Requires: %name-common = %version-%release
%description gui-common
Common files for %name

%package gtk
Group: Networking/File transfer
Summary: Graphical BitTorrent client
Provides: %name-gui = %version-%release
Requires: %name-common = %version-%release
Requires: %name-gui-common = %version-%release
%description gtk
GTK-based graphical BitTorrent client

%if_enabled qt
%package qt
Group: Networking/File transfer
Summary: Graphical BitTorrent client
Provides: %name-gui = %version-%release
Requires: %name-common = %version-%release
Requires: %name-gui-common = %version-%release
%description qt
Qt-based graphical BitTorrent client
%endif

%if_enabled wxgtk
%package wxgtk
Group: Networking/File transfer
Summary: Graphical BitTorrent client
Provides: %name-gui = %version-%release
Requires: %name-common = %version-%release
Requires: %name-gui-common = %version-%release
%description wxgtk
WxGTK-based graphical BitTorrent client
%endif

%package cli
Group: Networking/File transfer
Summary: Command line BitTorrent client
Requires: %name-common = %version-%release
%description cli
Command line BitTorrent client

%package remote
Group: Networking/Remote access
Summary: Command line remote interface to %name-daemon
Requires: %name-common = %version-%release
%description remote
Command line remote interface to %name-daemon

%package daemon
Group: Networking/File transfer
Summary: Daemonised BitTorrent client
Requires: %name-common = %version-%release
%description daemon
Daemonised BitTorrent client

%prep
%setup -q
%patch0 -p1
sed -i "s|\(^CONFIG.*\+=.*[[:space:]]\)debug\([[:space:]].*$\)|\1release\2|" qt/qtr.pro
sed -i "s|^LIBS.*\+=.*libevent\.a$|LIBS += -levent|" qt/qtr.pro
rm -f m4/glib-gettext.m4


%if "%(rpmvercmp '%{get_version glib2}' '2.48.0')" >= "0"
rm -f m4/glib-gettext.m4
%endif

%build
./autogen.sh
%configure \
    --verbose \
    %{subst_enable wx} \
    --enable-libnotify \
    --enable-libcanberra \
    --enable-gtk

%if_enabled qt
pushd qt
qmake-qt5 "QMAKE_CXXFLAGS+=%optflags -std=c++11"
popd
%endif

%make_build

%if_enabled qt
pushd qt
%make_build
for f in translations/*.ts; do lrelease-qt5 $f; done
popd
%endif


%install
%make DESTDIR=%buildroot install

%if_enabled qt
%make install INSTALL_ROOT=%buildroot/%prefix -C qt
%endif

mv %buildroot/%_desktopdir/transmission-gtk.desktop \
    %buildroot/%_desktopdir/transmission.desktop

# made alternatives entries
mkdir -p %buildroot/%_altdir

%if_enabled wxgtk
cat >%buildroot/%_altdir/%name-wxgtk <<__EOF__
%_bindir/%name %_bindir/Xmission 10
__EOF__
%endif

cat >%buildroot/%_altdir/%name-gtk <<__EOF__
%_bindir/%name %_bindir/%name-gtk 30
__EOF__

%if_enabled qt
cat >%buildroot/%_altdir/%name-qt <<__EOF__
%_bindir/%name %_bindir/%name-qt 20
__EOF__
# install translations
mkdir -p %buildroot/%_datadir/qt5/translations/
for f in qt/translations/*.qm; do install -m 0644 $f %buildroot/%_datadir/qt5/translations/; done
%endif

%find_lang %name-gtk

# install daemonic stuff

install -pD -m640 %SOURCE2 %buildroot%_sysconfdir/logrotate.d/%dname
install -pD -m755 %SOURCE1 %buildroot%_initdir/%dname
install -pD -m644 %SOURCE3 %buildroot%systemd_unitdir/transmission-daemon.service

mkdir -p %buildroot/%_sysconfdir/transmission-daemon/
daemon/transmission-daemon -d 2> %buildroot/%_sysconfdir/transmission-daemon/settings.json
sed -i 's,/usr/src/,/var/lib/transmission-daemon/,' %buildroot/%_sysconfdir/transmission-daemon/settings.json

mkdir -p %buildroot/%_sysconfdir/sysconfig/
echo "TRANSMISSION_OPTIONS=\"-e %_logdir/%dname/%dname.log -g %_localstatedir/%dname\"" > %buildroot/%_sysconfdir/sysconfig/%dname

mkdir -p %buildroot/%_logdir/%dname
mkdir -p %buildroot/%_localstatedir/%dname

%pre daemon
/usr/sbin/groupadd -r -f _%dname
/usr/sbin/useradd -r -g _%dname -d %_localstatedir/%dname -s /dev/null -c 'The Transmission Torrent Client' _%dname >/dev/null 2>&1 ||:
if [ $1 -gt 1 ]; then
        /usr/sbin/usermod -d %_localstatedir/%dname _%dname
fi

%files

%files common
%dir %_datadir/%name
%_datadir/%name/web/

%files gui-common
%_iconsdir/hicolor/*/*/*
%_datadir/pixmaps/*
%_datadir/applications/%name.desktop

%files gtk -f %name-gtk.lang
%doc AUTHORS COPYING NEWS README ChangeLog
%_bindir/%name-gtk
%_altdir/%name-gtk
%_man1dir/%name-gtk.1*

%if_enabled qt
%files qt
%doc AUTHORS COPYING NEWS README ChangeLog
%_bindir/%name-qt
%_altdir/%name-qt
%_datadir/qt5/translations/%{name}_*.qm
%_man1dir/%name-qt.1*
%endif

%if_enabled wxgtk
%files wxgtk
%doc AUTHORS COPYING NEWS README ChangeLog
%_bindir/Xmission
%_altdir/%name-wxgtk
%endif

%files cli
%doc AUTHORS COPYING NEWS README ChangeLog
%_bindir/%name-create
%_man1dir/%name-create.*
%_bindir/%name-edit
%_man1dir/%name-edit.*
%_bindir/%name-show
%_man1dir/%name-show.*

%files remote
%doc AUTHORS COPYING NEWS README ChangeLog
%_bindir/%name-remote
%_man1dir/%name-remote.*

%files daemon
%doc AUTHORS COPYING NEWS README ChangeLog
%_bindir/%name-daemon
%_man1dir/%name-daemon.*
%systemd_unitdir/transmission-daemon.service
%config(noreplace) %_sysconfdir/logrotate.d/%dname
%config(noreplace) %_sysconfdir/sysconfig/%dname
%config %_initdir/%dname
%attr(710,root,_%dname) %dir %_sysconfdir/%dname
%config(noreplace) %_sysconfdir/%dname/settings.json
%attr(771,root,_%dname) %dir %_localstatedir/%dname
%attr(770,root,_%dname) %dir %_logdir/%dname

%changelog
