# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install /usr/bin/makensis gcc-c++ libxml2-devel pkgconfig(SDL_image) pkgconfig(SDL_mixer) pkgconfig(SDL_net) pkgconfig(cairo) pkgconfig(librsvg-2.0) pkgconfig(libxml-2.0) pkgconfig(sdl) pkgconfig(t4k_common)
# END SourceDeps(oneline)
Name:           tuxmath
Version:        2.0.1
Release:        alt2_11
Summary:        Educational math tutor for children

Group:          Games/Other
License:        GPLv3+ and CC-BY and OFL
URL:            http://tux4kids.alioth.debian.org/
Source0:        https://alioth.debian.org/frs/download.php/3272/%{name}_w_fonts-%{version}.tar.gz
Source1:        %{name}.appdata.xml
Patch0:	        tuxmath_w_fonts-2.0.1-scandir.patch
Patch1:         tuxmath_w_fonts-2.0.1-gcc5.patch
Patch2:         tuxmath_w_fonts-2.0.1-powerup-crash.patch

BuildRequires:  desktop-file-utils libappstream-glib
BuildRequires:  libSDL-devel
BuildRequires:  libSDL_image-devel
BuildRequires:  libSDL_mixer-devel
BuildRequires:  libSDL_pango-devel
BuildRequires:  libSDL_net-devel
BuildRequires:  librsvg-devel
BuildRequires:	t4k_common-devel
Requires:       icon-theme-hicolor
Source44: import.info

%description
TuxMath is an educational math tutor for children. It features several
different types of gameplay, at a variety of difficulty levels.


%prep
%setup -q -n %{name}_w_fonts-%{version}
# remove unneeded font files
rm -f data/fonts/*.ttf
%patch0 -p1
%patch1 -p1
%patch2 -p1


%build
%configure
make %{?_smp_mflags}


%install
%makeinstall_std
%find_lang %{name}

desktop-file-install --vendor="" \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications %{name}.desktop

mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/48x48/apps
install -p -m 644 data/images/icons/icon.png \
  $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/48x48/apps/%{name}.png

mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/scalable/apps
install -p -m 644 data/images/icons/tuxmath.svg \
  $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/scalable/apps

mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
install -p -m 644 %{SOURCE1} $RPM_BUILD_ROOT%{_datadir}/appdata
appstream-util validate-relax --nonet \
  $RPM_BUILD_ROOT%{_datadir}/appdata/%{name}.appdata.xml


%files -f %{name}.lang
%{_docdir}/%{name}
%{_bindir}/%{name}*
%{_bindir}/generate_lesson
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/*
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/48x48/apps/%{name}.png
%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg


%changelog
