Name: tzdata
Version: 2018g
Release: alt0.M80P.1

Summary: Timezone data
# tzdata itself is Public Domain, but tzupdate is GPLv2+,
# so it is OK to release the whole as GPLv2+.
License: GPLv2+
Group: System/Base
Url: http://www.iana.org/time-zones
BuildArch: noarch
# git://git.altlinux.org/gears/t/tzdata.git
Source: %name-%version-%release.tar

%def_with java

%if_with java
BuildRequires: gcc-java javazic
%endif #with java

Provides: zoneinfo /usr/sbin/tzupdate
Obsoletes: zoneinfo
Conflicts: glibc-timezones <= 6:2.5.1-alt7

BuildRequires: hardlink /usr/sbin/zic

%description
This package contains data files with rules for various timezones around
the world.

%package java
Summary: Timezone data for Java
Group: System/Base
Requires: %name = %version-%release

%description java
This package contains timezone information for use by Java runtimes.

%prep
%setup -n %name-%version-%release

%build
make CFLAGS='%optflags' TZDIR=%_datadir/zoneinfo

%if_with java
gij -jar %_datadir/java/javazic.jar -V %version -d zoneinfo/javazi \
  africa antarctica asia australasia europe northamerica pacificnew \
  southamerica backward etcetera systemv \
  %_datadir/javazic/tzdata_jdk/gmt \
  %_datadir/javazic/tzdata_jdk/jdk11_backward
%endif #with java

%install
%makeinstall_std TZDIR=%_datadir/zoneinfo
mv %buildroot%_datadir/zoneinfo{-leaps,/right}
rm %buildroot%_datadir/zoneinfo-posix
mkdir %buildroot%_datadir/zoneinfo/posix
cp -al %buildroot%_datadir/zoneinfo/[A-Z]* %buildroot%_datadir/zoneinfo/posix/
rm %buildroot/usr/bin/zdump
rm %buildroot/usr/sbin/zic

%if_with java
cp -a zoneinfo/javazi %buildroot%_datadir/
%endif #with java

install -pDm755 tzupdate %buildroot%_sbindir/tzupdate

# Hardlink identical files together.
%define __spec_install_custom_post hardlink -vc %buildroot

%check
make -k check_tables

%post -p %_sbindir/tzupdate

%files
%_sbindir/tzupdate
%_datadir/zoneinfo
%doc NEWS README *.html

%if_with java
%files java
%_datadir/javazi
%endif #with java

%changelog
