%define _libexecdir /lib/udev

Name: udev-initramfs
Version: 150
Release: alt19
Summary: udev built with klibc for use in initramfs
License: GPLv2+
Group: System/Configuration/Hardware
Url: http://kernel.org/pub/linux/utils/kernel/hotplug/
AutoReq: yes, noshell
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: mkinitrd-initramfs >= 1:3.0.8-alt1
Requires: klibc-utils-initramfs util-linux-initramfs
BuildRequires: gtk-doc klibc-devel

# Find dependencies on klibc-*.so
%global __find_requires %_libdir/klibc/klibc-find-requires %__find_requires

%define tools ata_id cdrom_id path_id scsi_id usb_id firmware

%description
This package contains a version of udev which is built with klibc,
intended for use in initramfs images generated by mkinitrd.
This package also contains rule files in /etc/udev/initramfs-rules.d/
used by the mkinitrd package when creating initramfs images


%prep
%setup
%patch -p1

cat > klcc.sh <<__EOF__
#!/bin/sh
exec klcc -shared "\$@"
__EOF__
chmod 755 klcc.sh

cat > udev/udev.c <<__EOF__
#include <string.h>
#include <stdio.h>

__EOF__

for s in adm d; do
	sed -i "/^int main(/s/(/_udev$s&/" udev/udev$s.c
	echo "extern int main_udev$s(int argc, char *argv[]);" >> udev/udev.c
done

for s in %tools; do
	sed -i "/^int main(/s/(/_$s&/" extras/$s/$s.c
	echo "extern int main_$s(int argc, char *argv[]);" >> udev/udev.c
done

cat >> udev/udev.c <<__EOF__

int main(int argc, char *argv[])
{
	static const struct {
		const char *n;
		int (*f)(int argc, char *argv[]);
	} *t, tools[] = {
__EOF__

for s in udevadm %tools udevd; do
	echo "		{\"$s\", main_$s}," >> udev/udev.c
done

cat >> udev/udev.c <<__EOF__
		{NULL, NULL}
	};
	const char *n = strrchr(argv[0], '/');

	if (n)
		n++;
	else
		n = argv[0];
	for (t = tools; t->n; t++)
		if (!strcmp(t->n, n))
			return t->f(argc, argv);

	for (t = tools; t->n; t++)
		puts(t->n);
	return 0;
}
__EOF__

echo >> Makefile.am
echo -n "udev_udev_SOURCES = udev/udev.c \$(udev_udevadm_SOURCES) udev/udevd.c" >> Makefile.am
for s in %tools; do
	echo -n " \$(extras_${s}_${s}_SOURCES)" >> Makefile.am
done
echo >> Makefile.am

cat >> Makefile.am <<__EOF__
udev_udev_LDADD = libudev/libudev-private.la
sbin_PROGRAMS = udev/udev
libexec_PROGRAMS =
__EOF__


%build
%define _optlevel s
%add_optflags -fno-asynchronous-unwind-tables
%autoreconf
%configure \
	CC="$PWD/klcc.sh" \
	--sbindir=/lib/mkinitrd/udev/sbin \
	--without-selinux \
	--disable-debug \
	--disable-logging \
	--disable-extras \
	--disable-gtk-doc \
	--disable-introspection \
	--disable-silent-rules
%make_build


%install
%makeinstall_std DESTDIR=%buildroot udevrulesdir=%_sysconfdir/udev/initramfs-rules.d
for s in adm d; do
	ln -s udev %buildroot/lib/mkinitrd/udev/sbin/udev$s
done
install -d -m 0755 %buildroot/lib/mkinitrd/udev/lib/udev
for s in %tools; do
	ln -s ../../sbin/udev %buildroot/lib/mkinitrd/udev/lib/udev/$s
done


%files
/lib/mkinitrd/udev/
%_sysconfdir/udev/initramfs-rules.d/


%changelog
