%def_disable snapshot

%define _name udisks
%define api_ver 2.0
%define _libexecdir %_prefix/libexec
%define _localstatedir %_var

%def_enable introspection
%def_enable acl
# since 2.1.5 it is possible to configure udisks to mount devices
# in /media instead of /run/media but we use own control-based mechanism,
# so this option should never be enabled
%def_disable fhs_media

Name: %{_name}2
Version: 2.6.5
Release: alt0.M80P.1

Summary: Disk Management Service (Second Edition)
License: GPLv2+
Group: System/Libraries
Url: https://github.com/storaged-project/udisks

%if_disabled snapshot
Source: https://github.com/storaged-project/%_name/releases/download/%_name-%version/%_name-%version.tar.bz2
%else
Source: %_name-%version.tar
%endif
Source1: %name.control
# https://bugzilla.altlinux.org/show_bug.cgi?id=33180
Patch: udisks-2.6.4-alt-rules.patch

Obsoletes: %_name

%define glib_ver 2.31.13
%define gi_ver 1.30.0
%define polkit_ver 0.101
%define udev_ver 165
%define libatasmart_ver 0.17
%define dbus_ver 1.4.0

Requires(pre): control
Requires: lib%name = %version-%release
Requires: /lib/udev/rules.d
Requires: /usr/sbin/cryptsetup
Requires: dbus >= %dbus_ver dbus-tools-gui
Requires: mdadm ntfsprogs parted gdisk dosfstools
%{?_enable_acl:Requires: acl}

BuildRequires: intltool gtk-doc gnome-common
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libpolkit-devel >= %polkit_ver
BuildRequires: libatasmart-devel >= %libatasmart_ver
BuildRequires: libudev-devel libgudev-devel >= %udev_ver
BuildRequires: systemd-devel libsystemd-login-devel libsystemd-daemon-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver}
%{?_enable_acl:BuildRequires: libacl-devel}


%description
The udisks project provides a daemon, tools and libraries to access
and manipulate disks and storage devices.

%package -n lib%name
Summary: Dynamic library to access the udisks daemon (Second Edition)
Group: System/Libraries

%description -n lib%name
The udisks project provides a daemon, tools and libraries to access
and manipulate disks and storage devices.

This package contains the dynamic %name library, which provides
access to the udisks daemon.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains the development files for the library lib%name.

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the %name library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the %name library

%package -n lib%name-devel-doc
Summary: Development documentation for lib%name
Group: Development/Documentation
Conflicts: %name < %version
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for lib%name.


%prep
%setup -n %_name-%version
%patch -b .isohibryd
subst 's/mkfs.vfat/mkfs.fat/' src/udiskslinuxfsinfo.c

%build
%autoreconf
%configure --disable-static \
	--enable-gtk-doc \
	%{subst_enable acl} \
	%{?_enable_fhs_media:--enable-fhs-media}
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_localstatedir/run/%name
touch %buildroot%_localstatedir/lib/%name/mtab

# use /media for mounting by default
mkdir -p %buildroot%_sysconfdir/udev/rules.d
cat > %buildroot%_sysconfdir/udev/rules.d/99-alt-%name-media-mount-point.rules <<_EOF_
ENV{ID_FS_USAGE}=="filesystem|other|crypto", ENV{UDISKS_FILESYSTEM_SHARED}="0"
_EOF_

# control support
install -pD -m755 %SOURCE1 %buildroot%_controldir/%name

%find_lang %name

%check
%make check

%pre
if [ -f %_controldir/%name ]; then
%pre_control %name
fi

%post
%post_control -s default %name

%files -f %name.lang
%_sbindir/umount.%name
%_bindir/udisksctl
/lib/udev/rules.d/80-%name.rules
%config(noreplace) %_sysconfdir/%name/%name.conf
%_sysconfdir/udev/rules.d/99-alt-%name-media-mount-point.rules
%dir %_libexecdir/%name
%_libexecdir/%name/udisksd
%_datadir/polkit-1/actions/org.freedesktop.UDisks2.policy
%_datadir/dbus-1/system-services/org.freedesktop.UDisks2.service
%_sysconfdir/dbus-1/system.d/org.freedesktop.UDisks2.conf
%_datadir/bash-completion/completions/udisksctl
%_man1dir/*
%_man5dir/%name.conf.5.*
%_man8dir/*
%attr(0700,root,root) %dir %_localstatedir/lib/%name
%ghost %_localstatedir/lib/%name/mtab
%attr(0700,root,root) %dir %_localstatedir/run/%name
%config %systemd_unitdir/udisks2.service
%config %_controldir/%name
%doc README.md AUTHORS NEWS HACKING

%files -n libudisks2
%_libdir/libudisks2.so.*

%files -n libudisks2-devel
%_libdir/lib%name.so
%_includedir/%name/
%_libdir/pkgconfig/%name.pc

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/udisks2/*

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/UDisks-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/UDisks-%api_ver.gir
%endif

%changelog
