Name: unbound
Version: 1.11.0
Release: alt0.M80P.1
License: BSD
Url: http://unbound.net/
Source: %name-%version.tar
Summary: Validating, recursive, and caching DNS resolver
Group: System/Servers

%define _chrootdir %_localstatedir/%name
%define with_python 1

PreReq: chrooted
PreReq: lib%name = %version-%release

Provides: %name-chroot(%_chrootdir)

BuildRequires: /proc flex gcc-c++ libssl-devel libldns-devel bind-utils libldns-examples splint xxd libexpat-devel libevent-devel
%if %with_python
BuildRequires: python-devel swig
%endif

%description
Unbound is a validating, recursive, and caching DNS resolver.

The C implementation of Unbound is developed and maintained by NLnet
Labs. It is based on ideas and algorithms taken from a java prototype
developed by Verisign labs, Nominet, Kirei and ep.net.

Unbound is designed as a set of modular components, so that also
DNSSEC (secure DNS) validation and stub-resolvers (that do not run
as a server, but are linked into an application) are easily possible.

%package control
Summary: Unbound remote server control
Group: System/Configuration/Other

%description control
Unbound-control performs remote administration on  the  unbound(8)  DNS
server.   It  reads the configuration file, contacts the unbound server
over SSL sends the command and displays the result.

%package -n lib%name
Summary: Library for %name
Group: System/Libraries

%description -n lib%name
This package contains shared libraries used by %name's daemons
and clients.

%package -n lib%name-devel-static
Summary: Static library for %name
Group: System/Libraries
Obsoletes: lib%name-static

%description -n lib%name-devel-static
This package contains static libraries used by %name's daemons
and clients.

%package -n lib%name-devel
Summary: Development package that includes the %name header files
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
The devel package contains the include files

%if %with_python
%package -n python-module-%name
Summary: Python modules and extensions for unbound
Group: Development/Python

%description -n python-module-%name
Python modules and extensions for unbound
%endif

%prep
%setup

%build
# configure with /var/unbound/unbound.conf so that all default chroot,
# pidfile and config file are in /var/unbound, ready for chroot jail set up.
#
# This is a build using libldns builtin version, the resulting binaries
# do not require libldns and this package does not have version dependencies.
# Could be smaller using a dependency on libldns (use --with-ldns=).
%autoreconf

%configure \
	    --with-conf-file=%_chrootdir/unbound.conf \
            --with-pidfile=/run/%name/%name.pid \
	    --with-username=_%name \
	    --with-libevent \
	    --with-pthreads \
%if %with_python
            --with-pythonmodule --with-pyunbound \
%endif
            --enable-sha2
%make

subst 's|# auto-trust-anchor-file:|auto-trust-anchor-file:|g' doc/example.conf

%install
%make DESTDIR=%buildroot install
install -d 0700 %buildroot%_localstatedir/%name
install -d 0755 %buildroot%_initdir
install -d 0755 %buildroot%_sysconfdir/cron.monthly
install -m 0755 %name.init %buildroot%_initdir/unbound
install -p -m 0755 unbound-monthly.cron  %buildroot%_sysconfdir/cron.monthly/unbound-anchor
install -p -m 0644 icannbundle.pem %buildroot%_localstatedir/%name/icannbundle.pem
# add symbolic link from /etc/unbound/unbound.conf -> /var/lib/unbound/unbound.conf
ln -s ..%_chrootdir %buildroot%_sysconfdir/%name

#systemd services
install -D -p -m 0644 unbound.service %buildroot%_unitdir/unbound.service
install -D -p -m 0644 unbound-keygen.service %buildroot%_unitdir/unbound-keygen.service

# Install tmpfiles.d config
install -D -m 0644 tmpfiles-unbound.conf %buildroot%_tmpfilesdir/unbound.conf

# Install directories for easier config file drop in
mkdir -p %buildroot%_chrootdir/{keys.d,conf.d,local.d}
install -p example.com.key %buildroot%_chrootdir/keys.d/
install -p example.com.conf %buildroot%_chrootdir/conf.d/
install -p block-example.com.conf %buildroot%_chrootdir/local.d/

%if %with_python
rm %buildroot%python_sitelibdir/*.la
%endif

%check
%make test

%pre -n lib%name
/usr/sbin/groupadd -r -f _%name
/usr/sbin/useradd -r -g _%name -d %_chrootdir -s /dev/null -n -c "Domain Name Server" _%name >/dev/null 2>&1 ||:

%post
%post_service %name

%preun
%preun_service %name
%files
%doc doc/README doc/CREDITS doc/LICENSE doc/FEATURES doc/Changelog
%_initdir/%name
%_unitdir/*
%_tmpfilesdir/*
%config(noreplace) %_chrootdir/unbound.conf
%attr(0755,root,_%name) %dir %_chrootdir/keys.d
%attr(0755,root,_%name) %dir %_chrootdir/conf.d
%attr(0755,root,_%name) %dir %_chrootdir/local.d
%attr(0664,root,_%name) %config(noreplace) %_chrootdir/keys.d/*.key
%attr(0664,root,_%name) %config(noreplace) %_chrootdir/conf.d/*.conf
%attr(0664,root,_%name) %config(noreplace) %_chrootdir/local.d/*.conf
%_sysconfdir/%name
%_sbindir/*
%_man1dir/*
%_man5dir/*
%_man8dir/*


%exclude %_sbindir/unbound-anchor
%exclude %_sbindir/unbound-control
%exclude %_man8dir/unbound-control.8.*
%exclude %_man8dir/unbound-anchor*

%files control
%_sbindir/unbound-control
%_man8dir/unbound-control.8.*

%files -n lib%name
%attr(1775,root,_%name) %dir %_localstatedir/%name
%config(noreplace) %_sysconfdir/cron.monthly/unbound-anchor
%config(noreplace) %_localstatedir/%name/icannbundle.pem
%_libdir/libunbound*so.*
%exclude %_libdir/libunbound.so
%_sbindir/unbound-anchor
%_man8dir/unbound-anchor*
%_man3dir/*

%files -n lib%name-devel-static
%_libdir/libunbound.a

%files -n lib%name-devel
%_includedir/*
%_libdir/libunbound.so
%_libdir/pkgconfig/*

%if %with_python
%files -n python-module-%name
%python_sitelibdir/*
%doc libunbound/python/examples/*
%doc pythonmod/examples/*
%endif

%changelog
