%define pkgname unicorn

Name: %pkgname
Version: 5.3.0
Release: alt0.M80P.4
Summary: Unicorn: Rack HTTP server for fast clients and Unix
License: GPL2
Group: System/Servers
Url: http://unicorn.bogomips.org/

Source: %pkgname-%version.tar.gz

BuildRequires: libruby-devel ragel rubygems ruby-tool-setup

%description
Unicorn is an HTTP server for Rack applications designed to only serve
fast clients on low-latency, high-bandwidth connections and take
advantage of features in Unix/Unix-like kernels. Slow clients should
only be served by placing a reverse proxy capable of fully buffering
both the the request and response in between Unicorn and slow clients.

%package doc
Summary: Documentation files for %pkgname
Group: Documentation
BuildArch: noarch

%description doc
Documentation files for %pkgname

%prep
%setup -n %pkgname-%version
%update_setup_rb

%build
%make_build ext/unicorn_http/unicorn_http.c
%ruby_config
%ruby_build
#for t in test/*_test.rb; do
#ruby_test_unit -Ilib:test "$t"
#done

%install
%ruby_install
%rdoc lib/
# Remove unnecessary files
rm -f %buildroot%ruby_ri_sitedir/{Object/cdesc-Object.ri,cache.ri,created.rid}

%files
%doc ISSUES README TUNING KNOWN_ISSUES FAQ DESIGN examples*
%ruby_sitelibdir/*
%ruby_sitearchdir/*
%_bindir/*

%files doc
%ruby_ri_sitedir/Unicorn*

%changelog
