%define rname unixODBC

Name: unixODBC-compat
Version: 2.2.12
Release: alt11

Summary: Unix ODBC driver manager and database drivers
Summary(ru_RU.UTF-8): Система управления драйверами ODBC для unix 
Group: Databases
License: LGPL
Url: http://www.unixODBC.org

Requires: lib%rname = %version-%release
Provides: MyODBC = %version-%release
Obsoletes: unixODBC-contrib

Source0: http://www.unixodbc.org/%rname-%version.tar.gz

Source1: %rname-odbcinst.ini
Source2: %rname-DataManager.desktop
Source3: %rname-ODBCConfig.desktop

Patch1: %rname-depcomp.patch
Patch2: %rname-parserupdate.patch
Patch3: %rname-2.2.11-stricmp.patch
Patch4: %rname-2.2.11-symbols.patch
Patch5: %rname-2.2.12-alt-ltdl.patch

# Automatically added by buildreq on Mon Feb 14 2011
BuildRequires: flex gcc-c++ libltdl7-devel libqt3-devel libreadline-devel

%description
UnixODBC is a free/open and solution for ODBC. ODBC is an open
specifican for providing application developers with a predictable API
with which to access Data Sources. Data Sources include SQL Servers and
any Data Source with an ODBC Driver.

%description -l ru_RU.UTF-8
UnixODBC - это свободное ODBC решение.
ODBC представляет из себя открытую спецификацию для разработки
приложений с универсальным API для доступа к базам данных.
Базы данных включает в себя сервера SQL и другие источники данных,
поддерживаемые ODBC драйверами.

%package -n lib%{rname}1
Summary: Shared libraries for ODBC
Summary(ru_RU.UTF-8): Разделяемые библиотеки для ODBC
Group: Development/Databases
Provides:  lib%{rname} = %version-%release
Obsoletes: lib%{rname} < %version-%release

%description -n lib%{rname}1
unixODBC aims to provide a complete ODBC solution for the Linux platform.
This package contains the shared libraries.

%description -n lib%{rname}1 -l ru_RU.UTF-8
unixODBC представляет из себя полную спецификацию ODBC для Linux платформы.
Этот пакет содержит в себе раделяемые библиотеки.

%prep
%setup -q -n %rname-%version 
rm -r libltdl
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%build
export QTDIR=%_qt3dir
%autoreconf
%configure \
	--with-gnu-ld \
	--enable-threads \
	--enable-ltdllib \
    --with-qt-libraries=%_qt3dir/lib \
	--disable-static
%make_build

%install
%makeinstall_std

install -pD -m644 %SOURCE1 %buildroot%_sysconfdir/odbcinst.ini
subst "s,@libdir@,%_libdir," %buildroot%_sysconfdir/odbcinst.ini

install -pD -m644 %SOURCE2 %buildroot%_desktopdir/DataManager.desktop
install -pD -m644 %SOURCE3 %buildroot%_desktopdir/ODBCConfig.desktop
install -pD -m644 DataManager/LinuxODBC.xpm %buildroot%_niconsdir/LinuxODBC.xpm
install -pD -m644 DataManager/ODBC.xpm %buildroot%_miconsdir/odbc.xpm

find doc -name Makefile\* -delete

%files -n lib%{rname}1
%_libdir/lib*.so.*
%exclude %_libdir/libodbcpsql.so.2*

%changelog
