%define chroot %_localstatedir/%name

Name: unreal
Version: 3.2.8.1
Release: alt1.qa1

Summary: UnrealIRCD is a powerful irc daemon
License: GPL
Group: Networking/IRC

URL: http://www.unrealircd.org
Source0: Unreal%version.tar
Source1: %name.init
Source6: uircd.chroot.all
Source7: uircd.chroot.conf
Source8: uircd.chroot.lib
Source9: uircd.chroot.bin
Source10: uircd.chroot.log
Source11: uircd.motd
Source12: uircd.rules
Source13: uircd.tune
Source14: %name.sysconfig

# Automatically added by buildreq on Wed Dec 05 2007
BuildRequires: libssl-devel openssl zlib-devel

PreReq: /etc/chroot.d
Requires: chrooted openssl libssl zlib cert-sh-functions

%description
Unreal was created from the Dreamforge IRCd that was
formerly used by the DALnet IRC Network. Over the years,
many new and exciting features have been added to Unreal.
UnrealIRCd is designed to be an advanced IRCd, so it is
probably not the best choice for beginners.

%package doc
Summary: Documentation files for Unreal IRC daemon
Summary(ru_RU.KOI8-R):  irc  Unreal
Group: Networking/IRC
BuildArch: noarch
Provides: unreal-doc = %version-%release

%description doc
Documentation files for Unreal IRC daemon

%prep
%setup -n Unreal3.2
find . -type d -name CVS -print0 | xargs -0 rm -rf -- ||:

%build 
%configure \
	--with-showlistmodes \
	--enable-nospoof \
	--enable-hub \
	--enable-ssl \
	--enable-ziplinks \
	--enable-prefixaq \
	--with-listen=5 \
	--with-dpath=%chroot \
	--with-spath=%_sbindir/uircd \
	--with-nick-history=2000 \
	--with-sendq=3000000 \
	--with-bufferpool=18 \
	--with-permissions=0600 \
	--with-fd-setsize=1024 \
	--enable-dynamic-linking
	
%make_build

%install

install -pD -m0755 %SOURCE1 %buildroot%_initdir/%name
install -pD -m0755 %SOURCE14 %buildroot%_sysconfdir/sysconfig/%name
mkdir -p %buildroot%_sysconfdir/unrealircd/{aliases,ssl}
mkdir -p %buildroot%_sbindir
mkdir -p %buildroot%_libdir/%name/modules
mkdir -p %buildroot%chroot/aliases
mkdir -p %buildroot%chroot%_sysconfdir
mkdir -p %buildroot%chroot/dev
mkdir -p %buildroot%chroot%_var/run
mkdir -p %buildroot%chroot/{lib,lib64}
mkdir -p %buildroot%chroot/tmp
mkdir -p %buildroot%chroot/bin
mkdir -p %buildroot%chroot/modules
mkdir -p %buildroot%chroot%_sbindir
install -pD -m640 doc/example.conf %buildroot%_sysconfdir/unrealircd/unrealircd.conf
install -pD -m640 %SOURCE11 %buildroot%_sysconfdir/unrealircd/uircd.motd
install -pD -m640 %SOURCE12 %buildroot%_sysconfdir/unrealircd/uircd.rules
install -pD -m640 %SOURCE13 %buildroot%_sysconfdir/unrealircd/ircd.tune
cp *.conf %buildroot%_sysconfdir/unrealircd/
cp aliases/*.conf %buildroot%_sysconfdir/unrealircd/aliases/
cp src/modules/*.so %buildroot%_libdir/%name/modules/
cp src/ircd %buildroot%_sbindir/uircd
install -m 0750 -D %SOURCE6 %buildroot%_sysconfdir/chroot.d/%name.all
install -m 0750 -D %SOURCE7 %buildroot%_sysconfdir/chroot.d/%name.conf
install -m 0750 -D %SOURCE8 %buildroot%_sysconfdir/chroot.d/%name.lib
install -m 0750 -D %SOURCE9 %buildroot%_sysconfdir/chroot.d/%name.bin
install -m 0750 -D %SOURCE10 %buildroot%_sysconfdir/chroot.d/%name.log
install -pDm0755 networks/makenet %buildroot%_bindir/%name-makenet

touch %buildroot%_sysconfdir/unrealircd/ssl/unreal.cert
touch %buildroot%_sysconfdir/unrealircd/ssl/unreal.csr
touch %buildroot%_sysconfdir/unrealircd/ssl/unreal.key

%pre
if [ $1 = 1 ]; then
	%_sbindir/groupadd -r uircd >/dev/null 2>&1 ||:
	%_sbindir/useradd -M -r uircd -g uircd -s /dev/null -c "Unreal IRC server" \
	-d %_localstatedir/%name >/dev/null 2>&1 ||:
fi

%post
%post_service %name

%preun
%preun_service %name
subst 's,-a %chroot/dev/log,,' %_sysconfdir/sysconfig/syslogd >/dev/null 2>&1 ||:

%files
%doc Changes Donation INSTALL.REMOTEINC README
%config %_sysconfdir/chroot.d/*
%config(noreplace) %_sysconfdir/unrealircd/*.conf
%config(noreplace) %_sysconfdir/unrealircd/ircd.tune
%config(noreplace) %_sysconfdir/unrealircd/uircd*
%config(noreplace) %_sysconfdir/unrealircd/aliases/*.conf
%config(noreplace) %_sysconfdir/sysconfig/%name
%dir %_sysconfdir/unrealircd
%dir %_sysconfdir/unrealircd/aliases
%dir %attr(750,root,uircd) %_sysconfdir/unrealircd/ssl
%ghost %attr(640,root,uircd) %verify(not md5 mtime size) %_sysconfdir/unrealircd/ssl/unreal.cert
%ghost %attr(640,root,uircd) %verify(not md5 mtime size) %_sysconfdir/unrealircd/ssl/unreal.csr
%ghost %attr(640,root,uircd) %verify(not md5 mtime size) %_sysconfdir/unrealircd/ssl/unreal.key
%_initdir/%name
%_libdir/%name/modules/commands.so
%_libdir/%name/modules/cloak.so
%exclude %_libdir/%name/modules/m_*.so
%_sbindir/uircd
%_bindir/%name-makenet
%dir %attr(1770,root,uircd) %chroot
%dir %chroot/etc
%dir %chroot/aliases
%dir %chroot/dev
%dir %chroot%_var/run
%dir %chroot/lib
%dir %chroot/lib64
%dir %chroot/tmp
%dir %chroot/usr
%dir %chroot/var
%dir %chroot/modules
%dir %chroot%_sbindir

%files doc
%doc doc

%changelog
