# Emacs, look here: -*- coding: cyrillic-cp1251 -*-
Name: urlview
Version: 0.9
Release: alt2
Serial: 1

Group: Networking/Other
%define CommonSummary A URL extractor/viewer for use with Mutt
##Offset several bytes before Russian characters.############################
%define CommonSummaryRU    URL-   Mutt
%if_with slang
Summary: %CommonSummary (SLang variant).
Summary(ru_RU.CP1251): %CommonSummaryRU (  SLang).
%else
Summary: %CommonSummary (ncurses variant).
Summary(ru_RU.CP1251): %CommonSummaryRU (  ncurses).
%endif
License: GPL

Packager: Alexey Morsov <swi@altlinux.ru>

Requires: url_handler
Requires: common-licenses

Source: rsync://ftp.mutt.org::mutt/contrib/%name-%version.tar.bz2

# From Debian urlview-0.9-2.1
Source1: %name-0.9-htmlworkaround.debian.txt

# From Mdk urlview-0.9-4mdk
Patch1: %name-0.9-comma.patch

# From Debian urlview-0.9-2.1
Patch3: %name-0.9-sysconf.debian.patch

# From RedHat mutt-1.2.5i-17
Patch5: %name-0.9-correct-c.redhat.patch

# Fix aditional \n in the end of the url
Patch6: %name-0.9-cr.patch

# throw the dependency on libtinfo away (since libncurses-devel requires it)
# Automatically added by buildreq on Sun Sep 21 2003
BuildRequires: OpenSP sgml-tools
BuildRequires: groff

%if_with slang
BuildRequires(build): libslang-devel
%else
BuildRequires(build): libncurses-devel 
%endif
BuildRequires(build): automake = 1.4
%set_automake_version 1.4

%description
%name extracts URLs from a given text file, and presents a menu
of URLs to view using a user specified command.

%if_with slang
(Linked with S-Lang library.)
%else
(Linked with ncurses library.)
%endif

%description -l ru_RU.CP1251
%name  URL-      
     URL- 
      .

%if_with slang
(   S-Lang.)
%else
(   ncurses.)
%endif

%prep
%setup
%patch1 -p1 -b .comma
%patch3 -p1 -b .sysconf
%patch5 -p1 -b .correct-c
%patch6 -p1

%build

%configure %{?_with_slang}

%make_build

# Generate HTML docs:
sgml2html %name.sgml \
    && %__mv %name.html %name.bad.html \
    && %__install -m0644 %SOURCE1 %name.html \
    && cat %name.bad.html >> %name.html

%install
mkdir -p "$RPM_BUILD_ROOT"{%_bindir,%_mandir/man1,%_sysconfdir/%name}
%makeinstall
install -p -m644 %name.conf.suse \
    "$RPM_BUILD_ROOT"%_sysconfdir/%name/system.%name

# link the license
%__ln_s -f %_licensedir/GPL-2 COPYING


%files

#dir %_sysconfdir/%name - belongs to url_handler pkg since 0.9-ipl8mdk
%config(noreplace) %_sysconfdir/%name/system.%name

%_bindir/*

%_mandir/man?/*
%doc AUTHORS ChangeLog README sample.%name

# Hack for symlink ;-)
%doc --no-dereference COPYING

%doc %name.html

%triggerpostun  -- %name < 0.9-ipl3mdk
moved="$(
    for f in %_sysconfdir/%name.conf*; do
	[ -e "$f" ] \
	    && install -D "$f" "%_sysconfdir/%name/old/${f##*/}" \
	    && { rm -f "$f"; echo -n "$f "; }
    done
)"
if [ "$moved" ]; then
    echo "Moving $moved to %_sysconfdir/%name/old/"
fi

%changelog
