# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%define kernel_version   4.9
%define kernel_source /usr/src/kernel/sources/kernel-source-%kernel_version.tar
%define source_dir tools/usb/usbip

Name: usbip
Summary: Utility for manage usbip devices
Version: 2.0.4
Release: alt3.M80P.4

%define lname lib%name

Group: System/Configuration/Networking
License: GPLv2+
Url: http://www.kernel.org

Source: %name-%version.tar

Packager: Pavel Vainerman <pv@altlinux.org>

BuildRequires: libudev-devel libwrap-devel

BuildRequires: kernel-source-%kernel_version

%description
On a USB/IP  server, devices can be listed, bound, and unbound
using this program. On a USB/IP client, devices exported by USB/IP
servers can be listed, attached and detached.

%package -n %{name}d
Summary: %name server daemon
Group: System/Configuration/Networking
Requires: %lname = %version-%release

%description -n %{name}d
%{name} server daemon.

%package -n %lname
Summary: %name shared library
Group: System/Libraries

%description -n %lname
%name shared library.

%package -n %lname-devel
Summary: %name devel files
Group: Development/C

%description -n %lname-devel
%name devel files.

%package -n %lname-devel-static
Summary: %name static library
Group: Development/C
Requires: %lname-devel = %version-%release

%description -n %lname-devel-static
%name static library.

%package client
Summary: %name conf files for client side
Group: System/Configuration/Networking
BuildArch: noarch

%description client
%name conf files for client side


%prep
%setup
tar -xvf %kernel_source kernel-source-%kernel_version/%source_dir
cp -rf kernel-source-%kernel_version/%source_dir/* ./
rm -rf kernel-source-%kernel_version

%build
 %__subst 's| -Werror||g' configure.ac
./autogen.sh
%configure --with-usbids-dir=%_datadir/misc
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_sysconfdir/sysconfig
mkdir -p %buildroot%_unitdir

install -Dp -m644 usbipd %buildroot%_sysconfdir/sysconfig/%{name}d
install -Dp -m644 usbipd.service %buildroot%_unitdir/%{name}d.service
install -D -m0644 usbipd.modules.conf %buildroot%_sysconfdir/modules-load.d/usbipd.modules.conf
install -D -m0644 usbip-client.modules.conf %buildroot%_sysconfdir/modules-load.d/usbip-client.modules.conf

%files
%_sbindir/%name
%_man8dir/usbip.8*
%doc README

%files client
%_sysconfdir/modules-load.d/usbip-client.modules.conf

%files -n %{name}d
%_sbindir/%{name}d
%_sysconfdir/sysconfig/%{name}d
%_sysconfdir/modules-load.d/usbipd.modules.conf
%_unitdir/%{name}d.service
%doc README
%_man8dir/usbipd.8*

%files -n %lname
%_libdir/*.so.*

%files -n %lname-devel
%_includedir/*
%_libdir/*.so

%files -n %lname-devel-static
%_libdir/*.a

%changelog
