# Vala is written in Vala itself. To solve bootstrap problem we pre-compile it to C
# and use those C sources during bootstrap phase. Next package rebuilds must be done
# without bootstrap define.
%def_with bootstrap
%define api_ver 0.36

Name: vala
Version: 0.36.4
Release: alt0.M80P.1
Group: Development/C
Summary: Vala is a programming language which makes GNOME programming easy
License: LGPL
Url: https://wiki.gnome.org/Projects/Vala
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %name-%version.tar
%if_with bootstrap
Patch: %name-%version-%release-pregenerated.patch
%endif
Patch1: %name-%version-%release-fixes.patch
PreReq: rpm-build-vala
PreReq: vapi-common = %version-%release
BuildRequires: flex glib2-devel >= 2.32.0  libgio-devel xsltproc dbus-tools-gui gobject-introspection-devel
BuildPreReq: /proc rpm-build-vala
%if_without bootstrap
BuildRequires: vala >= 0.25.1
%endif

%description
Vala is a programming language that aims to bring modern programming language
features to GNOME developers without imposing any additional runtime requirements and
without using a different ABI compared to applications and libraries written in C.

Vala is designed to allow access to existing C libraries, especially GObject-based
libraries, without the need for runtime bindings. Each to be used library requires a Vala
API file at compile-time, containing the class and method declarations in Vala
syntax. Vala currently comes with experimental bindings for GLib and GTK+. It's planned to
provide generated bindings for the full GNOME Platform at a later stage.

%package -n vapi-common
Summary: Common empty package with dir for vapi files
Group: Development/Other
BuildArch: noarch
Provides: %_datadir/vala/vapi

%description -n vapi-common
Common empty package with dir for vapi files.

%package -n lib%name-devel
Summary: Development files for embedding Vala translator
Group: Development/C
Requires: %name = %version-%release

%description -n lib%name-devel
Vala is a programming language that aims to bring modern programming language
features to GNOME developers without imposing any additional runtime requirements and
without using a different ABI compared to applications and libraries written in C.

This package contains infrastructure files to embed Vala translator into your programs

%package doc
Summary: Documentation for Vala programming language
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description doc
Vala is a programming language that aims to bring modern programming language
features to GNOME developers without imposing any additional runtime requirements and
without using a different ABI compared to applications and libraries written in C.

This package contains Vala documentation for GNOME DevHelp.

%package tools
Summary: Tools for creating Vala API specifications and new projects
Group: Development/C
Requires: %name = %version-%release

%description tools
Vala is a programming language that aims to bring modern programming language
features to GNOME developers without imposing any additional runtime requirements and
without using a different ABI compared to applications and libraries written in C.

This packages contains additional tools to generate Vala projects and API specifications
for existing C and C++ libraries.

%prep
%setup -q
%patch1 -p1

# Automake now requires to have ChangeLog and m4, fake them
touch ChangeLog
mkdir -p m4

# version in .tarball-version file
echo "%version" > .tarball-version

# whether external bootstrapping is in use or not we always want to build
# a compiler with the compiler itself. So first compile an intermediate
# (bootstrapping) compiler in a separate directory

%if_with bootstrap
# create a copy of sources. it's not that neat but otherwise
# our bootstrapping patch would "taint" sources used for
# the final build

mkdir bootstrap-build
# copy everythig but bootstrap-build recursively to bootstrap-build
find ./ -mindepth 1 -maxdepth 1 \( -name 'bootstrap-*' -prune -o \
	-exec cp -pr {} bootstrap-build \; \)
cd bootstrap-build
# apply pregenerated patch
%patch0 -p1
cd ..
%else
# use the directory for the "off-source" build
mkdir bootstrap-build
%endif

%build

autoreconf -v --install

# build an intermediate version of the compiler
BSINSTALL=$(pwd)/bootstrap-install
mkdir "$BSINSTALL"

cd bootstrap-build

%if_with bootstrap
autoreconf -v --install
./configure --prefix="$BSINSTALL"

# Make stamps for pregenerated source code so that Vala build system would not run valac again
for i in vala codegen ccode gee ; do
    touch $i/$i.vala.stamp
done
touch vapigen/{vapigen,vapicheck}.vala.stamp
touch compiler/valac.vala.stamp
%else
../configure --prefix="$BSINSTALL"
%endif

%make
make install
cd ..

# now build a pristine variant of the compiler to be packaged
OLD_PATH="$PATH"
export PATH="$BSINSTALL/bin:$PATH"
%configure
# Delete stamps to force re-generation of C code with bootstrapped valac
find . -name '*.stamp' | xargs -r rm
%make
rm -rf bootstrap-build "$BSINSTALL"
export PATH="$OLD_PATH"

# Perform language environment tests
%check
%make check

%install
%make DESTDIR=%buildroot install
# own this directory for third-party *.vapi files
mkdir -p %buildroot%_datadir/vala/vapi

%files
%_bindir/valac
%_bindir/valac-%api_ver
%_bindir/vala
%_bindir/vala-%api_ver
%_libdir/libvala-%api_ver.so.*
%_man1dir/valac*
%dir %_datadir/vala-%api_ver
%dir %_datadir/vala-%api_ver/vapi
%_datadir/vala-%api_ver/vapi/*
%doc AUTHORS COPYING NEWS README THANKS

%files -n vapi-common
%dir %_datadir/vala
%dir %_datadir/vala/vapi

%files -n lib%name-devel
%_includedir/vala-%api_ver
%_pkgconfigdir/*.pc
%_libdir/*.so
%_datadir/aclocal/*.m4
%exclude %_pkgconfigdir/vapigen*.pc
%exclude %_datadir/aclocal/vapigen.m4

%files doc
%_datadir/devhelp/books/%name-%api_ver

%files tools
%_bindir/vapigen
%_bindir/vapigen-%api_ver
%_bindir/vala-gen-introspect
%_bindir/vala-gen-introspect-%api_ver
%_bindir/vapicheck
%_bindir/vapicheck-%api_ver
%_pkgconfigdir/vapigen*.pc
%_datadir/aclocal/vapigen.m4
%_datadir/vala/Makefile.vapigen
%_libdir/vala-%api_ver/gen-introspect-%api_ver
%_man1dir/vala-gen-introspect*
%_man1dir/vapigen*

%changelog
