%define cvsdate 20040107
%undefine cvsdate
%define ver_major 0.7
%def_disable static

Name: vcdimager
Version: %ver_major.24
%define release alt1.1

%ifdef cvsdate
Release: %{release}cvs%cvsdate
%else
Release: %release
%endif

Summary: VideoCD (pre-)mastering and ripping tool
Group: Video
License: GPL
Url: http://%name.org

%ifdef cvsdate
Source: %url/pub/%name/%name%{ver_major}_UNSTABLE/%name-%version-%cvsdate.tar.gz
%else
Source: ftp://ftp.gnu.org/gnu/%name/%name-%version.tar.gz
%endif

%define libcdio_ver 0.72

Requires: libvcd = %version-%release

BuildPreReq: help2man makeinfo
BuildPreReq: libcdio-devel >= %libcdio_ver

BuildRequires: gcc-c++ libcdio-devel libpopt-devel
BuildRequires: libxml2-devel zlib-devel
#BuildRequires: tetex-core tetex-latex

%description
GNU VCDImager is a full-featured mastering suite for authoring,
disassembling and analyzing Video CD's and Super Video CD's.

The core functionality consists of directly making Video CD
BIN/CUE-style CD images from mpeg files, which (after being written to
CDR(W) media) can be played on standalone VCD players or DVD players
and on computers running GNU/Linux, MacOS, Win32 or any other OS
capable of accessing VCD's. BIN/CUE images can be burned with [cdrdao]
(please use a recent version, since older ones do not support
BIN/CUE-style cuesheets) under GNU/Linux (and other supported
platforms by cdrdao, e.g. freeBSD, Irix, Solaris and even win32)

vcdimager   generates simple pbc-less VCD and SVCD disc images directly
vcddebug    Analyzing tool and report generator for VCD and SVCD discs.
vcdxgen     XML VCD-description generator
vcdxbuild   Builds a VCD/SVCD according to a supplied XML control file.
vcdxrip     Reverses the process for a given VCD or SVCD disc.
vcdxminfo   Debugging tool for displaying MPEG stream properties.
vcdinfo     Dispalys information about VCD.
cdxa2mpeg   Simple tool for converting RIFF CDXA file to plain mpeg.

%package -n libvcd
Summary: Libraries for %name
Group: System/Libraries
Requires: libcdio >= %libcdio_ver

%description -n libvcd
This package provides shared libraries required for %name to work.

%package -n libvcd-devel
Summary: Development files for libvcd.
Group: Development/C
Requires: libvcd = %version-%release
Requires: libcdio-devel >= %libcdio_ver

%description -n libvcd-devel
This package provides files to use for development programs using libvcd.

%package -n libvcd-devel-static
Summary: Static versions of vcd libraries
Group: Development/C
Requires: libvcd-devel = %version-%release

%description -n libvcd-devel-static
This package provides libraries to use for development programs
statically linked against libvcd.

%prep
%ifndef cvsdate
%setup
%else
%setup -n %name
pushd docs
%__cp  version.texi version-vcd-info.texi
%__cp  version.texi version-vcdxrip.texi
popd
%endif

# hack to fix version-script generation
%__sed -i 's|\(\$(patsubst %%lo,%%o,\)\(\$(lib.*_la_OBJECTS))\)|\1$(patsubst %%,.libs/%%,\2)|' lib/Makefile*

%build
%ifdef cvsdate
NOCONFIGURE=1 ./autogen.sh
%endif
%autoreconf
%configure \
    %{subst_enable static}

%make_build
#%make_build -C docs pdf

%install
%makeinstall

%if 0
# build actual man pages.
export LD_LIBRARY_PATH=lib/.libs

for f in %buildroot%_bindir/*; do
    help2man -N \
    --manual="VCDIMAGER CDIO Branch" \
    "$f" > %buildroot%_man1dir/`basename "$f"`.1
done
%endif

# remove non-packaged files
%__rm -f %buildroot%_infodir/dir

%files
%_bindir/*
%_infodir/*.info*
%_man1dir/*
%doc AUTHORS BUGS FAQ TODO ChangeLog NEWS README THANKS
#%doc docs/*.pdf

%files -n libvcd
%_libdir/*.so.*

%files -n libvcd-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%if_enabled static
%files -n libvcd-devel-static
%_libdir/*.a
%endif

%changelog
