Name: vdr
Version: 2.2.0
Release: alt1

Summary: Digital satellite receiver box with advanced features
License: GPL
Group: Video
Url: http://www.tvdr.de

Source: %name-%version-%release.tar

BuildRequires: gcc-c++
BuildRequires: fontconfig-devel libalsa-devel libcap-devel libfreetype-devel libjpeg-devel
BuildRequires: libncursesw-devel libssl-devel libbluray-devel libalsa-devel libudev-devel
BuildRequires: libavcodec-devel libavformat-devel libavutil-devel libswscale-devel libpostproc-devel
BuildRequires: libGraphicsMagick-c++-devel libvdpau-devel libxine2-devel libzvbi-devel
BuildRequires: libGL-devel libGLU-devel libglut-devel libX11-devel libXext-devel
BuildRequires: libXinerama-devel libXrandr-devel libXrender-devel libXv-devel
BuildRequires: boost-devel libupnp-devel libtntnet-devel libtntdb-devel libdbus-glib-devel perl-Date-Manip
BuildRequires: libvdpau-devel libxcb-devel libxcbutil-devel libxcbutil-icccm-devel
BuildRequires: libavresample-devel libcurl-devel libcxxtools-devel libpcrecpp-devel

%description
VDR, Video Disc Recorder, enables you to build a powerful set-top box on your own
using Linux and a DVB card. It incorporates basic features, such as watching TV,
recording and time-shifting, plus advanced features, including MP3/Ogg playback,
playback of all video formats supported by MPlayer and backup of the recorded
material to MPEG-4, video CD or DVD.

%package devel
Summary: Development part of VDR
Group: Development/C

%package plugin-sc
Summary: VDR softcam plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-enigmang
Summary: VDR theme
Group: Video
Requires: vdr = %version-%release

%package plugin-epgsync
Summary: VDR EPG sync plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-femon
Summary: VDR femon plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-iptv
Summary: VDR IPTV plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-live
Summary: VDR LIVE plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-manager
Summary: VDR manager plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-pvrinput
Summary: VDR pvrinput plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-remoteosd
Summary: VDR remote OSD plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-remotetimers
Summary: VDR remote timers plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-softhddevice
Summary: VDR HD-capable ffmpeg plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-streamdev
Summary: VDR streamdev plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-text2skin
Summary: VDR skin rendering plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-ttxtsubs
Summary: VDR teletext subtitles plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-upnp
Summary: VDR UPnP/DLNA plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-vnsiserver
Summary: VDR Network StreamingInterface
Group: Video
Requires: vdr = %version-%release

%package plugin-wirbelscan
Summary: VDR wirbelscan plugin
Group: Video
Requires: vdr = %version-%release

%package plugin-xineliboutput
Summary: VDR X11 and framebuffer frontend
Group: Video
Requires: vdr = %version-%release

%package plugin-xine
Summary: Xine plugins for use with VDR frontends
Group: Video

%package fbfe
Summary: VDR framebuffer frontend
Group: Video
Requires: vdr-plugin-xine = %version-%release
 
%package sxfe
Summary: VDR X11 frontend
Group: Video
Requires: vdr-plugin-xine = %version-%release

%description devel
Header and pkgconfig files of VDR

%description plugin-sc
Softcam plugin  for the Video Disk Recorder (VDR).

%description plugin-enigmang
EnigmaNG standalone skin for the Video Disk Recorder (VDR).

%description plugin-epgsync
imports EPG data from remote VDR server

%description plugin-femon
DVB Frontend Status Monitor plugin for the Video Disk Recorder (VDR).

%description plugin-iptv
IPTV plugin for the Video Disk Recorder (VDR).

%description plugin-live
Live Interactive VDR Environment -- web inteface for the Video Disk Recorder (VDR).

%description plugin-manager
Manager plugin for the Video Disk Recorder (VDR).

%description plugin-pvrinput
Analog PVR-like cards (ivtv, cx18 etc) support for the Video Disk Recorder (VDR).

%description plugin-remoteosd
Remote OSD plugin for the Video Disk Recorder (VDR).

%description plugin-remotetimers
VDR timers manipulations across VDR instances

%description plugin-softhddevice
HD-capable (VDPAU) softdevice plugin for the Video Disk Recorder (VDR).

%description plugin-streamdev
Streaming server and client plugins for the Video Disk Recorder (VDR).

%description plugin-text2skin
Plugin designed to load and interpret a set of files describing the
layout of the On Screen Display.

%description plugin-ttxtsubs
Teletext subtitles plugin for the Video Disk Recorder (VDR).

%description plugin-upnp
This plugin extends the VDR with the possibility to act as an UPnP/DLNA
Media Server. It will serve VDR's contents in the network to any UPnP-AV
and DLNA capable devices.

%description plugin-vnsiserver
Network streaming interface for the Video Disk Recorder (VDR).

%description plugin-wirbelscan
This plugin performs a channel scans for digital terrestrial and digital
cable TV and analog ivtv cards, satellite is also supported.

%description plugin-xineliboutput
X11 and Linux framebuffer front-end for VDR.
Plugin displays video and OSD in X/Xv/XvMC window or framebuffer.
Support for local and remote frontends.
Built-in image and media player supports playback of most known 
media files (avi/mp3/divx/jpeg/...), DVDs and radio/video streams
(http, rtsp, ...) directly from VDR.

%description fbfe
Linux framebuffer front-end for VDR.

%description sxfe
X11 front-end for VDR.

%description plugin-xine
Additional Xine plugins for use with VDR frontends.

%define docdir		%_defaultdocdir/%name-%version
%define	confdir		%_sysconfdir/vdr
%define	plugindir	%_libdir/vdr
%define	resdir		%_datadir/vdr
%define videodir	%_localstatedir/vdr

%prep
%setup
sed -e 's,^#PREFIX.\+$,PREFIX = %prefix,' \
    -e 's,^#BINDIR.\+$,BINDIR = %_bindir,' \
    -e 's,^#INCDIR.\+$,INCDIR = %_includedir,' \
    -e 's,^#LIBDIR.\+$,LIBDIR = %plugindir,' \
    -e 's,^#LOCDIR.\+$,LOCDIR = %_datadir/locale,g' \
    -e 's,^#MANDIR.\+$,MANDIR = %_mandir,' \
    -e 's,^#PCDIR.\+$,PCDIR = %_pkgconfigdir,' \
    -e 's,^#RESDIR.\+$,RESDIR = %resdir,g' \
    -e 's,^#VIDEODIR.\+$,VIDEODIR = %videodir,g' \
    -e 's,^#CONFDIR.\+$,CONFDIR = %confdir,g' \
    -e 's,^#CACHEDIR.\+$,CACHEDIR = %_cachedir/vdr,g' \
    -e 's,^\(CFLAGS[[:blank:]]\+[^[:blank:]]\+[[:blank:]]\+\)\(.\+$\),\1%optflags \2,' \
    -e 's,^\(CXXFLAGS[[:blank:]]\+[^[:blank:]]\+[[:blank:]]\+\)\(.\+$\),\1%optflags \2,' \
    < Make.config.template > Make.config

sed -i 's,^IMAGELIB.\+$,IMAGELIB = graphicsmagick,' PLUGINS/src/text2skin/Makefile

%build
(cd PLUGINS/src/xineliboutput && sh configure)

%make_build

%install
make install DESTDIR=%buildroot

mkdir -p %buildroot%docdir %buildroot%confdir/plugins %buildroot%confdir/themes
cp -p CONTRIBUTORS HISTORY INSTALL MANUAL PLUGINS.html README* UPDATE* %buildroot%docdir

mkdir -p %buildroot%docdir/sc %buildroot%confdir/plugins/sc
cp -p PLUGINS/src/sc/README* %buildroot%docdir/sc
cp -a PLUGINS/src/sc/examples %buildroot%docdir/sc

mkdir -p %buildroot%docdir/enigmang %buildroot%confdir/plugins/skinenigmang
cp -p PLUGINS/src/enigmang/README %buildroot%docdir/enigmang
cp -p PLUGINS/src/enigmang/themes/* %buildroot%confdir/themes/

mkdir -p %buildroot%docdir/epgsync
cp -p PLUGINS/src/epgsync/README %buildroot%docdir/epgsync

mkdir -p %buildroot%docdir/femon
cp -p PLUGINS/src/femon/README %buildroot%docdir/femon

mkdir -p %buildroot%docdir/iptv
cp -p PLUGINS/src/iptv/README %buildroot%docdir/iptv
cp -a PLUGINS/src/iptv/iptv %buildroot%confdir/plugins

mkdir -p %buildroot%docdir/live %buildroot%confdir/plugins/live
cp -p PLUGINS/src/live/README %buildroot%docdir/live
cp -a PLUGINS/src/live/live %buildroot%resdir/plugins

mkdir -p %buildroot%docdir/manager %buildroot%confdir/plugins/manager
cp -p PLUGINS/src/manager/README %buildroot%docdir/manager
touch %buildroot%confdir/plugins/manager/vdrmanager.conf

mkdir -p %buildroot%docdir/pvrinput
cp -p PLUGINS/src/pvrinput/{FAQ,HISTORY,README} %buildroot%docdir/pvrinput

mkdir -p %buildroot%docdir/remoteosd
cp -p PLUGINS/src/remoteosd/README %buildroot%docdir/remoteosd

mkdir -p %buildroot%docdir/svdrposd
cp -p PLUGINS/src/svdrposd/README %buildroot%docdir/svdrposd

mkdir -p %buildroot%docdir/svdrpservice
cp -p PLUGINS/src/svdrpservice/README %buildroot%docdir/svdrpservice

mkdir -p %buildroot%docdir/remoteosd
cp -p PLUGINS/src/remoteosd/README %buildroot%docdir/remoteosd

mkdir -p %buildroot%docdir/remotetimers
cp -p PLUGINS/src/remotetimers/README %buildroot%docdir/remotetimers

mkdir -p %buildroot%docdir/softhddevice %buildroot%confdir/plugins/softhddevice
cp -p PLUGINS/src/softhddevice/README.txt %buildroot%docdir/softhddevice/README

mkdir -p %buildroot%docdir/streamdev
cp -p PLUGINS/src/streamdev/{README,PROTOCOL} %buildroot%docdir/streamdev
cp -a PLUGINS/src/streamdev/streamdev-server %buildroot%confdir/plugins

mkdir -p %buildroot%docdir/text2skin %buildroot%confdir/plugins/text2skin
cp -a PLUGINS/src/text2skin/{README,Docs} %buildroot%docdir/text2skin

mkdir -p %buildroot%docdir/ttxtsubs %buildroot%confdir/plugins/ttxtsubs
cp -p PLUGINS/src/ttxtsubs/{README,TROUBLESHOOTING} %buildroot%docdir/ttxtsubs

mkdir -p %buildroot%docdir/upnp %buildroot%confdir/plugins/upnp
cp -p PLUGINS/src/upnp/README %buildroot%docdir/upnp/
touch %buildroot%confdir/plugins/upnp/metadata.db
rm -rf %buildroot%_defaultdocdir/vdr-upnp-*

mkdir -p %buildroot%docdir/vnsiserver
cp -p PLUGINS/src/vnsiserver/README %buildroot%docdir/vnsiserver
cp -a PLUGINS/src/vnsiserver/vnsiserver %buildroot%confdir/plugins

mkdir -p %buildroot%docdir/wirbelscan
cp -p PLUGINS/src/wirbelscan/README %buildroot%docdir/wirbelscan

make install -C PLUGINS/src/xineliboutput DESTDIR=%buildroot
mkdir -p %buildroot%docdir/xineliboutput
cp -p PLUGINS/src/xineliboutput/{README,examples/remote.conf.example} %buildroot%docdir/xineliboutput

touch %buildroot%confdir/setup.conf
install -pD -m0755 vdr.init %buildroot%_initdir/vdr
install -pD -m0644 vdr.service %buildroot%_unitdir/vdr.service
install -pD -m0644 vdr.tmpfiles %buildroot%_tmpfilesdir/vdr.conf
install -pD -m0644 vdr.sysconfig %buildroot%_sysconfdir/sysconfig/vdr
install -pm0755 contrib/xmltv2vdr/xmltv2vdr.pl %buildroot%_bindir/xmltv2vdr
install -pm0644 contrib/xmltv2vdr/README %buildroot%docdir/README.xmltv2vdr

mkdir -p %buildroot%_iconsdir
cp -a icons/* %buildroot%_iconsdir
install -pm0644 -D vdr.desktop %buildroot%_desktopdir/vdr.desktop

mkdir -p %buildroot%_runtimedir/vdr %buildroot%_cachedir/vdr

%find_lang --output=VDR.lang --append vdr vdr-hello vdr-pictures vdr-skincurses vdr-dvbsddevice vdr-dvbhddevice
%find_lang --output=sc.lang vdr-sc
%find_lang --output=enigmang.lang vdr-skinenigmang
%find_lang --output=epgsync.lang vdr-epgsync
%find_lang --output=femon.lang vdr-femon
%find_lang --output=iptv.lang vdr-iptv
%find_lang --output=live.lang vdr-live
%find_lang --output=manager.lang vdr-manager
%find_lang --output=pvrinput.lang vdr-pvrinput
%find_lang --output=softhddevice.lang vdr-softhddevice
%find_lang --output=streamdev.lang --append vdr-streamdev-server vdr-streamdev-client
%find_lang --output=text2skin.lang vdr-text2skin
%find_lang --output=ttxtsubs.lang vdr-ttxtsubs
%find_lang --output=remoteosd.lang --append vdr-svdrpservice vdr-remoteosd
%find_lang --output=remotetimers.lang vdr-remotetimers
%find_lang --output=upnp.lang vdr-upnp
%find_lang --output=vnsiserver.lang vdr-vnsiserver
%find_lang --output=wirbelscan.lang vdr-wirbelscan
%find_lang --output=xineliboutput.lang vdr-xineliboutput

mkdir -p %buildroot%_libexecdir/rpm
cat << __EOF__ > %buildroot%_libexecdir/rpm/vdr.filetrigger
#!/bin/sh -e
grep -qs '^%plugindir/' || exit 0
service vdr condrestart
__EOF__

chmod 755 %buildroot%_libexecdir/rpm/vdr.filetrigger

%pre
%_sbindir/groupadd -r -f _vdr &> /dev/null
%_sbindir/useradd -r -g _vdr -G audio,radio,video \
    -d %videodir -s /dev/null -c 'VDR User' -n _vdr &> /dev/null ||:

%post
%post_service vdr

%preun
%preun_service vdr

%files -f VDR.lang
%dir %docdir
%docdir/CONTRIBUTORS
%docdir/HISTORY
%docdir/INSTALL
%docdir/MANUAL
%docdir/PLUGINS.html
%docdir/README
%docdir/README.i18n
%docdir/README.xmltv2vdr
%docdir/UPDATE*

%dir %attr(0770,root,_vdr) %confdir
%dir %attr(0750,root,_vdr) %confdir/plugins
%dir %attr(0770,root,_vdr) %confdir/themes

%config(noreplace) %attr(0600,_vdr,_vdr) %confdir/*.conf

%_initdir/vdr
%_unitdir/vdr.service
%_tmpfilesdir/vdr.conf
%config(noreplace) %_sysconfdir/sysconfig/vdr

%_bindir/vdr
%_bindir/svdrpsend
%_bindir/xmltv2vdr

%dir %plugindir
%plugindir/libvdr-dummydevice.so.%version
%plugindir/libvdr-dvbhddevice.so.%version
%plugindir/libvdr-dvbsddevice.so.%version
%plugindir/libvdr-hello.so.%version
%plugindir/libvdr-osddemo.so.%version
%plugindir/libvdr-pictures.so.%version
%plugindir/libvdr-skincurses.so.%version
%plugindir/libvdr-status.so.%version
%plugindir/libvdr-svccli.so.%version
%plugindir/libvdr-svcsvr.so.%version
%plugindir/libvdr-svdrpdemo.so.%version
%plugindir/libvdr-rcu.so.%version
%plugindir/libvdr-epgtableid0.so.%version

%dir %resdir
%dir %resdir/plugins

%_man1dir/vdr.1*
%_man1dir/svdrpsend.1*
%_man5dir/vdr.5*

%dir %attr(0770,root,_vdr) %videodir
%dir %attr(0770,root,_vdr) %_runtimedir/vdr
%dir %attr(0770,root,_vdr) %_cachedir/vdr

%_libexecdir/rpm/vdr.filetrigger

%files devel
%_includedir/libsi
%_includedir/vdr
%_pkgconfigdir/vdr.pc

%files plugin-sc -f sc.lang
%docdir/sc
%dir %attr(0770,root,_vdr) %confdir/plugins/sc
%plugindir/libsc-cardclient-*.so.%version
%plugindir/libsc-conax-*.so.%version
%plugindir/libsc-constcw-*.so.%version
%plugindir/libsc-cryptoworks-*.so.%version
%plugindir/libsc-irdeto-*.so.%version
%plugindir/libsc-nagra-*.so.%version
%plugindir/libsc-nds-*.so.%version
%plugindir/libsc-sc_conax-*.so.%version
%plugindir/libsc-sc_cryptoworks-*.so.%version
%plugindir/libsc-sc_irdeto-*.so.%version
%plugindir/libsc-sc_nagra-*.so.%version
%plugindir/libsc-sc_seca-*.so.%version
%plugindir/libsc-sc_viaccess-*.so.%version
%plugindir/libsc-sc_videoguard2-*.so.%version
%plugindir/libsc-seca-*.so.%version
%plugindir/libsc-shl-*.so.%version
%plugindir/libsc-viaccess-*.so.%version
%plugindir/libsc-dvbhddevice-*.so.%version
%plugindir/libsc-dvbsddevice-*.so.%version
%plugindir/libvdr-sc.so.%version

%files plugin-enigmang -f enigmang.lang
%docdir/enigmang
%confdir/themes/EnigmaNG*.theme
%dir %attr(0770,root,_vdr) %confdir/plugins/skinenigmang
%plugindir/libvdr-skinenigmang.so.%version

%files plugin-epgsync -f epgsync.lang
%docdir/epgsync
%plugindir/libvdr-epgsync.so.%version

%files plugin-femon -f femon.lang
%docdir/femon
%plugindir/libvdr-femon.so.%version

%files plugin-iptv -f iptv.lang
%docdir/iptv
%dir %attr(0770,root,_vdr) %confdir/plugins/iptv
%config(noreplace) %attr(0600,_vdr,_vdr) %confdir/plugins/iptv/*
%plugindir/libvdr-iptv.so.%version
%resdir/plugins/iptv

%files plugin-live -f live.lang
%docdir/live
%dir %attr(0770,root,_vdr) %confdir/plugins/live
%plugindir/libvdr-live.so.%version
%resdir/plugins/live

%files plugin-manager -f manager.lang
%docdir/manager
%dir %attr(0770,root,_vdr) %confdir/plugins/manager
%config(noreplace) %attr(0600,_vdr,_vdr) %confdir/plugins/manager/*
%plugindir/libvdr-manager.so.%version

%files plugin-pvrinput -f pvrinput.lang
%docdir/pvrinput
%plugindir/libvdr-pvrinput.so.%version

%files plugin-remoteosd -f remoteosd.lang
%docdir/svdrposd
%docdir/remoteosd
%docdir/svdrpservice
%plugindir/libvdr-svdrposd.so.%version
%plugindir/libvdr-remoteosd.so.%version
%plugindir/libvdr-svdrpservice.so.%version

%files plugin-remotetimers -f remotetimers.lang
%docdir/remotetimers
%plugindir/libvdr-remotetimers.so.%version

%files plugin-softhddevice -f softhddevice.lang
%docdir/softhddevice
%dir %attr(0770,root,_vdr) %confdir/plugins/softhddevice
%plugindir/libvdr-softhddevice.so.%version

%files plugin-streamdev -f streamdev.lang
%docdir/streamdev
%dir %attr(0770,root,_vdr) %confdir/plugins/streamdev-server
%config(noreplace) %attr(0600,_vdr,_vdr) %confdir/plugins/streamdev-server/streamdevhosts.conf
%config(noreplace) %attr(0700,_vdr,_vdr) %confdir/plugins/streamdev-server/externremux.sh
%plugindir/libvdr-streamdev-server.so.%version
%plugindir/libvdr-streamdev-client.so.%version

%files plugin-text2skin -f text2skin.lang
%docdir/text2skin
%dir %attr(0770,root,_vdr) %confdir/plugins/text2skin
%plugindir/libvdr-text2skin.so.%version

%files plugin-ttxtsubs -f ttxtsubs.lang
%docdir/ttxtsubs
%dir %attr(0770,root,_vdr) %confdir/plugins/ttxtsubs
%plugindir/libvdr-ttxtsubs.so.%version

%files plugin-upnp -f upnp.lang
%docdir/upnp
%dir %attr(0770,root,_vdr) %confdir/plugins/upnp
%config(noreplace) %attr(0600,_vdr,_vdr) %confdir/plugins/upnp/metadata.db
%config(noreplace) %attr(0600,_vdr,_vdr) %confdir/plugins/upnp/channelTitle.conf
%plugindir/libvdr-upnp.so.%version
%plugindir/libupnp-dvb-profiler.so.%version
%plugindir/libupnp-file-provider.so.%version
%plugindir/libupnp-rec-provider.so.%version
%plugindir/libupnp-vdr-provider.so.%version
%resdir/plugins/upnp

%files plugin-vnsiserver -f vnsiserver.lang
%docdir/vnsiserver
%dir %attr(0770,root,_vdr) %confdir/plugins/vnsiserver
%config(noreplace) %attr(0600,_vdr,_vdr) %confdir/plugins/vnsiserver/allowed_hosts.conf
%plugindir/libvdr-vnsiserver.so.%version

%files plugin-wirbelscan -f wirbelscan.lang
%docdir/wirbelscan
%plugindir/libvdr-wirbelscan.so.%version

%files plugin-xineliboutput -f xineliboutput.lang
%docdir/xineliboutput
%dir %attr(0770,root,_vdr) %confdir/plugins/xineliboutput
%config(noreplace) %attr(0600,_vdr,_vdr) %confdir/plugins/xineliboutput/allowed_hosts.conf
%confdir/plugins/xineliboutput/*.mpg
%plugindir/libvdr-xineliboutput.so.%version

%files fbfe
%_bindir/vdr-fbfe
%dir %plugindir
%plugindir/libxineliboutput-fbfe.so.%version

%files sxfe
%_bindir/vdr-sxfe
%dir %plugindir
%plugindir/libxineliboutput-sxfe.so.%version
%_iconsdir/hicolor/*/apps/vdr.png
%_desktopdir/vdr.desktop

%files plugin-xine
%_libdir/xine/plugins/*/post/xineplug_post_audiochannel.so
%_libdir/xine/plugins/*/post/xineplug_post_autocrop.so
%_libdir/xine/plugins/*/post/xineplug_post_swscale.so
%_libdir/xine/plugins/*/xineplug_inp_xvdr.so

%changelog
