Epoch: 0
Group: Development/Java
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
Name:          velocity-tools
Version:       2.0
Release:       alt2_12jpp8
Summary:       Collection of useful tools for Velocity template engine
License:       ASL 2.0
Url:           http://velocity.apache.org/tools/releases/2.0/
Source0:       http://www.apache.org/dist/velocity/tools/%{version}/%{name}-%{version}-src.tar.gz
Patch0:        %{name}-%{version}-junit4.patch
Patch1:        %{name}-%{version}-dont_copy_test_lib.patch
# servlet 3.0 support thanks to mizdebsk
# servlet 3.1 support
Patch2:        %{name}-%{version}-servlet.patch

BuildRequires: mvn(commons-beanutils:commons-beanutils)
BuildRequires: mvn(commons-chain:commons-chain)
BuildRequires: mvn(commons-collections:commons-collections)
BuildRequires: mvn(commons-digester:commons-digester)
BuildRequires: mvn(commons-lang:commons-lang)
BuildRequires: mvn(commons-logging:commons-logging)
BuildRequires: mvn(commons-validator:commons-validator)
BuildRequires: mvn(dom4j:dom4j)
BuildRequires: mvn(org.apache.struts:struts-core)
BuildRequires: mvn(org.apache.struts:struts-taglib)
BuildRequires: mvn(org.apache.struts:struts-tiles)
BuildRequires: mvn(org.apache.tomcat:tomcat-jsp-api)
BuildRequires: mvn(org.apache.tomcat:tomcat-servlet-api)
BuildRequires: mvn(org.apache.velocity:velocity)
BuildRequires: mvn(oro:oro)
BuildRequires: mvn(sslext:sslext)
# required by tomcat-jsp-api
BuildRequires: mvn(org.apache.tomcat:tomcat-el-api)

# test deps
%if 0
BuildRequires: mvn(httpunit:httpunit) = 1.6.1
BuildRequires: mvn(nekohtml:nekohtml) = 0.9.5
BuildRequires: mvn(org.mortbay.jetty:jetty-embedded) = 6.0.1
BuildRequires: mvn(rhino:js) = 1.6R5
BuildRequires: mvn(xerces:xercesImpl) = 2.8.1
BuildRequires: mvn(xerces:xmlParserAPIs) = 2.6.2
%endif
BuildRequires: mvn(junit:junit)

BuildRequires: maven-local
BuildRequires: maven-resources-plugin
# required by resources-plugin
BuildRequires: mvn(org.apache.maven.shared:maven-filtering)
BuildRequires: mvn(org.apache.maven.shared:maven-shared-components:pom:)

BuildArch:     noarch
Source44: import.info

%description
The VelocityTools project is a collection of useful Java classes (aka tools),
as well as infrastructure to easily, automatically and transparently
make these tools available to Velocity templates.

Project include easy integration of Velocity into the view-layer of
web applications (via the VelocityViewTag and
VelocityViewServlet) and integration with Struts 1.x applications.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%prep
%setup -q -n %{name}-%{version}-src
find . -name "*.jar" -delete
find . -name "*.class" -delete
%patch0 -p1
%patch1 -p1
%patch2 -p1

sed -i 's/\r//' LICENSE NOTICE WHY_THREE_JARS.txt

# force tomcat 7.x apis
%pom_remove_dep javax.servlet:servlet-api
%pom_add_dep org.apache.tomcat:tomcat-servlet-api::provided
%pom_add_dep org.apache.tomcat:tomcat-jsp-api::provided
# remove non standard build structure
%pom_xpath_remove "pom:project/pom:build/pom:outputDirectory"
%pom_xpath_remove "pom:project/pom:build/pom:directory"

%mvn_file :%{name} %{name}
%mvn_alias :%{name} %{name}:%{name}
%mvn_alias :%{name} org.apache.velocity:%{name}-generic
%mvn_alias :%{name} %{name}:%{name}-generic
%mvn_alias :%{name} %{name}:%{name}-view
%mvn_alias :%{name} org.apache.velocity:%{name}-view

%build

# tests skipped. cause: missing dependencies
%mvn_build -f -- -Dproject.build.sourceEncoding=UTF-8

%install
%mvn_install

%files -f .mfiles
%doc CONTRIBUTORS README.txt STATUS WHY_THREE_JARS.txt
%doc LICENSE NOTICE

%files javadoc -f .mfiles-javadoc
%doc LICENSE NOTICE

%changelog
