%define ver_major 3.22
%define _name org.gnome.Vino

Name: vino
Version: %ver_major.0
Release: alt0.M80P.1

Summary: A remote desktop system for GNOME
License: GPL
URL: https://wiki.gnome.org/Projects/Vino
Group: Networking/Remote access

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Requires: gnome-settings-daemon

BuildRequires: intltool gnome-common desktop-file-utils NetworkManager-devel
BuildRequires: libgio-devel libgtk+3-devel libdbus-devel
BuildRequires: libXdamage-devel libXtst-devel libSM-devel xorg-cf-files xorg-inputproto-devel
BuildRequires: libavahi-glib-devel libgcrypt-devel libgnutls-devel libsecret-devel
BuildRequires: libjpeg-devel libnotify-devel >= 0.7 zlib-devel
BuildRequires: libtelepathy-glib-devel >= 0.11.6
BuildRequires: systemd-devel

%description
Vino is a VNC server for GNOME. It allows remote users to
connect to a running GNOME session using VNC.

%prep
%setup

%build
%configure \
	--disable-schemas-compile
%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_libexecdir/vino-server
%_desktopdir/vino-server.desktop
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Vino.service
%_datadir/telepathy/clients/Vino.client
%_datadir/glib-2.0/schemas/%_name.gschema.xml
%_datadir/glib-2.0/schemas/%_name.enums.xml
%_prefix/lib/systemd/user/%name-server.service
%doc AUTHORS NEWS README docs/TODO docs/remote-desktop.txt docs/debugging.txt

%changelog
