%define ver_major 3.8

Name: vino-mate
Version: %ver_major.1
Release: alt3

Summary: A remote desktop system for MATE
License: GPL
URL: https://wiki.gnome.org/Projects/Vino
Group: Networking/Remote access
Packager: Korneechev Evgeniy <ekorneechev@altlinux.org>

Source: %name-%version.tar.xz
Patch0: vino-3.8.1-fc-allocation.patch
Patch1: vino-3.8.1-alt-fixed_MATE.patch

BuildRequires: intltool gnome-common desktop-file-utils NetworkManager-devel
BuildRequires: libgio-devel libgtk+3-devel libsoup-devel libdbus-devel
BuildRequires: libXdamage-devel libXtst-devel libSM-devel xorg-cf-files xorg-inputproto-devel
BuildRequires: libavahi-glib-devel libgcrypt-devel libgnutls-devel libsecret-devel
BuildRequires: libjpeg-devel libnotify-devel >= 0.7 zlib-devel
BuildRequires: libtelepathy-glib-devel >= 0.11.6

Conflicts: vino
Provides: mate-vino = %version-%release

%description
Vino is a VNC server for MATE. It allows remote users to
connect to a running MATE session using VNC.

%prep
%setup -q
%patch0 -p1
%patch1 -p1

%build
export LDFLAGS="$LDFLAGS -lgcrypt"
%configure \
	--disable-http-server \
	--disable-schemas-compile
%make_build

%install
%make_install DESTDIR=%buildroot install

%find_lang vino

%files -f vino.lang
%_bindir/*
%_libexecdir/vino-server
%dir %_datadir/vino
%_datadir/vino/*.ui
%_datadir/vino/webservices
%_datadir/applications/*.desktop
%_sysconfdir/xdg/autostart/vino-server.desktop
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Vino.service
%_datadir/telepathy/clients/Vino.client
%config %_datadir/glib-2.0/schemas/*.xml
%_datadir/GConf/gsettings/org.gnome.Vino.convert
%doc AUTHORS NEWS README docs/TODO docs/remote-desktop.txt docs/debugging.txt

%changelog
