%add_python_req_skip guestfs
%define _libexecdir /usr/libexec
%define qemu_user  _libvirt
%define preferred_distros "altlinux,fedora,rhel"
%define kvm_packages ""
%define libvirt_packages "libvirt"
%define askpass_package "openssh-askpass"

Name: virt-manager
Version: 1.3.2
Release: alt2
Summary: Virtual Machine Manager

Group: Emulators
License: GPLv2+
Url: http://virt-manager.org/
BuildArch: noarch

# https://github.com/virt-manager/virt-manager
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: virt-manager-common = %version-%release
Requires: virt-install = %version-%release
Requires: python-module-pygobject3 >= 3.14
Requires: python-module-libxml2
Requires: vte3
Requires: dconf
Requires: dbus-tools-gui
Requires: libosinfo >= 0.2.10
Requires: librsvg

# add requires based on "from gi.repository import foo"
Requires: typelib(GObject)
Requires: typelib(LibvirtGLib) = 1.0
Requires: typelib(Gtk) = 3.0
Requires: typelib(Gdk)
Requires: typelib(GdkPixbuf)
Requires: typelib(Pango)
Requires: typelib(GLib)
Requires: typelib(Gio)
Requires: typelib(GtkVnc) = 2.0
Requires: typelib(SpiceClientGtk) = 3.0
Requires: typelib(SpiceClientGLib)
Requires: typelib(Vte) = 2.91
Requires: typelib(Libosinfo) = 1.0

BuildRequires: python-devel python-module-distribute
BuildRequires: libgio
BuildRequires: intltool
BuildRequires: /usr/bin/pod2man

%add_python_req_skip virtconv
%add_python_req_skip virtinst
%add_python_req_skip virtcli
%add_python_req_skip virtxml

%description
Virtual Machine Manager provides a graphical tool for administering
virtual machines for KVM, Xen, and QEmu. Start, stop, add or remove
virtual devices, connect to a graphical or serial console, and see
resource usage statistics for existing VMs on local or remote machines.
Uses libvirt as the backend management API.

%package common
Summary: Common files used by the different Virtual Machine Manager interfaces
Group: Emulators
Conflicts: %name < %version-%release

%description common
Common files used by the different virt-manager interfaces, as well as
virt-install related tools.

%package -n virt-install
Summary: Utilities for installing virtual machines
Group: Emulators

Requires: virt-manager-common = %version-%release

Provides: virt-install
Provides: virt-clone
Provides: virt-convert
Provides: virt-xml
Obsoletes: python-module-virtinst

%description -n virt-install
Package includes several command line utilities, including virt-install
(build and install new VMs) and virt-clone (clone an existing virtual
machine).

%prep
%setup
%patch -p1

%build
python setup.py configure \
	--qemu-user=%qemu_user \
	--libvirt-package-names=%libvirt_packages \
	--kvm-package-names=%kvm_packages \
	--preferred-distros=%preferred_distros \
	--askpass-package-names=%askpass_package

#%%python_build

%install
#%%python_install
python setup.py \
	--no-update-icon-cache --no-compile-schemas \
	install --root=%buildroot

%find_lang --with-gnome %name

%files
%_bindir/%name
%_datadir/%name/ui/*.ui
%_datadir/%name/virt-manager
%_datadir/%name/virtManager
%_datadir/%name/icons
%_desktopdir/%name.desktop
%_datadir/appdata/%name.appdata.xml
%_datadir/icons/hicolor/*/apps/%name.png
%_datadir/glib-2.0/schemas/*.gschema.xml
%_datadir/GConf/gsettings/org.virt-manager.virt-manager.convert

%_man1dir/%name.1*
%doc README COPYING NEWS

%files common -f %name.lang
%dir %_datadir/%name
%_datadir/%name/virtcli
%_datadir/%name/virtconv
%_datadir/%name/virtinst

%files -n virt-install
%_bindir/virt-install
%_bindir/virt-clone
%_bindir/virt-convert
%_bindir/virt-xml
%_datadir/%name/virt-install
%_datadir/%name/virt-clone
%_datadir/%name/virt-convert
%_datadir/%name/virt-xml
%_man1dir/virt-install.1*
%_man1dir/virt-clone.1*
%_man1dir/virt-convert.1*
%_man1dir/virt-xml.1*

%changelog
