
%def_disable wbxml
%def_disable iodbc_ext

Name: virtuoso-opensource
Version: 6.1.8
Release: alt1
Serial: 2

Group: Databases
Summary: OpenLink Virtuoso Database System Open-Source Edition
Url: http://virtuoso.openlinksw.com/
License: GPLv2

Requires: %name-applications = %version-%release
#Requires: %name-conductor = %version-%release
#Requires: %name-jars = %version-%release

Source0: %name-%version.tar
# FC
Patch1: virtuoso-opensource-6.1.6-extern-iodbc.patch
Patch2: virtuoso-opensource-6.1.8-nodemos_buildfix.patch
Patch3: virtuoso-opensource-6.1.4-no_strip.patch

BuildRequires: glibc-devel libssl-devel bison flex gperf libxml2-devel libldap-devel /usr/bin/openssl libexpat-devel zlib-devel
%if_enabled iodbc_ext
BuildRequires: libiodbc-devel
%endif
%if_enabled wbxml
BuildRequires: libwbxml2-devel
%endif


%description
Virtuoso is a scalable cross-platform server that combines SQL/RDF/XML
Data Management with Web Application Server and Web Services Platform
functionality.

Virtuoso is at the core a high performance object-relational SQL
database. As a database, it provides transactions, a smart SQL
compiler, powerful stored procedure language with optional Java and
.Net server side hosting, hot backup, SQL 99 and more. It has all
major data access interfaces, as in ODBC, JDBC, ADO .Net and OLE/DB.

Virtuoso has a built-in web server which can serve dynamic web pages
written in Virtuoso's web page language as well as PHP, ASP .Net and
others. This same web server provides SOAP and REST access to Virtuoso
stored procedures, supporting a broad set of WS protocols such as
WS-Security, WS-Reliable Messaging and others. A BPEL4WS run time is
also available as part of Virtuoso's SOA suite.


%package -n %name-conductor
Summary: Virtuoso open source edition Server Pages
Group: Development/Databases
%description -n %name-conductor
Virtuoso is a scalable cross-platform server that combines SQL/RDF/XML
Data Management with Web Application Server and Web Services Platform
functionality.

%package -n %name-applications
Summary: Virtuoso open source applications
Group: Development/Databases
%description -n %name-applications
Virtuoso is a scalable cross-platform server that combines SQL/RDF/XML
Data Management with Web Application Server and Web Services Platform
functionality.

%package -n %name-jars
Summary: Virtuoso open source jar files
Group: Development/Databases
%description -n %name-jars
Virtuoso is a scalable cross-platform server that combines SQL/RDF/XML
Data Management with Web Application Server and Web Services Platform
functionality.


%prep
%setup -q -n %name-%version
%if_enabled iodbc_ext
%patch1 -p0 -b .iodbc
%endif
%patch2 -p0
%patch3 -p1
%if_enabled iodbc_ext
rm -rf libsrc/odbcsdk/*
>libsrc/odbcsdk/Makefile.am
%endif
%autoreconf


%build
%configure \
    --with-layout=redhat \
    --disable-static \
    --enable-shared \
    --localstatedir=/var \
%if_enabled iodbc_ext
    --with-iodbc=%prefix \
%endif
    --without-internal-zlib \
    --enable-openssl \
    --disable-imagemagick \
%if_disabled wbxml
    --disable-wbxml2 \
%endif
    --disable-all-vads
%make


%install
%make install DESTDIR=%buildroot
mkdir -p %buildroot%_var/lib/virtuoso/{db,vsp}
mkdir -p %buildroot%_libdir/virtuoso/plugins
mkdir -p %buildroot%_datadir/virtuoso/vad
mkdir -p %buildroot%_libdir/virtuoso/hosting
mv %buildroot%_libdir/*.la %buildroot%_libdir/virtuoso/plugins/
cp -f %buildroot%_libdir/virtuoso/plugins/* %buildroot%_libdir/

rm -fr %buildroot%_libdir/*.a
mv %buildroot%_libdir/*.so %buildroot%_libdir/virtuoso/plugins/
mkdir -p %buildroot%_libdir/virtuoso/jars
mv %buildroot%_libdir/jdbc-2.0 %buildroot%_libdir/virtuoso/jars/jdbc2.0
mv %buildroot%_libdir/jdbc-3.0 %buildroot%_libdir/virtuoso/jars/jdbc3.0
mv %buildroot%_libdir/jdbc-4.0 %buildroot%_libdir/virtuoso/jars/jdbc4.0
mv %buildroot%_libdir/jena %buildroot%_libdir/virtuoso/jars/jena
mv %buildroot%_libdir/sesame %buildroot%_libdir/virtuoso/jars/sesame
mkdir -p %buildroot%_sysconfdir/virtuoso
mv %buildroot%_var/lib/virtuoso/db/virtuoso.ini %buildroot%_sysconfdir/virtuoso/


%files -n %name
%doc LICENSE AUTHORS CREDITS ChangeLog NEWS README*
%_bindir/*
#conflicts with unixODBC
%exclude %_bindir/isql
%_sysconfdir/virtuoso/virtuoso.ini
%dir %_libdir/virtuoso
%dir %_libdir/virtuoso/hosting
%dir %_libdir/virtuoso/plugins
%dir %_libdir/virtuoso/jars
%dir %_datadir/virtuoso
%dir %_datadir/virtuoso/vad
%dir %_var/lib/virtuoso
%dir %_var/lib/virtuoso/db
%dir %_var/lib/virtuoso/vsp

#%files -n %name-conductor
#%_var/lib/virtuoso/vsp/*

%files -n %name-applications
%_libdir/virtuoso/plugins/*.so

%files -n %name-jars
%_libdir/virtuoso/jars/*
%_libdir/hibernate/virt_dialect.jar

%changelog
