Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-java
# END SourceDeps(oneline)
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
%define fedora 23
# Conditionals to help breaking vorbis-java-tika <-> tika dependency cycle
%if 0%{?fedora}
#def_with tika
%bcond_with tika
%endif

Name:          vorbis-java
Version:       0.7
Release:       alt1_2jpp8
Summary:       Ogg and Vorbis toolkit for Java
License:       ASL 2.0
URL:           https://github.com/Gagravarr/VorbisJava
Source0:       https://github.com/Gagravarr/VorbisJava/archive/%{name}-%{version}.tar.gz

BuildRequires: maven-local
BuildRequires: mvn(junit:junit)
%if %{without tika}
BuildRequires: mvn(org.apache.tika:tika-core)
%endif

BuildArch:     noarch
Source44: import.info

%description
This library is a pure Java, for working with Ogg and
Vorbis, FLAC, Opus, Speex and Theora files.

%if %{without tika}
%package tika
Group: Development/Java
Summary:       VorbisJava Apache Tika plugin

%description tika
This package contains Apache Tika plugin for Ogg,
Vorbis and FLAC.
%endif

%package tools
Group: Development/Java
Summary:       VorbisJava Tools

%description tools
This package contains VorbisJava Ogg and Vorbis tools for Java.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%prep
%setup -q -n VorbisJava-%{name}-%{version}
find . -name "*.class" -delete
find . -name "*.jar" -delete

%if %{with tika}
%pom_disable_module tika
%pom_xpath_remove "pom:dependency[pom:scope = 'test']" tika
%endif

# disable embedded core copy
%pom_remove_plugin :maven-assembly-plugin tools

%pom_remove_plugin :maven-gpg-plugin parent
%pom_remove_plugin :maven-source-plugin parent
%pom_xpath_remove "pom:plugin[pom:artifactId='maven-javadoc-plugin']/pom:executions" parent

%mvn_package :%{name} %{name}
%mvn_package :%{name}-parent %{name}
%mvn_package :%{name}-core %{name}

%build

# Skip test @ random fails on arm builder
%mvn_build -s -f -- -Dproject.build.sourceEncoding=UTF-8

%install
%mvn_install

%files -f .mfiles-%{name}
%dir %{_javadir}/%{name}
%doc CHANGES.txt README.txt TODO.txt
%doc LICENSE.txt NOTICE.txt

%if %{without tika}
%files tika -f .mfiles-%{name}-tika
%doc LICENSE.txt NOTICE.txt
%endif

%files tools -f .mfiles-%{name}-tools
%doc LICENSE.txt NOTICE.txt

%files javadoc -f .mfiles-javadoc
%doc LICENSE.txt NOTICE.txt

%changelog
