%define build_type RelWithDebInfo
%define _cmake %cmake -DCMAKE_BUILD_TYPE=%build_type -DCMAKE_VERBOSE_MAKEFILE:BOOL=ON

Name: vulkan
Version: 1.1.96
Release: alt0.M80P.1
Summary: Khronos group Vulkan API SDK

Group: System/Libraries
License: ASL 2.0
Url: http://www.khronos.org/

# https://github.com/KhronosGroup/Vulkan-Loader
Source0: vulkan-loader.tar.xz
# https://github.com/KhronosGroup/Vulkan-Headers
Source1: vulkan-headers.tar.xz
# https://github.com/KhronosGroup/SPIRV-Headers
Source2: SPIRV-Headers.tar.xz
# https://github.com/KhronosGroup/SPIRV-Tools
Source3: SPIRV-Tools.tar.xz
# https://github.com/KhronosGroup/glslang
Source4: glslang.tar.xz
# https://github.com/KhronosGroup/Vulkan-Tools
Source5: vulkan-tools.tar.xz
# https://github.com/KhronosGroup/Vulkan-ValidationLayers
Source6: vulkan-layers.tar.xz
Patch1: spirv-tools-alt-use-python3.patch
Patch2: 0003-layers-Don-t-set-an-rpath.patch
Patch3: vulkan-alt-use-file-rev-spirv-tools.patch

BuildRequires: bison chrpath
BuildRequires(pre): cmake gcc-c++ rpm-build-python3
BuildRequires: libImageMagick-devel libpciaccess-devel libsystemd-devel
BuildRequires: python3-devel libxcb-devel libXau-devel libXdmcp-devel libX11-devel libXrandr-devel
BuildRequires: wayland-devel libwayland-server-devel libwayland-client-devel libwayland-cursor-devel libwayland-egl-devel

# textrel due asm optimisation in loader code
%ifarch i586
%set_verify_elf_method textrel=relaxed
%endif

%description
Vulkan is a new generation graphics and compute API that provides
high-efficiency, cross-platform access to modern GPUs used in a wide
variety of devices from PCs and consoles to mobile phones and embedded
platforms.

This package contains the reference ICD loader and API validation layer for
Vulkan.

%package -n lib%{name}1
Summary: Vulkan loader libraries
Group: System/Libraries
Requires: vulkan-filesystem = %version-%release
Provides: %name = %version-%release
Obsoletes: %name

%description -n lib%{name}1
Vulkan is a new generation graphics and compute API that provides
high-efficiency, cross-platform access to modern GPUs used in a wide
variety of devices from PCs and consoles to mobile phones and embedded
platforms.

This package contains the reference ICD loader for Vulkan.

%package validation-layers
Summary: Vulkan API validation layers
Group: Development/C++
Requires: lib%{name}1 = %version-%release

%description validation-layers
Vulkan API validation layer for developers.

%package -n lib%name-devel
Summary: Vulkan development package
Group: Development/C++
Requires: lib%{name}1 = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel

%description -n lib%name-devel
Development headers for Vulkan applications.

%package filesystem
Summary: Vulkan filesystem package
Group: System/Base
BuildArch: noarch

%description filesystem
Filesystem for Vulkan API.

%package tools
Summary: Vulkan tools and utilities
Group: System/X11
Requires: lib%{name}1 = %version-%release
Provides: %name-utils = %EVR
Obsoletes: %name-utils <= 1.0.46.0
Obsoletes: %name-demos

%description tools
Tools and utilities that can assist development by enabling developers to
verify their applications correct use of the Vulkan API.

%prep
%setup -n %name-loader -b0 -b1 -b2 -b3 -b4 -b5 -b6
pushd ../SPIRV-Tools
%patch1 -p2
popd
pushd ../vulkan-layers
# sigh inttypes
sed -i 's/inttypes.h/cinttypes/' layers/*.{cpp,h}
#%%patch2 -p1
popd
#%%patch3 -p2

%build
# first, SPIRV-Tools and glslang
for dir in SPIRV-Tools glslang; do
pushd %_builddir/$dir
if [ "$dir" == "SPIRV-Tools" ]; then
ln -s %_builddir/SPIRV-Headers external/SPIRV-Headers
%_cmake -DSPIRV_BUILD_COMPRESSION:BOOL=ON -DSPIRV_WERROR:BOOL=OFF
else
ln -s %_builddir/SPIRV-Tools External/spirv-tools
%_cmake
fi
%cmake_build
%cmakeinstall_std DESTDIR=$(pwd)/install
pushd install
ln -s usr/* .
popd
popd
done

# second, vulkan-headers
pushd %_builddir/vulkan-headers
%_cmake
%cmake_build
%cmakeinstall_std
popd

# then vulkan-loader and layers
for dir in loader layers; do
pushd %_builddir/vulkan-"$dir"
%_cmake \
	   -DVULKAN_HEADERS_INSTALL_DIR=%buildroot \
	   -DGLSLANG_INSTALL_DIR=%_builddir/glslang/install \
	   -DVulkanHeaders_INCLUDE_DIR=%buildroot%_includedir
%cmake_build
%cmakeinstall_std
popd
done

# end finally -tools
pushd %_builddir/vulkan-tools
%_cmake \
	   -DCMAKE_PREFIX_PATH=%buildroot%prefix \
	   -DGLSLANG_INSTALL_DIR=%_builddir/glslang/install
%cmake_build
%cmakeinstall_std
popd

%install
# do it again
for dir in headers layers loader tools; do
pushd %_builddir/vulkan-"$dir"
%cmakeinstall_std
popd
done
mkdir -p %buildroot%_sysconfdir/vulkan/explicit_layer.d
mkdir -p %buildroot%_datadir/vulkan/{explicit,implicit}_layer.d/ ||:
mkdir -p %buildroot%_datadir/vulkan/icd.d ||:

# remove RPATH
chrpath -d %buildroot%_bindir/vulkaninfo

%files tools
%_bindir/*

%files -n lib%{name}1
%doc README.md LICENSE.txt
%_libdir/libvulkan.so.1*

%files -n lib%name-devel
%dir %_includedir/vulkan
%_includedir/vulkan
%_libdir/libvulkan.so
%_pkgconfigdir/vulkan.pc
%_datadir/vulkan/registry
# requires vulkan-docs tools
%exclude %_datadir/vulkan/registry/genvk.py

%files validation-layers
%_includedir/*
%exclude %_includedir/vulkan
%dir %_sysconfdir/vulkan/explicit_layer.d
%dir %_datadir/vulkan/explicit_layer.d
%dir %_datadir/vulkan/implicit_layer.d
%_datadir/vulkan/explicit_layer.d/*.json
%_libdir/libVkLayer*.so
%_libdir/libVkLayer*.a

%files filesystem
%dir %_sysconfdir/vulkan
%dir %_datadir/vulkan
%dir %_datadir/vulkan/icd.d

%changelog
