####### wesnoth >= 1.13  ##############
BuildRequires: boost-devel-headers
#######################################
####### wesnoth >= 1.12  ##############
BuildRequires: libvorbis-devel
#######################################

%define _unpackaged_files_terminate_build 1
%def_with build_using_scons
%def_with install_using_scons
%def_without install_using_manual
%def_without install_using_cmake
# remnants of configure, drop them later
%def_enable nls
%def_enable rpath
%def_disable debug
%def_disable tests
%def_disable static
%def_enable optipng
%def_enable game
%def_enable server
%def_disable editor
%def_disable python3
%def_disable python
%def_disable tools
%def_enable bandwidth_monitor
%def_enable sdltest
#----------------------------------------------------------------------
%define subst_enable_to() %{expand:%%{?_enable_%{1}:--enable-%{2}}} %{expand:%%{?_disable_%{1}:--disable-%{2}}}

%define _pseudouser_user     _wesnothd
%define _pseudouser_group    _wesnothd
%define _pseudouser_home     %_var/run/wesnothd

%define wessuffix %nil
#define wesdesktopsuffix %nil

Name: wesnoth%wessuffix
Version: 1.14.3
Release: alt0.M80P.1
Group: Games/Strategy
Summary: 2D fantasy turn-based strategy
Summary(ru_RU.UTF-8): двухмерная пошаговая стратегия в стиле фэнтези
License: %gpl2plus
Url: http://www.%name.org
Source0: wesnoth-%version.tar
Patch0: wesnoth-1.13.8-sdl2.02.patch
Patch1: wesnoth-1.13.8-sdl2.02-alt-hack.patch

Requires: %name-data = %version-%release

BuildRequires(pre): rpm-build-licenses

BuildRequires: ImageMagick-tools asciidoc boost-devel desktop-file-utils fribidi gcc-c++ hd2u imake libICE-devel libSDL2-devel libSDL2_image-devel libSDL2_mixer-devel libSDL2_net-devel libSDL2_ttf-devel libfreetype-devel libfribidi-devel libpango-devel libpng-devel po4a subversion xorg-cf-files xsltproc liblua5-devel libpng-devel cmake boost-program_options-devel boost-filesystem-devel boost-locale-devel libdbus-devel boost-asio-devel libpixman-devel libXdmcp-devel libreadline-devel openssl-devel
%if_with build_using_scons
BuildRequires: scons
%endif

BuildRequires: fonts-ttf-dejavu fonts-ttf-sazanami-gothic fonts-ttf-wqy-zenhei
%{?_enable_optipng:BuildRequires: optipng}

%if_disabled tools
Obsoletes: %name-tools < 1.13
%endif
%if_enabled python
%if_enabled python3
BuildRequires: python3-devel rpm-build-python3
BuildRequires(pre): rpm-build-python3
Requires: python3-module-%name = %version-%release
Obsoletes: python-module-%name < 1.13
%else
BuildRequires: python-devel
Requires: python-module-%name = %version-%release
Conflicts: %name-tools < 1.11.7
%endif
%else
Obsoletes: python-module-%name < 1.13
AutoReq: yes,nopython,nopython3
%endif

%description
Battle for Wesnoth is a fantasy turn-based strategy game.
Battle for control of villages, using variety of units which have
advantages and disadvantages in different types of terrains and against
different types of attacks. Units gain experience and advance levels,
and are carried over from one scenario to the next campaign.
Build a Hero, and lead your army. Different races, with distinctive
abilities, weapons and spells.

%description -l ru_RU.UTF-8
'Битва за Вэснот' это пошаговая стратегия в стите фэнтези.
Сражайся за контроль над деревнями, используя различные войска,
которые имеют свои преимущества и недостатки на разных типах
территорий и против разных типов атак. Войска получают опыт и повышают
уровни, переносимые на следующий сценарий в кампании.
Создай Героя и возглавь свою армию. Различные расы с различными
способностями, оружием и заклинаниями.


%package data
Group: Games/Strategy
Summary: Data files to Battle for Wesnoth
BuildArch: noarch
Conflicts: %name < 1.6.5-alt1
Conflicts: %name-editor < 1.13.0
Obsoletes: %name-editor < 1.13.0
%if_disabled python
AutoReq: yes,nopython,nopython3
%endif

%description data
Battle for Wesnoth is a fantasy turn-based strategy game.
Battle for control of villages, using variety of units which have
advantages and disadvantages in different types of terrains and against
different types of attacks. Units gain experience and advance levels,
and are carried over from one scenario to the next campaign.
Build a Hero, and lead your army. Different races, with distinctive
abilities, weapons and spells.
This package contains data files to Battle for Wesnoth.


%package doc
Group: Documentation
Summary: Manual to Battle for Wesnoth
Provides: %name-manual = %version-%release
BuildArch: noarch

%description doc
Battle for Wesnoth is a fantasy turn-based strategy game.
Battle for control of villages, using variety of units which have
advantages and disadvantages in different types of terrains and against
different types of attacks. Units gain experience and advance levels,
and are carried over from one scenario to the next campaign.
Build a Hero, and lead your army. Different races, with distinctive
abilities, weapons and spells.
This package contains manual to Battle for Wesnoth.


%if_enabled editor
%package editor
Group: Games/Strategy
Summary: Battle for Wesnoth map editor
BuildArch: noarch
#
%description editor
Battle for Wesnoth is a fantasy turn-based strategy game.
Battle for control of villages, using variety of units which have
advantages and disadvantages in different types of terrains and against
different types of attacks. Units gain experience and advance levels,
and are carried over from one scenario to the next campaign.
Build a Hero, and lead your army. Different races, with distinctive
abilities, weapons and spells.
This package contains Battle for Wesnoth map editor.
%endif


%if_enabled tools
%package tools
Group: Games/Strategy
Summary: Battle for Wesnoth tools
%if_enabled python
%if_enabled python3
Requires: python3-module-%name = %version-%release
%else
Requires: python-module-%name = %version-%release
%endif
%endif

%description tools
Battle for Wesnoth is a fantasy turn-based strategy game.
Battle for control of villages, using variety of units which have
advantages and disadvantages in different types of terrains and against
different types of attacks. Units gain experience and advance levels,
and are carried over from one scenario to the next campaign.
Build a Hero, and lead your army. Different races, with distinctive
abilities, weapons and spells.
This package contains Battle for Wesnoth tools.
%endif


%if_enabled server
%package server
Group: Games/Strategy
Summary: %name server for multiplayer games
Summary(ru_RU.UTF-8): %name сервер для многопользовательских игр

%description server
Battle for Wesnoth multiplayer network daemon.

%description server -l ru_RU.UTF-8
Сервер для многопользовательских игр 'Битва за Вэснот'.
%endif

%if_enabled python
%if_enabled python3
%package -n python3-module-%name
%py3_provides %name
%else
%package -n python-module-%name
%py_provides %name
%endif
Group: Development/Python
Summary: Python interface to Battle for Wesnoth
BuildArch: noarch

%if_enabled python3
%description -n python3-module-%name
%else
%description -n python-module-%name
%endif
Battle for Wesnoth is a fantasy turn-based strategy game.
Battle for control of villages, using variety of units which have
advantages and disadvantages in different types of terrains and against
different types of attacks. Units gain experience and advance levels,
and are carried over from one scenario to the next campaign.
Build a Hero, and lead your army. Different races, with distinctive
abilities, weapons and spells.
This package contains python interface to Battle for Wesnoth.
%endif

%prep
%setup -n wesnoth-%version
#patch -p1
%patch1 -p1

%build
%define _optlevel 3
# note for 1.10.5 - outdated.
# evil, evil... configure does not work, cmake does not build translations,
# note for 1.10.7 - upstream really moved to scons.
# scons now works. cmake is outdated and does not build campaignd.
%if_with build_using_scons
scons all \
      	  prefix=%{_prefix} \
          bindir=%{_bindir} \
          libdir=%{_libdir} \
	  fifodir=%_runtimedir/wesnothd%wessuffix \
	  datadirname=%name \
	  docdir=%_docdir/%name \
          extra_flags_release="%optflags" \
%if_enabled python
%if_enabled python3
          python_site_packages_dir=%{python3_sitelibdir_noarch}/%{name} \
%else
          python_site_packages_dir=%{python_sitelibdir_noarch}/%{name} \
%endif
%endif
          %{?_smp_mflags}

# TODO
#	localedirname=locale \

#	  version_suffix=%wessuffix \

	  # let it be default - translations - for now, for cmake install compatibility
	  #localedirname=locale \
%else
export PYTHON_PREFIX=/usr
%if_enabled python3
export PYTHON_VERSION=%__python3_version
%else
export PYTHON_VERSION=%__python_version
%endif
#%%configure \
#    --disable-option-checking \
#    --with-gnu-ld \
#    %{subst_enable nls} \
#    %{subst_enable rpath} \
#    %{subst_enable debug} \
#    %{subst_enable tests} \
#    %{subst_enable static} \
#    %{subst_enable python} \
#    %{subst_enable optipng} \
#    %{subst_enable game} \
#    %{subst_enable server} \
#    %{subst_enable editor} \
#    %{subst_enable tools} \
#    %{subst_enable_to display_revision display-revision} \
#    %{subst_enable sdltest} \

cmake . \
	-DCMAKE_INSTALL_PREFIX=%buildroot%_prefix \
	-DCMAKE_C_FLAGS="%optflags" \
	-DCMAKE_CXX_FLAGS="%optflags" \
	-DDATAROOTDIR=%_datadir \
	-DDATADIRNAME=%name \
	-DDOCDIR=%_docdir/%name \
	-DFIFO_DIR=%_runtimedir/wesnothd%wessuffix \
	-DBINDIR=%_bindir \
	-DENABLE_TOOLS=ON \
	-DENABLE_NLS=ON \
 	-DGETTEXT_FOUND=ON \
 	-DENABLE_STRICT_COMPILATION=OFF \
	-DCMAKE_INSTALL_PREFIX=%buildroot

#-DSERVER_UID=%name \

%make_build VERBOSE=1
%endif # scons

#for s in 96 72 48 36 32 24 22 16; do
#    convert -depth 8 -resize ${s}x$s icons/wesnoth-{icon,$s}.png
#done
bzip2 --keep --best --force changelog*

%install

%if_with install_using_cmake
# cmake install
%make_install \
    DESTDIR=%buildroot \
    docdir=%_docdir/%name-%version \
    appentrydir=%_desktopdir \
    install
%else

%if_with install_using_scons
# scons install
scons install install-pytools destdir=$RPM_BUILD_ROOT
rm %buildroot%_desktopdir/wesnoth.desktop
rm -rf %buildroot/usr/lib/python/site-packages/%name
rm -rf %buildroot%{python3_sitelibdir_noarch}/%{name}
%endif

%if_with install_using_manual
# manual install
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_sbindir
for i in cutter exploder wesnoth; do
        cp -p $i %buildroot%_bindir/
done
cp wesnothd %buildroot%_sbindir/
cp campaignd %buildroot%_sbindir/
mkdir -p %buildroot%{_datadir}/wesnoth
for i in data fonts icons images sounds translations l10n-track; do
        cp -pr $i %buildroot%{_datadir}/wesnoth/
done
%endif

%ifdef wesdesktopsuffix
# cutter exploder
for i in wesnoth wesnoth_addon_manager \
 wmlindent wmllint wmlscope \
 ; do
	 mv %buildroot%_bindir/$i %buildroot%_bindir/${i}%wessuffix
done
cp packaging/wesnoth{,%wessuffix}.desktop
find %buildroot%_mandir -name wesnoth.6 -execdir mv {} wesnoth%wessuffix.6 \;
find %buildroot%_mandir -name wesnothd.6 -execdir mv {} wesnothd%wessuffix.6 \;
sed -i -e 's,Exec=wesnoth,Exec=wesnoth%wessuffix,;s,^\(Name.*\),\1 (%wesdesktopsuffix),' packaging/wesnoth*%{wessuffix}.desktop
%endif

#if with install_using_manual || with install_using_scons
# emulate cmake install
desktop-file-install --dir %buildroot%_desktopdir \
                     --mode="0644" \
                     --remove-key="Version" \
                     packaging/wesnoth%wessuffix.desktop
#mkdir -p %buildroot%{_datadir}/pixmaps
mkdir -p %buildroot%_docdir/
cp -a doc/manual %buildroot%_docdir/%name
%endif

install -d -m 0755 %buildroot%_sbindir
[ -e %buildroot%_bindir/wesnothd ] && mv %buildroot{%_bindir/wesnothd,%_sbindir/wesnothd%wessuffix}
[ -e %buildroot%_bindir/campaignd ] && mv %buildroot{%_bindir/campaignd,%_sbindir/campaignd%wessuffix}

%if_enabled tests
mv %buildroot%_bindir/{,%name-}test
%endif

%if_enabled python
%if_enabled python3
mkdir -p %buildroot/%python3_sitelibdir_noarch
mv %buildroot%_datadir/%name/data/tools/wesnoth %buildroot%python3_sitelibdir_noarch
#mv %buildroot%_datadir/%name/data/tools/addon_manager %buildroot%python3_sitelibdir_noarch
#mv %buildroot%_datadir/%name/data/tools/unit_tree %buildroot%python3_sitelibdir_noarch
find %buildroot%python3_sitelibdir_noarch \( -name wmldata.py -or -name wmlparser.py -or -name wmlparser2.py \) -delete
echo python2 rm -f \
   %buildroot%_datadir/%name/data/tools/expand-terrain-macros.py \
   %buildroot%_datadir/%name/data/tools/journeylifter \
   %buildroot%_datadir/%name/data/tools/rmtrans/rmtrans.py \
   %buildroot%_datadir/%name/data/tools/scoutDefault.py \
   %buildroot%_datadir/%name/data/tools/wmlflip \
   %buildroot%_datadir/%name/data/tools/wmlvalidator \
   %buildroot%_datadir/%name/data/tools/unit_tree/overview.py
%else
mkdir -p %buildroot/%python_sitelibdir_noarch
mv %buildroot%_datadir/%name/data/tools/wesnoth %buildroot%python_sitelibdir_noarch
#mv %buildroot%_datadir/%name/data/tools/addon_manager %buildroot%python_sitelibdir_noarch
#mv %buildroot%_datadir/%name/data/tools/unit_tree %buildroot%python_sitelibdir_noarch
# python2 only
#rm -f \
#%buildroot/%python_sitelibdir_noarch/wmlparser3.py \
#%buildroot/%python_sitelibdir_noarch/wmltools3.py \
#%buildroot/%python_sitelibdir_noarch/wesnoth/campaignserver_client.py \
#%buildroot/%python_sitelibdir_noarch/wesnoth/wmltools3.py \
#%buildroot/%python_sitelibdir_noarch/wesnoth/wmliterator3.py
%endif
%endif

#pushd data
#pushd tools
#for i in wesnoth_addon_manager wml*; do
#    cp $i %buildroot/%_bindir/
#done
#popd
#popd

mkdir -p %buildroot%_docdir/%name-%version/manual
mv %buildroot%_docdir/%name/* %buildroot%_docdir/%name-%version/manual/
install -m 0644 README.md copyright changelog.* %buildroot%_docdir/%name-%version/
%if_enabled editor
for s in 48 32 16; do
    install -D -m 0644 utils/umc_dev/org.wesnoth/icons/wesnoth_editor-icon_$s.png %buildroot%_iconsdir/hicolor/${s}x$s/apps/wesnoth_editor%{wessuffix}.png
done
%endif

mkdir -p packaging/icons/hicolor/48x48/apps/
for s in 48; do convert -depth 8 -resize ${s}x$s packaging/icons/hicolor/{64x64,${s}x${s}}/apps/wesnoth-icon.png
done
# remove wesnoth-icon
rm -rf %buildroot%_iconsdir/hicolor/
for s in 16 32 48 64 128 256; do 
    install -D -m 0644 packaging/icons/hicolor/${s}x${s}/apps/wesnoth-icon.png \
    %buildroot%_iconsdir/hicolor/${s}x$s/apps/%{name}-icon.png
done

mkdir -p %buildroot%_initdir/ %buildroot%_sysconfdir/sysconfig/
cat > %buildroot%_sysconfdir/sysconfig/wesnoth%wessuffix <<'EOF'
#
# wesnothd(6) options. Pick a custom port here if needed, for example.
#
WESNOTHD_OPTIONS=""
EOF
cat > %buildroot%_initdir/wesnothd%wessuffix <<'EOF'
#! /bin/sh
#
# wesnothd%wessuffix	Wesnoth server
#
# chkconfig:	345 98 02
#
# description:	This is a 'Battle for Wesnoth' daemon 
#
#		Modified for ALTLinux
#		by Gleb Stiblo <errandir@gmail.com>
#

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin

# Do not load RH compatibility interface.
WITHOUT_RC_COMPAT=1

# Source function library
. /etc/rc.d/init.d/functions

DAEMON=/usr/sbin/wesnothd%wessuffix
NAME=wesnothd
USER=%_pseudouser_user
LOCKFILE=/var/lock/subsys/wesnothd%wessuffix
PIDFILE=/var/run/wesnothd%wessuffix.pid
SOCKETDIR=/var/run/wesnothd%wessuffix
RETVAL=0

test -x $DAEMON || exit 0

WESNOTHD_OPTIONS=
# Include wesnoth defaults if available
SourceIfNotEmpty /etc/sysconfig/wesnoth%wessuffix || exit 1


start()
{
	# for /var/run on tmpfs
	/bin/mkdir -p $SOCKETDIR/
	/bin/chown -R $USER.$USER $SOCKETDIR/
	start_daemon --make-pidfile $PIDFILE --pidfile $PIDFILE --name $NAME --user $USER -- $DAEMON $WESNOTHD_OPTIONS
	RETVAL=$?
	return $RETVAL
}

stop()
{
	stop_daemon --pidfile $PIDFILE --name $NAME -- $DAEMON 

	RETVAL=$?
	return $RETVAL
}

restart()
{
	stop
	sleep 1
	start
}

# See how we were called.
case "$1" in
  start)
	start
	;;
  stop)
	stop
	;;
  restart)
	restart
	;;
  reload)
	;;
  condstop)
	if [ -e "$LOCKFILE" ]; then
	    stop
	fi
	;;
  condrestart)
	if [ -e "$LOCKFILE" ]; then
	    restart
	fi
	;;
  condreload)
	;;
  status)
	status --pidfile "$PIDFILE" -- $DAEMON
	RETVAL=$?
	;;
  *)
	msg_usage "${0##*/} {start|stop|restart|reload|condstop|condrestart|condreload|status}"
	RETVAL=1
esac

exit $RETVAL
EOF

##### backport specific ###############
mkdir -p %buildroot%_unitdir/
cat > %buildroot%_unitdir/wesnothd%wessuffix.service <<'EOF'
[Unit]
Description=Wesnoth Multiplayer Server Daemon
After=network.target

[Service]
EnvironmentFile=-/etc/sysconfig/wesnoth%wessuffix
User=%_pseudouser_user
ExecStartPre=/bin/mkdir -p /var/run/wesnothd%wessuffix/
ExecStartPre=/bin/chown -R %_pseudouser_user.%_pseudouser_group /var/run/wesnothd%wessuffix/
ExecStart=/usr/sbin/wesnothd%wessuffix $WESNOTHD_OPTIONS

[Install]
WantedBy=multi-user.target
EOF
##### backport specific ###############


%ifdef wesdesktopsuffix
%find_lang --with-man wesnoth%wessuffix
%find_lang --with-man wesnothd%wessuffix
%find_lang wesnoth
%find_lang wesnothd
cat wesnoth.lang >> %name.lang
cat wesnothd.lang >> wesnothd%{wessuffix}.lang
rm -f wesnoth.lang wesnothd.lang
%else
%find_lang --with-man wesnoth
%find_lang --with-man wesnothd
%endif

for d in %buildroot%_datadir/%name/translations/*; do
    l=$(basename "$d")
    c=${l:0:2}
    echo "%%lang($c) %%dir %_datadir/%name/translations/$l" >> %name.lang
    echo "%%lang($c) %%dir %_datadir/%name/translations/$l/LC_MESSAGES" >> %name.lang
    [ -f $d/LC_MESSAGES/wesnoth.mo ] && echo "%%lang($c) %_datadir/%name/translations/$l/LC_MESSAGES/wesnoth.mo" >> %name.lang
    for i in ai anl aoi did dm editor ei httt l lib low multiplayer nr sof sotbe tb test thot trow tsg tutorial units utbs dw help manpages manual sota; do
	[ -f $d/LC_MESSAGES/wesnoth-$i.mo ] && echo "%%lang($c) %_datadir/%name/translations/$l/LC_MESSAGES/wesnoth-$i.mo" >> %name.lang
    done
done
for f in %buildroot%_datadir/%name/data/languages/*_*.cfg; do
    l=$(basename "$f")
    echo "%%lang(${l:0:2}) %_datadir/%name/data/languages/$l" >> %name.lang
done
#    /usr/share/wesnoth/data/languages/racv.cfg
echo "%%lang(racv) %_datadir/%name/data/languages/racv.cfg" >> %name.lang
#    /usr/share/wesnoth/data/languages/en@shaw.cfg
echo "%%lang(en) %_datadir/%name/data/languages/en@shaw.cfg" >> %name.lang

rm -rf %buildroot%_datadir/%name/icons
rm -f %buildroot%_datadir/%name/fonts/DejaVuSans.ttf
ln -s %_datadir/fonts/ttf/dejavu/DejaVuSans.ttf %buildroot%_datadir/%name/fonts/
# sazanami-fonts-gothic
ln -s %_datadir/fonts/ttf/sazanami/gothic/sazanami-gothic.ttf %buildroot%_datadir/%name/fonts/sazanami-gothic.ttf
# wqy-zenhei-fonts
ln -s %_datadir/fonts/ttf/wqy-zenhei/wqy-zenhei.ttc %buildroot%_datadir/%name/fonts/wqy-zenhei.ttc


sed -i 's/wesnoth-icon/wesnoth%{wessuffix}-icon/' %buildroot%_desktopdir/%name.desktop

%if_disabled tools
rm -rf %buildroot%_bindir/wesnoth_addon_manager \
   %buildroot%_bindir/wmlindent \
   %buildroot%_bindir/wmllint \
   %buildroot%_bindir/wmlscope
%endif

%if_enabled server
%pre server
/usr/sbin/groupadd -r -f %_pseudouser_group ||:
/usr/sbin/useradd -g %_pseudouser_group -c 'Wesnoth server' \
        -d %_pseudouser_home -s /dev/null -r %_pseudouser_user >/dev/null 2>&1 ||:

%preun server
%preun_service wesnothd%wessuffix

%post server
%post_service wesnothd%wessuffix
%endif

%files
%_bindir/%name

%files data -f %name.lang
%_desktopdir/%name.desktop
%_datadir/metainfo/%{name}.appdata.xml
%_iconsdir/hicolor/*/apps/%{name}-icon.png
%dir %_docdir/%name-%version
%doc %_docdir/%name-%version/README.md
%doc %_docdir/%name-%version/copyright
%doc %_docdir/%name-%version/changelog.* 
%dir %_datadir/%name
%_datadir/%name/fonts
%_datadir/%name/images
%_datadir/%name/sounds
%dir %_datadir/%name/translations
%dir %_datadir/%name/data
%_datadir/%name/data/COPYING.txt
%_datadir/%name/data/ai/
%_datadir/%name/data/campaigns
%_datadir/%name/data/core
%_datadir/%name/data/gui/
%_datadir/%name/data/hardwired
%_datadir/%name/data/multiplayer
%_datadir/%name/data/shaders
%_datadir/%name/data/themes
%_datadir/%name/data/lua
%_datadir/%name/data/test
%_datadir/%name/data/*.cfg
%dir %_datadir/%name/data/languages
%_datadir/%name/l10n-track
%_man6dir/%name.6*
%if_disabled tools
%dir %_datadir/%name
%dir %_datadir/%name/data
%_datadir/%name/data/tools
%endif

%files doc
%dir %_docdir/%name-%version
/%_docdir/%name-%version/manual

%if_enabled editor
%files editor
%_desktopdir/wesnoth_editor%{wessuffix}.desktop
%_iconsdir/hicolor/*/apps/wesnoth_editor%{wessuffix}.png
%endif

%if_enabled tools
%files tools
#%_bindir/cutter%wessuffix
#%_bindir/exploder%wessuffix
%if_with build_using_scons
%else
%_bindir/schema_generator%wessuffix
%_bindir/schema_validator%wessuffix
%endif
%_bindir/wesnoth_addon_manager%wessuffix
%dir %_datadir/%name
%dir %_datadir/%name/data
%_datadir/%name/data/tools
%{?_enable_tests:%_bindir/%name-test}
%if_enabled python
%_bindir/wml*
%else
%exclude %_bindir/wml*
%endif
%endif

%if_enabled server
%files server -f wesnothd%{wessuffix}.lang
%_sbindir/wesnothd%wessuffix
%_sbindir/campaignd%wessuffix
%_initdir/wesnothd%wessuffix
##### backport specific ###############
%_unitdir/wesnothd%wessuffix.service
##### backport specific ###############
%config(noreplace) %_sysconfdir/sysconfig/wesnoth%wessuffix
%_man6dir/wesnothd%{wessuffix}.6*
%endif

%if_enabled python
%if_enabled python3
%files -n python3-module-%name
%python3_sitelibdir_noarch/wesnoth
#python3_sitelibdir_noarch/addon_manager
#python3_sitelibdir_noarch/unit_tree
%else
%files -n python-module-%name
%python_sitelibdir_noarch/wesnoth
#python_sitelibdir_noarch/addon_manager
#python_sitelibdir_noarch/unit_tree
%endif
%endif

%changelog
