# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
Name: winetricks
Version: 20201206
Release: alt0.M80P.1

Summary: Work around common problems in Wine

License: LGPLv2+
Group: File tools
Url: https://github.com/Winetricks/winetricks

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: %url/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar

BuildArch: noarch

ExclusiveArch: %ix86 x86_64 %arm aarch64

#BuildRequires: wine-common
BuildRequires: desktop-file-utils

# runtime dependencies
#Requires: /usr/bin/wine
Requires: cabextract gzip unzip wget which

#Requires: hicolor-icon-theme
Conflicts: wine-vanilla < 3.18
Conflicts: wine < 3.18
Conflicts: wine-etersoft < 4.0

%description
Winetricks is an easy way to work around common problems in Wine.

It has a menu of supported games/apps for which it can do all the
workarounds automatically. It also lets you install missing DLLs
or tweak various Wine settings individually.
 
%prep
%setup

# fix req. Disable autoreq at all?
%__subst 's|fusermount|a= fusermount|' src/winetricks

sed -i -e "s:steam::" -e "s:flash::" tests/*

%build
# not needed

%install
%makeinstall_std
# some tarballs do not install appdata
install -m0644 -D -t %buildroot%_datadir/metainfo src/%name.appdata.xml

%check
desktop-file-validate %buildroot%_desktopdir/%name.desktop

%files
%doc COPYING debian/copyright
%doc README.md
%_bindir/%name
%_man1dir/%name.1*
%_iconsdir/hicolor/scalable/apps/%name.svg
%_desktopdir/%name.desktop
%_datadir/metainfo/%name.appdata.xml
%_datadir/bash-completion/completions/winetricks
#exclude %_datadir/appdata/%name.appdata.xml

%changelog
