Name:           x2goclient
Version:        4.1.2.1
Release:        alt3
Summary:        X2Go Client application (Qt)

Group:          Communications
License:        GPLv2+
URL:            http://www.x2go.org
Source0:        %name-%version.tar
Source1:        x2goclient_ru.ts
# Drop clumsy attempt at Kerberos delegation
# http://bugs.x2go.org/cgi-bin/bugreport.cgi?bug=731
Patch0:         x2goclient-krb5.patch
# ensure RPM_LD_FLAGS/RPM_OPT_FLAGS are used
# https://bugzilla.redhat.com/show_bug.cgi?id=1306463
Patch2:         x2goclient-optflags.patch
Patch3:  	x2goclient-alt-startkde.patch
Patch4:		x2goclient-encoding.patch
Patch5:		x2goclient-alt-no-pam.patch
Patch6:		alt-qt5.11.patch
Patch7:		x2goclient-alt-select-broker-sessions.patch
Patch8:		x2goclient-strip-home.patch
Patch9:		x2goclient-use-utf8.patch

BuildRequires(pre): libssh-devel
BuildRequires(pre): rpm-build-apache2
BuildRequires:  gcc-c++
BuildRequires:  libcups-devel
BuildRequires:  desktop-file-utils
BuildRequires:  libXpm-devel
BuildRequires:  man
BuildRequires:  libldap-devel
BuildRequires:  qt5-base-devel qt5-svg-devel qt5-x11extras-devel qt5-tools
BuildRequires:  libX11-devel
BuildRequires:  libssl-devel
BuildRequires:  perl-base
BuildRequires:  perl-Proc-Simple
BuildRequires:  perl-Term-ReadPassword
BuildRequires:  zlib-devel
Requires:       icon-theme-hicolor
Requires:       nx-libs >= 3.5.0.31
Requires:       nxproxy >= 3.5.0.31
# For GSSAPI authenticated connections
Requires:       openssh-clients
# For local folder sharing and printing
Requires:       openssh-server

%description
X2Go is a server-based computing environment with
- session resuming
- low bandwidth support
- session brokerage support
- client-side mass storage mounting support
- client-side printing support
- audio support
- authentication by smartcard and USB stick

X2Go Client is a graphical client (Qt) for the X2Go system.
You can use it to connect to running sessions and start new sessions.


%prep
%setup -q
%patch0 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
# update russian translations
cat %SOURCE1 >res/i18n/x2goclient_ru.ts
# Fix up install issues
sed -i -e 's/-o root -g root//' Makefile
sed -i -e '/^MOZPLUGDIR=/s/lib/%{_lib}/' Makefile
# Use system qtbrowserplugin
sed -i -e '/CFGPLUGIN/aTEMPLATE=lib' x2goclient.pro
sed -i -e '/^LIBS /s/$/ -ldl/' x2goclient.pro
for f in Makefile config_linux.sh ; do
    sed -i 's|-qt4|-qt5|g' $f
    sed -i 's|X2GO_CLIENT_TARGET=plugin|X2GO_CLIENT_TARGET=""|g' $f
done

%define libsshver %(rpm -q --qf '%%{VERSION}' libssh 0.8)
%if "%(rpmvercmp %libsshver 0.8 )" >= "0"
# libssh-0.8
sed -i -e '/^LIBS /s/-lssh_threads//' x2goclient.pro
%endif

%build
export PATH=%{_qt5_bindir}:$PATH
%make_build

%install
%make_install DESTDIR=%buildroot PREFIX=%_prefix install_client install_man
desktop-file-validate %buildroot%_desktopdir/%name.desktop

mkdir -p %buildroot%_sysconfdir/httpd/conf.d
ln -s ../../x2go/x2goplugin-apache.conf %buildroot%_sysconfdir/httpd/conf.d/x2goplugin-provider.conf

%files
%doc AUTHORS COPYING LICENSE 
%_bindir/%name
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/%name.png
%_datadir/%name/
%_man1dir/%name.1*

%changelog
