# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/gsl-config /usr/bin/msgmerge /usr/bin/nasm libICE-devel libSM-devel pkgconfig(glib-2.0) pkgconfig(gtk+-2.0) 
# END SourceDeps(oneline)

Name: xaos
Version: 3.6
Release: alt1.1.1
Summary: A real-time fractal zoomer
Serial: 1

License: GPL

Group: Sciences/Mathematics
Url: http://xaos.sourceforge.net
Packager: Ilya Mashkin <oddity@altlinux.ru>
Source0: http://prdownloads.sourceforge.net/xaos/xaos-%version.tar.gz
Source1: xaos.png
Source10: %name.16.xpm.bz2
Source11: %name.32.xpm.bz2
Source12: %name.48.xpm.bz2

Patch0:	xaos-3.5-fix-conflicting-register-types.patch

Provides : XaoS = %version, %name-aalib = %version
Obsoletes: XaoS, %name-aalib

BuildRequires: aalib-devel imake libICE-devel libXxf86dga-devel zlib-devel  gettext
BuildRequires: libXxf86vm-devel libgpm-devel libXext-devel libX11-devel libXt-devel libgsl90-devel
BuildRequires: libncurses-devel libpng12-devel libslang-devel nasm xorg-cf-files libgtk+2-devel libXext-devel
BuildRequires:	texlive-base-bin
# explicitly added texinfo for info files
BuildRequires: texinfo


%description
XaoS is a real-time fractal zoomer. It is highly optimized. It features an
advanced help system and nice tutorial about a lot different fractals.

This package holds the binary that runs with X11.

%prep
%setup -q -n xaos-%version
%patch0 -p1 -b .proto
# disable stripping binaries when installing
sed -i 's| -s | |' Makefile.in
sed -i 's,\$x_includes/X11/extensions/XShm.h,/usr/include/X11/extensions/XShm.h,' configure.in configure

%build
%ifarch %ix86 x86_64
%define long_double --with-long-double
%endif
%configure \
   --with-x11-driver \
    --with-gsl=yes \
    --with-sffe=yes \
    --with-gtk-driver=yes \
    --with-aa-driver=yes \
    --with-pthread=yes \
    %{long_double}
# due to the buggy configure it has the opposite effect
#    --with-png=yes \
%make

%install
mkdir -p %buildroot%_infodir
%makeinstall LOCALEDIR=%buildroot%_datadir/locale

pushd doc
make xaos.dvi
dvipdfm xaos.dvi
popd
pushd help
make html
popd

%if_with aalib
install -m755 xaos-aalib %buildroot%_bindir
%endif

%if_with svgalib
install -m755 xaos-svgalib %buildroot%_bindir
%endif

install -m644 help/xaos.hlp %buildroot%_datadir/XaoS/catalogs

# menu entry
install -m755 -d %buildroot%_desktopdir/
cat > %buildroot%_desktopdir/%{name}.desktop <<EOF
[Desktop Entry]
Encoding=UTF-8
Version=1.0
Type=Application
Name=XaoS
Comment=Interactive fractal zoomer
Icon=%{name}
#Exec=%{name}
Exec=xaos -driver "GTK+ Driver"
Terminal=false
Categories=Education;Science;Math;
EOF

# icon
mkdir -p %buildroot%_miconsdir
mkdir -p %buildroot%_liconsdir
mkdir -p %buildroot%_niconsdir
bzcat %SOURCE10 > %buildroot%_miconsdir/%name.xpm
bzcat %SOURCE11 > %buildroot%_niconsdir/%name.xpm
bzcat %SOURCE12 > %buildroot%_liconsdir/%name.xpm
cp %SOURCE1 %buildroot%_liconsdir/%name.png

%find_lang %name

%files -f %name.lang
%doc README COPYING TODO ChangeLog NEWS
%doc AUTHORS doc/xaos.pdf

%_bindir/%name
%_datadir/XaoS
%_mandir/man6/*
%_infodir/*.info*
%_desktopdir/%name.desktop
%_miconsdir/%name.xpm
%_niconsdir/%name.xpm
%_liconsdir/%name.xpm
%_liconsdir/%name.png

%changelog
