%def_with python
%def_without ruby

Name: xapian-bindings
Version: 1.2.23
Release: alt1.M80P.1

Summary: Xapian search engine bindings
License: GPL
Group: Development/Other

Url: http://www.xapian.org/
Source: http://www.oligarchy.co.uk/xapian/%version/%name-%version.tar.xz
Source100: xapian-bindings.watch

%setup_python_module %name

# Automatically added by buildreq on Thu Dec 05 2013
# optimized out: elfutils gnu-config libncurses-devel libstdc++-devel libtinfo-devel pam0_userpass python-base python-modules python-modules-compiler ruby ruby-stdlibs xz
BuildRequires: gcc-c++ libruby-devel libxapian-devel python-devel
BuildRequires: python-module-sphinx-devel python-module-sphinx

%{?_with_python:BuildRequires: python-devel}
%{?_with_ruby:BuildRequires: libruby-devel}

BuildPreReq: libxapian-devel = %version

%description
Xapian is an Open Source Probabilistic Information Retrieval framework.
It offers a highly adaptable toolkit that allows developers to easily
add advanced indexing and search facilities to applications.

This package contains programming language bindings.

%if_with python
%package -n python-module-xapian
Summary: Python bindings for Xapian search engine
License: GPL
Group: Development/Python
# force rebuild with libxapian
Requires: libxapian = %version

%description -n python-module-xapian
Xapian is an Open Source Probabilistic Information Retrieval framework.
It offers a highly adaptable toolkit that allows developers to easily
add advanced indexing and search facilities to applications.

This package provides the files needed for developing Python scripts
which use Xapian.
%endif

%if_with ruby
%package -n ruby-xapian
Summary: Ruby bindings for Xapian search engine
License: GPL
Group: Development/Ruby
Requires: libxapian = %version

%description -n ruby-xapian
Xapian is an Open Source Probabilistic Information Retrieval framework.
It offers a highly adaptable toolkit that allows developers to easily
add advanced indexing and search facilities to applications.

This package provides the files needed for developing Ruby scripts
which use Xapian.
%endif

%prep
%setup

%build
%configure %{subst_with python} %{subst_with ruby}
%make_build
# FIXME: maybe we should drop %version there as well and get rid of this

%install
%makeinstall_std
rm -rf %buildroot%_defaultdocdir/%name/

%if_with python
%files -n python-module-xapian
%doc README python/docs/*
%python_sitelibdir/*
%endif

%if_with ruby
%files -n ruby-xapian
%doc README ruby/docs/*
%ruby_sitearchdir/_xapian.so
%ruby_sitelibdir/xapian.rb
%endif

# TODO:
# - package other bindings (perl, tcl...)
# - package docs/examples properly

%changelog
