Name: xdg-utils
Version: 1.1.3
Release: alt5

Summary: A set of command line tools that assist applications with a variety of desktop integration tasks

License: MIT
Group: System/Base
Url: https://www.freedesktop.org/wiki/Software/xdg-utils/

# Source-url: https://portland.freedesktop.org/download/xdg-utils-%version.tar.gz
Source: %name-%version.tar

Patch0: added-xdg-su-1.1.0rc1-alt.patch
Patch1: xdg-open-opera.patch
Patch2: xdg-su-added-lxde-and-gksu-and-beesu-support-1.1.2.patch
Patch5: xdg-open-generic-mimeapps.patch
Patch6: xdg-su-use-gnomesu-for-xfce-if-available.patch
Patch7: xdg-open-fix-ifs-use.patch
Patch8: xdg-open-kde5.patch
Patch9: xdg-su-kde5.patch
Patch10: xdg-common-detect-de-generic.patch
Patch11: xdg-open-added_open_lxqt.patch
Patch12: xdg-open-fix-open-url-in-lxde.patch
Patch13: xdg-desktop-menu-dummy.patch
Patch14: xdg-email-detect-thunderbird-kde5.patch
Patch15: xdg-email-detect-thunderbird-mate.patch

BuildArch: noarch

# Automatically added by buildreq on Wed Apr 25 2007
BuildRequires(pre): rpm-build-ubt
BuildRequires: xmlto w3m

AutoReq: no
Requires: coreutils, file, gawk, grep, procps, sed, sh, which, xprop, xset

%description
Xdg-utils is a set of command line tools that assist applications with
a variety of desktop integration tasks. About half of the tools focus on
tasks commonly required during the installation of a desktop application
and the other half focuses on integration with the desktop environment
while the application is running. Even if the desktop components of your
application are limited to an installer, configuration or management tool,
Xdg-utils provides you with an easy way to enhance the usage experience
of your customers by improving the integration of these components in
the user's environment.

The following scripts are provided at this time:
* xdg-desktop-menu      Install desktop menu items
* xdg-desktop-icon      Install icons to the desktop
* xdg-icon-resource     Install icon resources
* xdg-mime              Query information about file type handling and
                        install descriptions for new file types
* xdg-open              Open a file or URL in the user's preferred application
* xdg-email             Send mail using the user's preferred e-mail composer
* xdg-screensaver       Control the screensaver
* xdg-su                Run as root

Testsuite for xdg-utils is available from
http://portland.freedesktop.org/wiki/TestSuite

%prep
%setup
pushd scripts
# we should _never_ patch generated files
ls *.in | sed -e 's,\(.*\)\.in$,\1,' | xargs rm -f
popd
%patch0 -p2
#patch1 -p1
%patch2 -p2
%patch5 -p1
%patch6 -p2
#patch7 -p2
#patch8 -p1
%patch9 -p1
%patch10 -p2
%patch11 -p2
%patch12 -p2
%patch13 -p1
%patch14 -p1
%patch15 -p1

%build
%autoreconf
%configure
%make_build
%make_build -C scripts scripts

%install
%makeinstall_std

%files
%_bindir/xdg-desktop-icon
%_bindir/xdg-desktop-menu
%_bindir/xdg-email
%_bindir/xdg-icon-resource
%_bindir/xdg-mime
%_bindir/xdg-open
%_bindir/xdg-screensaver
%_bindir/xdg-settings
%_bindir/xdg-su
%_man1dir/*
%doc ChangeLog README LICENSE RELEASE_NOTES TODO

%changelog
