Name: xfce4-session
Version: 4.12.1
Release: alt4

Summary: Session manager for Xfce desktop environment
Summary (ru): Менеджер сессий для окружения рабочего стола Xfce
License: %gpl2plus
Group: Graphical desktop/XFce
Url: http://www.xfce.org/
Packager: Xfce Team <xfce@packages.altlinux.org>

# Upstream: git://git.xfce.org/xfce/xfce4-session
Source: %name-%version.tar
Source1: xfce.wmsession
# taken from polkit-gnome, license is LGPLv2+, requires because of
# http://lists.fedoraproject.org/pipermail/devel-announce/2011-February/000758.html
# Renamed to avoid file conflict with gdm.
Source2: polkit-gnome-authentication-agent-1-xfce.desktop

Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfconf-devel libxfce4ui-devel
# For gdk-pixbuf-csource and exo-csource (needed in maintainer mode)
BuildRequires: libgdk-pixbuf-devel libexo-devel
BuildRequires: libpolkit-devel
BuildRequires: iceauth intltool libSM-devel libglade-devel libwnck-devel xorg-cf-files

Requires: wm-common-freedesktop
Requires: xfce4-about

Obsoletes: xfce-utils < %version

%define _unpackaged_files_terminate_build 1

%description
%name is the session manager for the Xfce desktop environment.

%description -l ru
Данный пакет содержит в себе менеджер сессий, используемый в окружении
рабочего стола Xfce.

%package -n libxfsm
Summary: Library for Xfce session manager plugins
Group: Development/C
License: GPL

%description -n libxfsm
This package contains library for Xfce session manager.

%package devel
Summary: Development files to build Xfce session manager plugins
Group: Development/C
License: GPL
PreReq: libxfsm = %version-%release

%description devel
This package contains files to develop plugins for Xfce session manager.

%package engines
Summary: Additional splash screen engines for Xfce session manager
Group: Graphical desktop/XFce
License: GPL
PreReq: %name = %version-%release

%description engines
Additional splash screen engines for Xfce session manager.

%prep
%setup
%patch -p1

%build
# Don't use git tag in version.
%xfce4_drop_gitvtag xfsm_version_tag configure.ac.in
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--with-backend=linux \
	--enable-debug=no
%make_build

%install
%makeinstall_std
install -Dm0644 %SOURCE1 %buildroot%_x11sysconfdir/wmsession.d/10Xfce4
install -Dm0644 %SOURCE2 %buildroot%_sysconfdir/xdg/autostart/polkit-gnome-authentication-agent-1-xfce.desktop
%find_lang %name

%files -f %name.lang
%doc README NEWS AUTHORS
%doc doc/FAQ doc/README.Kiosk
%_x11sysconfdir/wmsession.d/*
%config(noreplace) %_sysconfdir/xdg/xfce4/*
%config(noreplace) %_sysconfdir/xdg/autostart/*.desktop
%_sysconfdir/xdg/xfce4/xfconf/xfce-perchannel-xml/xfce4-session.xml
%_bindir/*
%dir %_libdir/xfce4/session
%dir %_libdir/xfce4/session/splash-engines
%_libdir/xfce4/session/splash-engines/libmice.so
%exclude %_libdir/xfce4/session/splash-engines/*.la
%_libdir/xfce4/session/xfsm-*
%_desktopdir/*
%_iconsdir/hicolor/*/*/*
%_mandir/man?/*
%_datadir/xsessions/*.desktop
%_datadir/polkit-1/actions/*.policy

%files -n libxfsm
%_libdir/lib*.so.*

%files devel
%_includedir/xfce4/*
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%files engines
%_datadir/themes/Default/balou
%_libdir/xfce4/session/splash-engines/*.so
%exclude %_libdir/xfce4/session/splash-engines/libmice.so
%_libdir/xfce4/session/balou*

%changelog
