Name:         xfig
Version:      3.2.5c
Release:      alt3

Summary:      An X Window System tool for drawing basic vector graphics.
Group:        Graphics
URL:          http://epb.lbl.gov/xfig/
License:      Freeware

Packager:     Vladislav Zavjalov <slazav@altlinux.org>
Source:       %name-%version.tar.gz
Patch1:       %name-%version-alt.patch

Requires:     transfig >= 3.2.5 fonts-type1-urw

BuildPreReq:  imake xorg-cf-files
BuildPreReq:  libXpm-devel libXt-devel libXmu-devel libXaw-devel
BuildPreReq:  libpng-devel libjpeg-devel libXi-devel libXp-devel
BuildPreReq:  libXaw3d-devel >= 1.5e

%description
Xfig is an X Window System tool for creating basic vector graphics,
including arcs, ellipses, bezier curves, lines, rulers and more.
The resulting graphics can be saved, printed on PostScript printers 
or converted to a variety of other formats (e.g., X11 bitmaps, CGM,
Encapsulated PostScript, LaTeX).

You should install xfig if you need a program to create vector graphics.

%package -n xfig-libs
Summary:  XFig image libraries
Group:    Graphics
BuildArch: noarch

%description -n xfig-libs
Library of FIG images

%package -n xfig-docs
Summary:  XFig documentation
Group:    Graphics
BuildArch: noarch

%description -n xfig-docs
XFig documentation

%prep
%setup -q
%patch1 -p1

%build
CDEBUGFLAGS=OptimizedCDebugFlags
# Optimization can break xfig on x86_64?
#%ifarch x86_64
#CDEBUGFLAGS=NoOpCDebugFlags
#%endif
# Uncomment to build with -g flag:
# CDEBUGFLAGS=DebuggableCDebugFlags
xmkmf -DXAW3D -DXAW3D1_5E -DDefaultCDebugFlags=$CDEBUGFLAGS
ln -nfs Doc/xfig.man xfig.man
make DESTDIR=%buildroot

%install
make DESTDIR=%buildroot install.all

install -D -m 755 xfig.sh      %buildroot/%_bindir/xfig.sh
install -D -m 644 xfig48.png   %buildroot/%_liconsdir/xfig.png
install -D -m 644 xfig32.png   %buildroot/%_niconsdir/xfig.png
install -D -m 644 xfig16.png   %buildroot/%_miconsdir/xfig.png
install -D -m 644 xfig.desktop %buildroot/%_desktopdir/xfig.desktop

%files
%_bindir/xfig
%_bindir/xfig.sh
%_man1dir/*
%_x11appconfdir/*
%_desktopdir/xfig.desktop
%_liconsdir/xfig.png
%_niconsdir/xfig.png
%_miconsdir/xfig.png
%dir /usr/share/xfig/
/usr/share/xfig/CompKeyDB

%files -n xfig-libs
/usr/share/xfig/Libraries

%files -n xfig-docs
/usr/share/doc/xfig

%changelog
