%define libname libxmlrpc

Name: xmlrpc-c
Version: 1.39.12
Release: alt0.M80P.svn2910

Summary: XML-RPC C library - an implementation of the xmlrpc protocol
License: BSD-style
Group: System/Libraries

Url: http://xmlrpc-c.sourceforge.net/

Source: %name-%version.tar


Patch1: %name-1.12.00-alt-configure-fixes.patch
Patch2: %name-30x-redirect.patch
Patch3: %name-uninit-curl.patch
# Patch4: %name-curl-types.h.patch
Patch5: 0002-Use-proper-datatypes-for-long-long.patch
# Patch6: %name-check-vasprintf-return-value.patch
# Patch7: %name-include-string_int.h.patch
Patch8: %name-printf-size_t.patch
Patch9: 0001-xmlrpc_server_abyss-use-va_args-properly.patch

BuildRequires: libcurl-devel libxml2-devel gcc-c++ cmake
BuildRequires: libncurses-devel libncursesxx-devel
BuildRequires: libssl-devel zlib-devel

%description
XML-RPC for C/C++ is programming libraries and related tools to help you
write an XML-RPC server or client in C or C++.

%package -n %libname
Summary: XML-RPC C library - an implementation of the xmlrpc protocol
Group: System/Libraries

%description -n %libname
XML-RPC for C/C++ is programming libraries and related tools to help you
write an XML-RPC server or client in C or C++.


%package -n %libname-devel
Summary: Files for developing applications that use %libname
Requires: %libname = %version-%release
Requires: libcurl-devel libexpat-devel libssl-devel w3c-libwww-devel libxml2-devel
Group: Development/C

%description -n %libname-devel
The header file for developing applications that use
%name.


%package -n %libname++
Summary: XML-RPC C++ library - an implementation of the xmlrpc protocol
Group: System/Libraries
Requires: %libname = %version-%release

%description -n %libname++
XML-RPC for C/C++ is programming libraries and related tools to help you
write an XML-RPC server or client in C or C++.

This package contains C++ bindings for %libname.


%package -n %libname++-devel
Summary: Files for developing applications that use %libname++
Requires: %libname++ = %version-%release
Requires: %libname-devel = %version-%release
Group: Development/C++

%description -n %libname++-devel
The header file for developing applications that use
%libname++.


%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
# %patch4 -p1
%patch5 -p1
# %patch6 -p1
# %patch7 -p1
%patch8 -p1
%patch9 -p1

%build
export CFLAGS="$RPM_OPT_FLAGS -Wno-uninitialized -Wno-unknown-pragmas"
export CXXFLAGS="$RPM_OPT_FLAGS"

autoconf
%configure --enable-libxml2-backend
%make AR="ar" RANLIB="ranlib"
%make -C tools AR="ar" RANLIB="ranlib"

%install
%makeinstall_std AR="ar" RANLIB="ranlib"
%makeinstall_std -C tools AR="ar" RANLIB="ranlib"
rm -f %buildroot%_libdir/*.a
#mkdir -p %buildroot%_pkgconfigdir
#mv %buildroot%prefix%_pkgconfigdir/*.pc %buildroot%_pkgconfigdir

%files
%doc README doc/*
%doc tools/xmlrpc_transport/xmlrpc_transport.html
%_man1dir/*
%_bindir/xmlrpc
%_bindir/xmlrpc_transport
%_bindir/xml-rpc-api2cpp
%_bindir/xmlrpc_cpp_proxy
%_bindir/xmlrpc_parsecall
%exclude %_bindir/xml-rpc-api2txt

%files -n %libname
%_libdir/*.so.3*

%files -n %libname-devel
%_bindir/xmlrpc-c-config
%_includedir/xmlrpc-c/
%_includedir/*.h
#%_pkgconfigdir/*.pc
%_libdir/*.so

%files -n %libname++
%_libdir/*.so.8*


%changelog
