Name: xz
Version: 5.2.3
Release: alt0.M80P.1

Summary: LZMA/XZ compression programs
# We don't package scripts to grep, diff, and view compressed files here
# because they are already packaged in gzip-utils.
# see COPYING
License: Public Domain
Group: Archiving/Compression
URL: http://tukaani.org/xz/
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: liblzma = %version-%release

# Last lzma-utils version was 4.32.7
Provides: lzma-utils = 4.32.9
Obsoletes: lzma-utils < 4.32.9

# Automatically added by buildreq on Fri Jul 20 2012
# optimized out: xz
BuildRequires: glibc-devel-static

%description
This package provides a set of gzip-style tools for working with
files compressed with the Lempel-Ziv/Markov-chain compression method.
It supports two formats: .xz and the older .lzma format.

%package -n liblzma
Summary: LZMA/XZ compression library
Group: System/Libraries

%package -n liblzma-devel
Summary: API headers and other development files related to liblzma
Group: Development/C
Requires: liblzma = %version-%release
Conflicts: lzmalib-devel

%package -n liblzma-devel-static
Summary: Static liblzma compression library
Group: Development/C
Requires: liblzma-devel = %version-%release

%description -n liblzma
This package provides data compression library for working with
files compressed with the Lempel-Ziv/Markov-chain compression method.
It supports two formats: .xz and the older .lzma format.

%description -n liblzma-devel
This package contains the API headers, development library, and
other development files related to liblzma

%description -n liblzma-devel-static
This package contains static liblzma compression library.

%prep
%setup -q
%patch -p1

%build
%autoreconf
%define docdir %_docdir/%name-%version
%configure --enable-dynamic --disable-scripts --docdir=%docdir
cflags=$(sed -n 's/^CFLAGS = //p' src/liblzma/Makefile)
%make_build -C src/liblzma CFLAGS="${cflags:?} %{!?_enable_debug:-O3}" liblzma_la-lzma_decoder.lo
%make_build

%def_enable profile
%if_enabled profile
rm src/liblzma/*.lo src/liblzma/liblzma.la
%make_build -C src/liblzma CFLAGS="$cflags -fprofile-generate %{!?_enable_debug:-O3}" liblzma_la-lzma_decoder.lo
%make_build -C src/liblzma CFLAGS="$cflags -fprofile-generate"
./libtool --tag=CC --mode=link gcc %optflags -fprofile-generate -static src/xz/xz-*.o src/liblzma/liblzma.la -o xz.static
for i in 0 2 6; do
	tar cf - . |./src/xz/xz -$i |./xz.static -d >/dev/null
	tar cf - . |./xz.static -$i |./src/xz/xz -d >/dev/null
	tar cf - . |./src/xz/xz --format=lzma -$i |./xz.static -d >/dev/null
	tar cf - . |./xz.static --format=lzma -$i |./src/xz/xz -d >/dev/null
done
rm src/liblzma/*.lo src/liblzma/liblzma.la
%make_build -C src/liblzma CFLAGS="$cflags -fprofile-use %{!?_enable_debug:-O3}" liblzma_la-lzma_decoder.lo
%make_build -C src/liblzma CFLAGS="$cflags -fprofile-use"
%make_build
%endif

%install
%makeinstall_std

# Relocate shared library from %_libdir/ to /lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/liblzma.so; do
	t=$(readlink "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# GPL'ed files are not packaged.
rm %buildroot%docdir/COPYING.GPL*

%find_lang xz

%check
make -k check

%files -f xz.lang
%_bindir/*lz*
%_bindir/*xz*
%_man1dir/*lz*.1*
%_man1dir/*xz*.1*

%files -n liblzma
/%_lib/liblzma.so.*
%docdir
%exclude %docdir/examples
%exclude %docdir/*-file-format.txt

%files -n liblzma-devel
%_includedir/lzma.h
%_includedir/lzma/
%_libdir/liblzma.so
%_pkgconfigdir/liblzma.pc
%dir %docdir
%docdir/examples
%docdir/*-file-format.txt

%files -n liblzma-devel-static
%_libdir/liblzma.a

%changelog
