Name: yafaray
Version: 0.1.1
Release: alt2.qa3

Summary: YafaRay is a raytracing open source render engine
License: LGPL
Group: Graphics
Url: http://www.yafaray.org
Packager: Sergey Kurakin <kurakin@altlinux.org>

Source: YafaRay.%version.zip

%py_provides yafrayinterface

BuildRequires: gcc-c++ libfreetype-devel libjpeg-devel libpng-devel
BuildRequires: libxml2-devel openexr-devel python-devel scons swig unzip
BuildRequires: libqt4-devel

%description
Raytracing is a rendering technique for generating realistic images
by tracing the path of light through a 3D scene. An engine consists of
a computer program that interacts with a host 3D application to provide
very specific raytracing capabilties "on demand". Blender is the host
application of YafaRay.
YafaRay is a new raytracing render engine written from scratch,
and it replaces YafRay 0.0.9. After two years of development,
it already features a complete set of lighting
and rendering options.

%package yafqt
Group: Graphics
Summary: Graphic display for YafaRay
Requires: %name = %version-%release

%description yafqt
YafQt is a graphic display for YafaRay.

%prep
%setup -n %name

cat > user-config.py <<__EOF__
PREFIX = '%buildroot%_usr'
CCFLAGS = '%optflags %optflags_shared'
REL_CCFLAGS = '%optflags %optflags_shared'
YF_LIBOUT = '%buildroot%_libdir'
YF_PLUGINPATH = '%buildroot%_libdir/%name'
YF_BINPATH = '%buildroot%_bindir'
WITH_YF_QT = 'true'
YF_QTDIR = '%_libdir/qt4'
__EOF__

sed -i 's|\$YF_PLUGINPATH|%_libdir/%name|g' tools/writeconfig.py
sed -i 's|\$YF_LIBOUT|%_libdir|g' tools/writeconfig.py

%build
scons build
scons swig

%install

scons install
install -d -m755 %buildroot%_libdir/blender/scripts
install -p -m644 bindings/python/* %buildroot%_libdir/blender/scripts

%files
%dir %_libdir/%name
%_libdir/%name/*.so
%_libdir/*.so
%exclude %_libdir/libyafarayqt.so
%_bindir/*
%_libdir/blender/scripts/*yafrayinterface.*

%files yafqt
%_libdir/libyafarayqt.so
%_libdir/blender/scripts/*yafqt.*

%changelog
