%define _unpackaged_files_terminate_build 1

%define ver_major 3.22
%def_disable debug
%def_enable lzma

Name: yelp
Version: %ver_major.0
Release: alt0.M80P.1

Summary: Lightweight help browser for GNOME
License: %gpl2plus
Group: Graphical desktop/GNOME
Url: http://yelp.io

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

# From configure.ac
%define gio_ver 2.38
%define gtk_ver 3.14
%define xslt_ver 1.1.4
%define webkit_ver 2.8
%define yelpxsl_ver 3.20.0
%define intltool_ver 0.5.0

Requires: lib%name = %version-%release
Requires: yelp-xsl >= %yelpxsl_ver
Requires: dconf gnome-icon-theme gnome-icon-theme-symbolic

BuildPreReq: rpm-build-licenses rpm-build-gnome gnome-common intltool >= %intltool_ver itstool gtk-doc
BuildPreReq: libgio-devel >= %gio_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libxslt-devel >= %xslt_ver
BuildPreReq: libwebkit2gtk-devel >= %webkit_ver
BuildPreReq: yelp-xsl >= %yelpxsl_ver
BuildRequires: zlib-devel bzlib-devel libsqlite3-devel
%{?_enable_lzma:BuildRequires: liblzma-devel}

%description
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation. The name Yelp was suggested by Daniel Lundin.
Yelp is pronounced the same as the swedish word for 'help'.

%package -n lib%name
Summary: Shared library for Yelp
Group: System/Libraries

%description -n lib%name
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation.

This package provides shared library required for dconf to work

%package -n lib%name-devel
Summary: Development files for Yelp library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation.

This is a Yelp development package. Contains files needed for doing
development using Yelp.

%package -n lib%name-devel-doc
Summary: Development documentation for Yelp library
Group: Development/C
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation.

This package contains documentation needed for doing development using
Yelp.


%prep
%setup

%build
%configure \
	--disable-static \
	--disable-schemas-compile \
	%{subst_enable debug} \
	%{subst_enable lzma}

%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_bindir/gnome-help
%_bindir/%name
%_desktopdir/%name.desktop
%_datadir/%name/
%_datadir/yelp-xsl/xslt/common/domains/yelp.xml
%config %_datadir/glib-2.0/schemas/org.gnome.yelp.gschema.xml
%doc AUTHORS README NEWS TODO

%files -n lib%name
%_libdir/*.so.*
%_libdir/%name/
%exclude %_libdir/%name/*/*.la

%files -n lib%name-devel
%_includedir/lib%name/
%_libdir/*.so

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/lib%name/

%changelog
