%define zabbix_user	zabbix
%define zabbix_group	zabbix
%define zabbix_home	/dev/null
%define svnrev		92831
%define plain_name	zabbix

%def_with pgsql
%def_enable java
%def_with ssh2
%def_with unixodbc

%def_enable ipv6

%ifndef _unitdir
%define _unitdir %systemd_unitdir
%endif

Name: zabbix40
Version: 4.0.7
Release: alt0.M80P.1
Epoch: 1

Summary: A network monitor
License: GPLv2
Group: Monitoring

Url: http://www.zabbix.com

# http://heanet.dl.sourceforge.net/sourceforge/%name/%name-%version.tar.gz
Source0: %name-%version.tar
Patch0: %name-%version-alt.patch

%{?_enable_java:BuildPreReq: java-devel-default}
BuildPreReq: libelf-devel
BuildRequires(pre): rpm-build-webserver-common rpm-macros-apache2

# Automatically added by buildreq on Thu Nov 02 2017 (-bi)
# optimized out: elfutils glibc-kernheaders-generic glibc-kernheaders-x86 libcom_err-devel libkrb5-devel libnet-snmp30 libp11-kit libpq-devel libsasl2-3 libssl-devel net-snmp-config perl pkg-config python-base python3 rpm-build-python3 xz
BuildRequires: libcurl-devel libelf-devel libevent-devel libiksemel-devel libldap-devel libmysqlclient-devel libnet-snmp-devel libopenipmi-devel libpcre-devel libsqlite3-devel libxml2-devel postgresql-devel python3-base
BuildRequires: perl-Switch zlib-devel
%if_with ssh2
BuildRequires: libssh2-devel
%endif
%if_with unixodbc
BuildRequires: libunixODBC-devel
%endif

%{?_enable_java:BuildRequires: java-devel rpm-build-java}

%if_with pgsql
BuildRequires: postgresql-devel
%endif

%package common
Summary: %plain_name network monitor (common stuff)
Group: Monitoring
Conflicts: %plain_name-common <= 1:4.0.6-alt1
BuildArch: noarch

%package common-database-sqlite3
Summary: %plain_name common database stuff (for sqlite3)
Group: Monitoring
Conflicts: %plain_name-common-database-sqlite3 <= 1:4.0.6-alt1
BuildArch: noarch

%package common-database-mysql
Summary: %plain_name common database stuff (for mysql)
Group: Monitoring
Conflicts: %plain_name-common-database-mysql <= 1:4.0.6-alt1
BuildArch: noarch

%if_with pgsql
%package common-database-pgsql
Summary: %plain_name common database stuff (for postgresql)
Group: Monitoring
Conflicts: %plain_name-common-database-pgsql <= 1:4.0.6-alt1
BuildArch: noarch
%endif

%package server-common
Summary: %plain_name network monitor (server common stuff)
Group: Monitoring
Conflicts: %plain_name-common-database-pgsql <= 1:4.0.6-alt1
Requires: %name-common >= 1:2.0.4-alt1

%package server-mysql
Summary: %plain_name network monitor (server, compiled with MySQL support)
Group: Monitoring
Requires: %name-server-common >= 1:2.0.4-alt1
Requires: %name-common-database-mysql = %EVR
Requires: %_sbindir/fping
Obsoletes: %name-mysql < 1:1.1.7-alt1
Conflicts: %plain_name-server-mysql <= 1:4.0.6-alt1

%if_with pgsql
%package server-pgsql
Summary: %plain_name network monitor (server, compiled with PostgreSQL support)
Group: Monitoring
Requires: %name-server-common >= 1:2.0.4-alt1
Requires: %name-common-database-pgsql = %EVR
Requires: %_sbindir/fping
Obsoletes: %name-pgsql < 1:1.1.7-alt1
Conflicts: %plain_name-server-pgsql <= 1:4.0.6-alt1
%endif

%package agent
Summary: %plain_name agent
Group: Monitoring
Requires: %name-common >= 1:2.0.4-alt1
Conflicts: %plain_name-agent <= 1:4.0.6-alt1

%package agent-sudo
Summary: sudo entry for %plain_name agent
Group: Monitoring
BuildArch: noarch
Requires: %name-agent
Conflicts: %plain_name-agent <= 1:4.0.6-alt1

%package proxy
Summary: %plain_name proxy with Sqlite3 support
Group: Monitoring
Requires: %name-proxy-common = %EVR
Requires: %name-common-database-sqlite3 = %EVR
Conflicts: %name-proxy-pgsql
Conflicts: %plain_name-proxy <= 1:4.0.6-alt1

%if_with pgsql
%package proxy-pgsql
Summary: %plain_name proxy with PostgreSQL support
Group: Monitoring
Requires: %name-proxy-common = %EVR
Requires: %name-common-database-pgsql = %EVR
Conflicts: %name-proxy
Conflicts: %plain_name-proxy-pgsql <= 1:4.0.6-alt1
%endif

%package proxy-common
Summary: %plain_name proxy common files
Group: Monitoring
Requires: %name-common >= 1:2.0.4-alt1
Requires: %_sbindir/fping
Conflicts: %plain_name-proxy-common <= 1:4.0.6-alt1
BuildArch: noarch

%if_enabled java
%package java-gateway
Summary: %plain_name java gateway
Group: Monitoring
Requires: %name-common >= 1:2.0.4-alt1
Requires: jre-openjdk >= 1.7.0
Conflicts: %plain_name-java <= 1:4.0.6-alt1
BuildArch: noarch
%filter_from_requires /^\/etc\/sysconfig\/network/d
%filter_from_requires /^\/etc\/sysconfig\/zabbix-java-gateway/d
%endif

%package phpfrontend-engine
Summary: %plain_name web frontend (php)
Group: Monitoring
Requires: php-engine
Obsoletes: %name-phpfrontend < 1:1.1.7-alt1
Conflicts: %plain_name-phpfrontend-engine <= 1:4.0.6-alt1
BuildArch: noarch

%package phpfrontend-php7
Summary: %plain_name web frontend, edition for php7
Group: Monitoring
Requires: php7-gd2 php7-mysqli php7-pgsql php7-sockets php7-mbstring php7-dom
Conflicts: %plain_name-phpfrontend-php5 <= 1:4.0.5-alt2
Conflicts: %plain_name-phpfrontend-php7 <= 1:4.0.6-alt1
BuildArch: noarch

%package phpfrontend-apache2
Summary: %plain_name-phpfrontend's apache2 config files
Group: Monitoring
Requires: %name-phpfrontend-engine = %epoch:%version-%release, apache2-base
Conflicts: %plain_name-phpfrontend-apache2 <= 1:4.0.6-alt1
BuildArch: noarch

%package phpfrontend-apache2-mod_php7
Summary: Requirements for the use of apache2-mod_php7
Group: Monitoring
Requires: %name-phpfrontend-apache2
Requires: apache2-httpd-prefork-like
Requires: apache2-mod_php7
Conflicts: %plain_name-phpfrontend-apache2-mod_php5 <= 1:4.0.5-alt2
Conflicts: %plain_name-phpfrontend-apache2-mod_php7 <= 1:4.0.6-alt1
BuildArch: noarch

%package doc
Summary: %plain_name network monitor documentation (README, ChangeLog, Manual)
Group: Monitoring
Conflicts: %plain_name-doc <= 1:4.0.6-alt1
BuildArch: noarch

%package contrib
Summary: %plain_name network monitor (additional scripts)
Group: Monitoring
Conflicts: %plain_name-contrib <= 1:4.0.6-alt1
BuildArch: noarch

%package source
Summary: %plain_name network monitor (files for zabbix modules)
Group: Development/C
Conflicts: %plain_name-source <= 1:4.0.6-alt1
BuildArch: noarch

%description
ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%description common
Common files and docs for zabbix network monitor

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%description common-database-sqlite3
common stuff for zabbix sqlite3 databases.

%description common-database-mysql
common stuff for zabbix mysql databases.

%if_with pgsql
%description common-database-pgsql
common stuff for zabbix postgresql databases.
%endif

%description server-common
common stuff for zabbix server

%description server-mysql
zabbix server, compiled with MySQL support

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%if_with pgsql
%description server-pgsql
zabbix server, compiled with PostgreSQL support
%endif

%description proxy
zabbix network monitor proxy daemon.

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%if_with pgsql
%description proxy-pgsql
zabbix network monitor proxy daemon with PostgreSQL support.

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.
%endif

%description proxy-common
zabbix network monitor proxy daemon.

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%if_enabled java
%description java-gateway
Zabbix java gateway
%endif

%description agent
zabbix network monitor agent.

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%description agent-sudo
Sudo entry for zabbix agent.

%description phpfrontend-apache2
zabbix's apache2 config files

%description phpfrontend-apache2-mod_php7
Contains requirements for the use of apache2-mod_php7
in to zabbix phpfrontend

%description phpfrontend-engine
a php frontend for zabbix - core

%description phpfrontend-php7
zabbix web frontend, edition for php7

%description doc
%plain_name network monitor (README, ChangeLog)

%description contrib
%plain_name network monitor (additional scripts)

%description source
%plain_name network monitor (files for zabbix modules)

%prep
%setup
%patch0 -p1

%build
# fix ZABBIX_REVISION
sed -i -e "s,{ZABBIX_REVISION},%svnrev," include/version.h src/zabbix_java/src/com/zabbix/gateway/GeneralInformation.java

%autoreconf

# we must call this for produce dbsync.h
#pushd create/schema
#./gen.pl c >../../include/dbsync.h
#popd

%configure --with-mysql \
	--with-net-snmp \
	--enable-server \
	%{subst_enable ipv6} \
	--with-ldap \
	--with-libcurl \
	--with-libxml2 \
	--with-jabber \
	--with-openipmi \
	--with-openssl \
	%{subst_with ssh2} \
	%{subst_with unixodbc} \
	--with-libpcre-include=/usr/include/pcre \
	--sysconfdir=/etc/zabbix
%make dbschema
%make

mv src/%{plain_name}_server/%{plain_name}_server src/%{plain_name}_server/%{plain_name}_mysql
%make clean

%if_with pgsql
%configure --with-postgresql \
	--with-net-snmp \
	--enable-server \
	%{subst_enable ipv6} \
	--with-ldap \
	--with-libcurl \
	--with-libxml2 \
	--with-jabber \
	--with-openipmi \
	--with-openssl \
	%{subst_with ssh2} \
	%{subst_with unixodbc} \
	--with-libpcre-include=/usr/include/pcre \
	--sysconfdir=/etc/zabbix
%make dbschema
%make

mv src/%{plain_name}_server/%{plain_name}_server src/%{plain_name}_server/%{plain_name}_pgsql
%make clean

%configure --with-postgresql \
	--enable-proxy \
	%{subst_enable ipv6} \
	--enable-agent \
	%{subst_enable java} \
	--with-libcurl \
	--with-libxml2 \
	--with-net-snmp \
	--with-ldap \
	--with-jabber \
	--with-openipmi \
	--with-openssl \
	%{subst_with ssh2} \
	%{subst_with unixodbc} \
	--with-libpcre-include=/usr/include/pcre \
	--sysconfdir=/etc/zabbix
%make

mv src/%{plain_name}_proxy/%{plain_name}_proxy src/%{plain_name}_proxy/%{plain_name}_proxy_pgsql
%make clean
%endif

%configure --with-sqlite3 \
	--enable-proxy \
	%{subst_enable ipv6} \
	--enable-agent \
	%{subst_enable java} \
	--with-libcurl \
	--with-libxml2 \
	--with-net-snmp \
	--with-ldap \
	--with-jabber \
	--with-openipmi \
	--with-openssl \
	%{subst_with ssh2} \
	%{subst_with unixodbc} \
	--with-libpcre-include=/usr/include/pcre \
	--sysconfdir=/etc/zabbix
%make

# adjust in several files /home/zabbix
find conf -type f -print0 | xargs -0 sed -i \
	-e "s,/home/zabbix/bin,/usr/sbin,g" \
	-e "s,PidFile=/tmp,PidFile=%_var/run/zabbix,g" \
	-e "s,LogFile=/tmp,LogFile=%_logdir/zabbix,g" \
	-e "s,/home/zabbix/lock,%_var/lock/subsys/zabbix,g" \
	-e "s,/tmp/mysql.sock,%_localstatedir/mysql/mysql.sock,g" \
	-e "s,Include=/usr/local/etc/zabbix_agentd.conf.d/,Include=%_sysconfdir/%plain_name/zabbix_agentd.conf.d/,g" --

%install
# Generate *.mo files
# TODO 'Remove | grep -v "/locale/fr/"' when fix FR locale
for pofile in `find frontends/php/locale -type f ! -wholename '*/.svn*' -name '*.po' | grep -v "/locale/fr/"`
do
    msgfmt --use-fuzzy -c -o ${pofile%%po}mo $pofile
done

%makeinstall

# create directory structure
install -dm1775 %buildroot%_logdir/%plain_name
install -dm0755 %buildroot%_sbindir
install -dm0750 %buildroot%_sysconfdir/%plain_name
install -dm0750 %buildroot%_sysconfdir/%plain_name/zabbix_agentd.conf.d
install -dm0755 %buildroot%webserver_webappsdir/%plain_name
install -dm0755 %buildroot%_unitdir
install -dm0755 %buildroot%_includedir/%plain_name

# binaries
install -m0755 src/%{plain_name}_*/%{plain_name}_{mysql,agentd} %buildroot%_sbindir
%if_with pgsql
install -m0755 src/%{plain_name}_server/%{plain_name}_pgsql %buildroot%_sbindir
install -m0755 src/%{plain_name}_proxy/%{plain_name}_proxy_pgsql %buildroot%_sbindir
%endif

# conf files
install -m0640 conf/%{plain_name}_{server,agentd,proxy}.conf %buildroot%_sysconfdir/%plain_name
#install -m0640 misc/conf/%{plain_name}_agentd/userparameter_{examples,mysql}.conf %buildroot%_sysconfdir/%plain_name
install -Dpm 644 sources/%plain_name-tmpfiles.conf %buildroot/lib/tmpfiles.d/%plain_name.conf

# frontends
mv frontends/php/locale/*.sh .
cp -r frontends %buildroot%webserver_webappsdir/%plain_name/

# apache2 config
install -pDm0644 sources/%plain_name.conf %buildroot%_sysconfdir/httpd2/conf/addon.d/A.%plain_name.conf

# start scripts
install -pDm0755 sources/%{plain_name}_agentd.init %buildroot%_initdir/%{plain_name}_agentd
install -pDm0644 sources/%{plain_name}_agentd.service %buildroot%_unitdir/%{plain_name}_agentd.service
install -pDm0644 sources/zabbix_server %buildroot%_sysconfdir/sysconfig/zabbix_server
%if_with pgsql
install -pDm0755 sources/%{plain_name}_pgsql.init %buildroot%_initdir/%{plain_name}_pgsql
install -pDm0644 sources/%{plain_name}_pgsql.service %buildroot%_unitdir/%{plain_name}_pgsql.service
install -pDm0755 sources/%{plain_name}_proxy_pgsql.init %buildroot%_initdir/%{plain_name}_proxy_pgsql
install -pDm0644 sources/%{plain_name}_proxy_pgsql.service %buildroot%_unitdir/%{plain_name}_proxy_pgsql.service
%endif
install -pDm0755 sources/%{plain_name}_mysql.init %buildroot%_initdir/%{plain_name}_mysql
install -pDm0644 sources/%{plain_name}_mysql.service %buildroot%_unitdir/%{plain_name}_mysql.service
install -pDm0755 sources/%{plain_name}_proxy.init %buildroot%_initdir/%{plain_name}_proxy
install -pDm0644 sources/%{plain_name}_proxy.service %buildroot%_unitdir/%{plain_name}_proxy.service
%if_enabled java
install -pDm0755 sources/%{plain_name}_java_gateway.init %buildroot%_initdir/%{plain_name}_java_gateway
install -pDm0644 sources/%{plain_name}_java_gateway.service %buildroot%_unitdir/%{plain_name}_java_gateway.service
%endif

# sudo entry
install -pDm0400 sources/%plain_name.sudo %buildroot%_sysconfdir/sudoers.d/%plain_name

# include files
cp include/* %buildroot%_includedir/%plain_name

%if_enabled java
# delete unnecessary files from java gateway
rm %buildroot%_sbindir/zabbix_java/settings.sh
rm %buildroot%_sbindir/zabbix_java/startup.sh
rm %buildroot%_sbindir/zabbix_java/shutdown.sh

mv %buildroot%_sbindir/zabbix_java/lib/logback.xml %buildroot%_sysconfdir/zabbix/zabbix_java_gateway_logback.xml
rm %buildroot%_sbindir/zabbix_java/lib/logback-console.xml

mkdir -p %buildroot%_javadir
mv %buildroot%_sbindir/zabbix_java %buildroot%_javadir/zabbix-java-gateway
install -m 0755 -p sources/zabbix_java_gateway-sysd %buildroot%_sbindir/zabbix_java_gateway

cat src/zabbix_java/settings.sh | sed \
        -e 's|^PID_FILE=.*|PID_FILE="/var/run/zabbix/zabbix_java.pid"|g' \
        -e '/^# TIMEOUT=/a \\nTIMEOUT=3' \
        > %buildroot%_sysconfdir/zabbix/zabbix_java_gateway.conf
%endif

# ChangeLog
bzip2 ChangeLog

%pre common
/usr/sbin/groupadd -r -f %zabbix_group ||:
/usr/sbin/useradd -g %zabbix_group -G proc -c 'Zabbix' \
	-d %zabbix_home -s /dev/null -r %zabbix_user >/dev/null 2>&1 ||:

%post server-mysql
%post_service zabbix_mysql

%preun server-mysql
%preun_service zabbix_mysql
%if_with pgsql
%post server-pgsql
%post_service zabbix_pgsql

%preun server-pgsql
%preun_service zabbix_pgsql
%endif

%post phpfrontend-apache2
%post_apache2_rpma2chkconfigfile

%postun phpfrontend-apache2
%post_apache2_rpma2chkconfigfile

%post proxy
%post_service zabbix_proxy

%preun proxy
%preun_service zabbix_proxy

%if_with pgsql
%post proxy-pgsql
%post_service zabbix_proxy_pgsql

%preun proxy-pgsql
%preun_service zabbix_proxy_pgsql
%endif

%if_enabled java
%post java-gateway
%post_service zabbix_java_gateway

%preun java-gateway
%preun_service zabbix_java_gateway
%endif

%post agent
%post_service zabbix_agentd
if [ $1 -eq 1 ]; then
	sed -i -e "s,Hostname=Zabbix server,Hostname=$HOSTNAME,g" \
	%_sysconfdir/%plain_name/%{plain_name}_agentd.conf
fi

%post agent-sudo
if [ $1 -eq 1 ]; then
	gpasswd -a %zabbix_user wheel
fi

%preun agent
%preun_service zabbix_agentd

%files common
%dir %attr(1775,root,%zabbix_group) %_logdir/%plain_name
%dir %_sysconfdir/%plain_name
/lib/tmpfiles.d/*

%files common-database-sqlite3
%doc database/sqlite3/schema.sql database/sqlite3/data.sql database/sqlite3/images.sql

%files common-database-mysql
%doc database/mysql/schema.sql database/mysql/data.sql database/mysql/images.sql

%if_with pgsql
%files common-database-pgsql
%doc database/postgresql/schema.sql database/postgresql/data.sql database/postgresql/images.sql
%endif

%files server-common
%_bindir/%{plain_name}_get
%config(noreplace) %_sysconfdir/sysconfig/zabbix_server
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%plain_name/%{plain_name}_server.conf
%_man1dir/%{plain_name}_get.*

%files server-mysql
%_sbindir/%{plain_name}_mysql
%_initdir/%{plain_name}_mysql
%_unitdir/*mysql*

%if_with pgsql
%files server-pgsql
%_sbindir/%{plain_name}_pgsql
%_initdir/%{plain_name}_pgsql
%_unitdir/*pgsql*
%exclude %_unitdir/*proxy_pgsql*
%endif

%files proxy-common
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%plain_name/%{plain_name}_proxy.conf
%_man8dir/%{plain_name}_proxy.*

%files proxy
%_sbindir/%{plain_name}_proxy
%_initdir/%{plain_name}_proxy
%_unitdir/*proxy*
%if_with pgsql
%exclude %_unitdir/*proxy_pgsql*
%endif

%if_with pgsql
%files proxy-pgsql
%_sbindir/%{plain_name}_proxy_pgsql
%_initdir/%{plain_name}_proxy_pgsql
%_unitdir/*proxy_pgsql*
%endif

%if_enabled java
%files java-gateway
%_sbindir/%{plain_name}_java_gateway
%_initdir/%{plain_name}_java_gateway
%_unitdir/*java_gateway*
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%plain_name/%{plain_name}_java_gateway.conf
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%plain_name/%{plain_name}_java_gateway_logback.xml
%_javadir/*
%endif

%files agent
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%plain_name/%{plain_name}_agentd.conf
%dir %attr(0750,root,%zabbix_group) %_sysconfdir/%plain_name/zabbix_agentd.conf.d
%_initdir/%{plain_name}_agentd
%_unitdir/*agent*
%_sbindir/%{plain_name}_agentd
%_bindir/%{plain_name}_sender
%_man8dir/%{plain_name}_agentd.*
%_man1dir/%{plain_name}_sender.*

%files agent-sudo
%config(noreplace) %attr(0400,root,root) %_sysconfdir/sudoers.d/%plain_name

%files phpfrontend-engine
%webserver_webappsdir/%plain_name
%doc add_new_language.sh make_mo.sh update_po.sh

%files phpfrontend-php7

%files phpfrontend-apache2
%config(noreplace) %_sysconfdir/httpd2/conf/addon.d/A.%plain_name.conf

%files phpfrontend-apache2-mod_php7

%files doc
%doc AUTHORS NEWS README INSTALL ChangeLog.bz2

%files contrib
%doc misc/snmptrap/*

%files source
%_includedir/%plain_name

%changelog
