Name: zlib
Version: 1.2.8
Release: alt1

Summary: The zlib compression and decompression library
Summary(ru_RU.UTF-8): Библиотека сжатия данных zlib
License: zlib
Group: System/Libraries
Url: http://zlib.net/
# http://git.altlinux.org/gears/z/zlib.git
Source: %name-%version-%release.tar

# http://git.gnome.org/browse/libxml2/commit/?id=a7e79f28689c574e0bbef17f4cb3da00249181ff
Conflicts: libxml2 < 1:2.7.7

%def_disable asm

%package devel
Summary: Header files for developing apps which will use zlib
Summary(ru_RU.UTF-8): Файлы, необходимые для разработки приложений с использованием библиотеки сжатия данных zlib
Group: Development/C
Requires: %name = %version-%release
Requires: glibc-devel

%package devel-static
Summary: Static library for developing apps which will use zlib
Summary(ru_RU.UTF-8): Файлы, необходимые для разработки статических приложений с использованием библиотеки сжатия данных zlib
Group: Development/C
Requires: %name-devel = %version-%release

%package -n libminizip
Summary: Minizip zip file manipulation library
Group: System/Libraries
Requires: %name = %version-%release

%package -n libminizip-devel
Summary: Development files for the minizip librar
Group: Development/C
Requires: libminizip = %version-%release
Requires: %name-devel = %version-%release

%description
The zlib compression library provides in-memory compression and
decompression functions, including integrity checks of the uncompressed
data.  This version of the library supports only one compression method
(deflation), but other algorithms may be added later, which will have
the same stream interface.  The zlib library is used by many different
system programs.

%description devel
This package contains the development files needed to develop programs
that use the zlib compression and decompression library.

%description devel-static
This package contains the static library needed to develop statically
linked programs that use the zlib compression and decompression library.

%description -n libminizip
This package contains minizip zip file manipulation shared library.

%description -n libminizip-devel
This package contains the development files needed to develop programs
that use the minizip zip file manipulation library.

%prep
%setup -n %name-%version-%release

fgrep -B999 @ zlib.h >License
xz -9k FAQ doc/algorithm.txt
iconv -fcp1252 -tutf8 < ChangeLog | xz -9 > ChangeLog.xz

%build
%define _optlevel 3

%if_enabled asm
	%add_optflags -Wa,--noexecstack -DASMV
%ifarch i686 pentium3 pentium4 athlon
	cp -p contrib/asm686/match.S .
%endif # i686 pentium3 pentium4 athlon
%ifarch x86_64
	cp -p contrib/amd64/amd64-match.S .
%endif # x86_64
%endif # enabled asm

%ifarch %ix86
%{!?_enable_debug:%add_optflags -momit-leaf-frame-pointer}
%endif # %ix86

CFLAGS="%optflags" ./configure --prefix=%prefix --libdir=%_libdir
%make_build %{?_enable_asm:OBJA=match.o PIC_OBJA=match.lo}

pushd contrib/minizip
mkdir m4
%autoreconf
%configure --disable-static
%make_build
popd

%install
%makeinstall_std LDCONFIG=:
%makeinstall_std -C contrib/minizip

# Relocate shared library from %_libdir/ to /%_lib/
mkdir %buildroot/%_lib
for f in %buildroot%_libdir/libz.so; do
	t=$(readlink "$f")
	ln -sf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/libz.so.* %buildroot/%_lib/

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -pm644 License README {FAQ,ChangeLog,doc/algorithm.txt}.xz \
	test/example.c test/minigzip.c %buildroot%docdir/
cp -a examples %buildroot%docdir/

%check
make test

%files
/%_lib/libz.so.*
%dir %docdir
%docdir/License
%docdir/README

%files devel
%_libdir/libz.so
%_includedir/z*
%_pkgconfigdir/zlib.pc
%_mandir/man?/*
%docdir
%exclude %docdir/License
%exclude %docdir/README

%files devel-static
%_libdir/libz.a

%files -n libminizip
%_libdir/libminizip.so.*

%files -n libminizip-devel
%_libdir/libminizip.so
%_includedir/minizip/
%_pkgconfigdir/minizip.pc

%changelog
