%define binname zyGrib
%def_without system_qwt

Name: zygrib
Version: 8.0.1
Release: alt1

Summary: Visualisation of meteo data from files in GRIB formats

License: %gpl3plus
Group: Networking/Other
Url: http://www.zygrib.org
Source0: %binname-%version.tgz
Source1: %binname.png
Source2: %binname.desktop

Requires: fonts-ttf-liberation
Requires: %name-data = %{version}-%{release}

BuildRequires: qt5-base-devel bzlib-devel libjasper-devel libnova-devel libpng-devel libproj-devel

%if_with system_qwt
BuildRequires: libqwt6-qt5-devel
%endif

BuildRequires: rpm-build-licenses

%description
Visualization of meteo data from files in GRIB formats v1 and v2.
GRIB data are used to display weather data in detailed format for
a certain area of sea or land. ZYGrib is a QT5 program to display
and use GRIB data on Linux.

%package data
Summary: Architecture independent files for ZYGrib.
Group: Networking/Other
BuildArch: noarch

%description data
Architecture independent files for ZYGrib.

Included low resolution maps for ZYGrib (25 km, 5 km and 1 km)
and cities with population from 3000 to 10000 and more 10000.

data/gis/* have another license: %ccby30
home page: http://www.geonames.org/

%prep

%setup -q -n %binname-%version

# remove system-wide fonts
rm -rf data/fonts

%if_with system_qwt
#perl -p -e 's|cd src/qwt-6.0.1/src|# cd src/qwt-6.0.1/src|g;' -i $RPM_BUILD_DIR/%binname-%version/Makefile
sed 's|cd ..QWTDIR./src|# cd \$(QWTDIR)/src|' -i Makefile
%endif

%if "%(getconf LONG_BIT)" == "32"
sed -i "s|^CFLAGS= -O3 -g -m64 .*$|CFLAGS= -O3 -g \$(INC) \$(DEFS)|" src/g2clib/makefile
%endif

sed -i "s|QMAKE=/usr/bin/qmake|QMAKE=%_qt5_qmake|" Makefile

%build
%make QTBIN=%_qt5_bindir

%install

make -e INSTALLDIR=%{buildroot}%{_libdir}/%{binname} install
echo -e "#!/bin/sh\ncd %{_libdir}/%{binname}\nbin/%{binname} \"\$@\"" >%{buildroot}%{_libdir}/%{binname}/%{binname}
mkdir -p -m 755 %{buildroot}%{_bindir}
ln -sf %{_libdir}/%{binname}/%{binname} %{buildroot}%{_bindir}/%{binname}
mkdir -p -m 755 %{buildroot}%{_datadir}/pixmaps
install -m 644 %{SOURCE1} %{buildroot}%{_datadir}/pixmaps
mkdir -p -m 755 %{buildroot}%{_datadir}/applications
install -m 644 %{SOURCE2} %{buildroot}%{_datadir}/applications

mkdir -p -m 755 %{buildroot}%{_datadir}/%{binname}
mv %{buildroot}%{_libdir}/%{binname}/data %{buildroot}%{_datadir}/%{binname}/
cd %{buildroot}%{_libdir}/%{binname}
ln -s %{_datadir}/%{binname}/data data

%post
# if "data" missed then this first installation
if ! [ -d %_libdir/%binname/data ] ; then
    cd %{_libdir}/%{binname}
    ln -s %{_datadir}/%{binname}/data data
fi

%triggerpostun -- zygrib < 5.0.6-alt2
# %_libdir/%binname/data must be symlink since 5.0.6-alt2
if [ -d %_libdir/%binname/data ] ; then
    if ! [ -L %_libdir/%binname/data ] ; then
	rm -rf %_libdir/%binname/data
	cd %{_libdir}/%{binname}
	ln -s %{_datadir}/%{binname}/data data
    fi
fi

%files
%dir %_libdir/%binname
%_libdir/%binname/bin
%_libdir/%binname/grib
%ghost %_libdir/%binname/data
%_libdir/%binname/%binname
%_bindir/%binname
%_datadir/pixmaps/%binname.png
%_datadir/applications/%binname.desktop

%files data
%dir %_datadir/%binname
%_datadir/%binname

%changelog
