%define _unpackaged_files_terminate_build 1

%define pkgname	dirsrv
%define groupname %pkgname.target
%define _libexecdir %_usr/libexec

%def_without selinux
%def_with check
%def_without perl
%def_without debug
%def_with cockpit

Name: 389-ds-base
Version: 1.4.1.18
Release: alt5.p9.1

Summary: 389 Directory Server (base)
License: GPLv3+
Group: System/Servers
# Source-git: https://pagure.io/389-ds-base.git
Url: http://port389.org
Packager: Andrey Cherepanov <cas@altlinux.org>

Source0: %name-%version.tar
%if_with cockpit
Source1: node_modules.tar.gz
%endif
Patch: %name-%version-alt.patch

ExcludeArch: %ix86
BuildRequires(pre): rpm-build-python3

BuildRequires: cracklib-devel
BuildRequires: doxygen
BuildRequires: gcc-c++
%if_with debug
BuildRequires: libasan5
%endif
BuildRequires: libdb5.3-devel
BuildRequires: libevent-devel
BuildRequires: libicu-devel
BuildRequires: libkrb5-devel
BuildRequires: libldap-devel
BuildRequires: libnet-snmp-devel
BuildRequires: libnspr-devel
BuildRequires: libnss-devel
BuildRequires: libpam0-devel
BuildRequires: libpcre-devel
BuildRequires: libsasl2-devel
BuildRequires: libsystemd-devel

BuildRequires: python3(build_manpages)
BuildRequires: python3(argcomplete)
BuildRequires: python3(ldap)
BuildRequires: python3(packaging)
BuildRequires: python3(six)

BuildRequires: rsync

%if_with cockpit
BuildRequires: npm
%endif

%if_with check
BuildRequires: /proc
BuildRequires: libcmocka-devel
%endif

%if_with perl
BuildRequires: perl-bignum
BuildRequires: perl-devel
BuildRequires: perl-Archive-Tar
BuildRequires: perl-DBM
BuildRequires: perl-Mozilla-LDAP
BuildRequires: perl-NetAddr-IP
%endif
# AutoReq: yes, noperl
%add_perl_lib_path %_libdir/%pkgname/perl
%add_findprov_skiplist %_datadir/%pkgname/script-templates/*
%add_findreq_skiplist %_datadir/%pkgname/script-templates/* %_sbindir/*-%pkgname

%if_without perl
%add_findprov_skiplist %_bindir/logconv.pl
%add_findreq_skiplist %_bindir/logconv.pl
%endif

# use Python3 everywhere
%add_python3_path %_datadir/gdb/auto-load/
%add_python3_compile_exclude %_datadir/gdb/auto-load/

%add_python3_path %_libdir/%pkgname/python/
%add_python3_compile_exclude %_libdir/%pkgname/python/

# we don't want python gdb
%filter_from_requires /python3(gdb\(\..*\)\?)/d
# requires self
%add_python3_req_skip __main__

Requires: libjemalloc2
Requires: cracklib-words

%description
389 Directory Server is an LDAPv3 compliant server. The base package includes
the LDAP server and command line utilities for server administration.

%package libs
Summary: Core libraries for 389 Directory Server
Group: System/Libraries
# svrcore has been merged into 389-ds
# https://pagure.io/389-ds-base/issue/49369
Provides: libsvrcore = 4.1.4
Obsoletes: libsvrcore <= 4.1.3
Conflicts: libsvrcore

%description libs
Core libraries for the 389 Directory Server base package. These libraries are
used by the main package and the -devel package. This allows the -devel package
to be installed with just the -libs package and without the main package.

%package devel
Summary: Development libraries for 389 Directory Server
Group: Development/C
Requires: %name = %EVR
# svrcore has been merged into 389-ds
# https://pagure.io/389-ds-base/issue/49369
Provides: libsvrcore-devel = 4.1.4
Obsoletes: libsvrcore-devel <= 4.1.3
Conflicts: libsvrcore-devel

%description devel
Development Libraries and headers for 389 Directory Server.

%package legacy-tools
Summary: Legacy utilities for 389 Directory Server
Group: System/Base
Obsoletes: %name <= 1.4.0.9
Requires: %name = %EVR

%description legacy-tools
Legacy (and deprecated) utilities for 389 Directory Server. This includes
the old account management and task scripts. These are deprecated in favour of
the dscreate, dsctl, dsconf and dsidm tools.

%package -n python3-module-lib389
Summary: A library for accessing, testing, and configuring the 389 Directory Server
BuildArch: noarch
Group: Development/Python3
Requires: nss-utils

%description -n python3-module-lib389
This module contains tools and libraries for accessing, testing, and
configuring the 389 Directory Server.

%if_with cockpit
%package -n cockpit-389-ds
Summary: Cockpit UI Plugin for configuring and administering the 389 Directory Server
BuildArch: noarch
Group: System/Base

Requires: cockpit-bridge
Requires: cockpit-dashboard
Requires: cockpit-shell
Requires: cockpit-systemd
Requires: cockpit-ws
%py3_requires lib389

Obsoletes: 389-console
Obsoletes: 389-adminutil
Obsoletes: 389-ds-console
Obsoletes: 389-dsgw

%description -n cockpit-389-ds
A cockpit UI Plugin for configuring and administering the 389 Directory Server
%endif

%prep
%setup
%patch -p1

%if_with cockpit
# node modules are intended for building Cockpit plugin
# and are not utilized in runtime
tar -xzf %SOURCE1 -C "./src/cockpit/389-console"
%endif

grep -qsF 'sysctldir = @prefixdir@/lib/sysctl.d' Makefile.am || exit 1
sed -i 's|sysctldir = .*|sysctldir = %_sysctldir|' Makefile.am

grep -qsr 'LD_PRELOAD=.*/libjemalloc.so.2' || exit 1
grep -rl 'LD_PRELOAD=.*/libjemalloc.so.2' | \
xargs sed -i 's|LD_PRELOAD=.*/libjemalloc.so.2|LD_PRELOAD=libjemalloc.so.2|g'

grep -qsr '/sasl2\( \|"\)' || exit 1
grep -rl '/sasl2\( \|"\)' | xargs sed -i 's/\/sasl2\( \|"\)/\/sasl2-3\1/g'

grep -qsr '/usr/bin/\(ls\|echo\)' || exit 1
grep -rl '/usr/bin/\(ls\|echo\)' | \
xargs sed -i 's/\/usr\(\/bin\/\(ls\|echo\)\)/\1/g'

grep -qs 'saslpath = "/usr/lib/aarch64-linux-gnu"' \
ldap/servers/slapd/ldaputil.c || exit 1
sed -i 's|\(saslpath = "/usr/\)lib\(/aarch64-linux-gnu"\)|\1lib64\2|g' \
ldap/servers/slapd/ldaputil.c

%build
%ifarch mipsel
export LDFLAGS='-latomic'
%endif
%ifarch %e2k
# 1.4.1.8: asm crc32
%add_optflags -U__SSE4_2__
%endif

%autoreconf

%configure  \
	--with-openldap \
        %{subst_with selinux} \
	--localstatedir=/var \
        --libexecdir=%_libexecdir/%pkgname \
 	--enable-autobind \
	--with-systemd \
	--with-systemdsystemunitdir=%_unitdir \
	--with-systemdsystemconfdir=%_sysconfdir/systemd/system \
	--with-systemdgroupname=%groupname \
        --with-tmpfiles-d=%_sysconfdir/tmpfiles.d \
%if_with debug
        --enable-asan \
        --enable-debug \
%endif
        %{?_with_perl:--enable-perl } \
        %{?_with_check:--enable-cmocka } \
        %nil

%make_build

%if_with cockpit
# cockpit plugin
SKIP_AUDIT_CI=yes %make 389-console
%endif

# Python3 bindings
pushd ./src/lib389
%python3_build
popd

# argparse-manpage dynamic man pages have hardcoded man v1 in header,
# need to change it to v8
sed -i  "1s/\"1\"/\"8\"/" ./src/lib389/man/ds{conf,ctl,idm,create}.8

%check
%make check || { cat test-suite.log; exit 1; }

%install
%makeinstall_std

# python stuff
pushd src/lib389
%python3_install
popd

# do not package lib389's tests
rm -r %buildroot%python3_sitelibdir_noarch/lib389/tests
rm %buildroot%python3_sitelibdir_noarch/lib389/topologies.py

mkdir -p %buildroot/{%_lockdir,%_localstatedir,%_logdir}/%pkgname

# for systemd
mkdir -p %buildroot%_sysconfdir/systemd/system/%groupname.wants

# remove libtool and static libs
find %buildroot -type f \( -name "*.la" -o -name "*.a" \) -delete

%if_with perl
# make sure perl scripts have a proper shebang
sed -i 's|#{{PERL-EXEC}}|#!%_bindir/perl|' %buildroot%_datadir/%pkgname/script-templates/template-*.pl
sed -i 's|File::Spec->tmpdir|"/tmp"|g' %buildroot%_libdir/%pkgname/perl/DSCreate.pm
%endif

# move main libraries to common directory
mv %buildroot%_libdir/%pkgname/*.so* %buildroot%_libdir/

# Copy in our docs from doxygen
mkdir -p %buildroot%_man3dir
cp man/man3/* %buildroot%_man3dir

# Fix path to systemctl in scripts
%if_with perl
sed -i 's|%_bindir/systemctl|/bin/systemctl|' %buildroot%_sbindir/*-dirsrv
%endif

%if_without cockpit
# ends up unpackaged otherwise thus breaking build
rm -f %buildroot%_datadir/metainfo/389-console/org.port389.cockpit_console.metainfo.xml
%endif

%if_without perl
# repl-monitor depends on repl-monitor.pl which is not installed without perl
rm -f %buildroot%_bindir/repl-monitor
%endif

%pre
%define _dirsrv_user dirsrv
%define _dirsrv_group dirsrv
%define _dirsrv_home %_localstatedir/dirsrv
/usr/sbin/groupadd -r -f %_dirsrv_group ||:
/usr/sbin/useradd -g %_dirsrv_group -c 'user for 389-ds-base' \
		  -d %_dirsrv_home -s /sbin/nologin -r %_dirsrv_user \
		  > /dev/null 2>&1 ||:

%post
sysctl --system &> /dev/null ||:

%post legacy-tools
%if_with perl
# Upgrade
echo "389-ds: Checking for upgrade"
if ! ( sd_booted && /bin/systemctl --version >/dev/null 2>&1 ); then
    echo "Likely, you are not using systemd. Please, stop all the dirsrv instances."
    echo "Then run an upgrade by %_sbindir/setup-ds.pl -u -s General.UpdateMode=offline"
    exit 0
fi

/bin/systemctl daemon-reload >/dev/null 2>&1 ||:
instances=""
num_inst=0
echo "Looking for Instances in %_sysconfdir/%pkgname"
for dir in %_sysconfdir/%pkgname/slapd-* ; do
    if [ ! -d "$dir" ] ; then continue ; fi
    case "$dir" in *.removed) continue ;; esac
    inst="%pkgname@$(echo $(basename $dir) | sed -e 's/slapd-//')"
    echo "Found Instance $inst"
    if /bin/systemctl -q is-active "$inst"; then
        echo "Instance $inst is running, stopping it"
        if ! /bin/systemctl stop "$inst"; then
            echo "Cannot stop Instance. Please check it and run an upgrade by %_sbindir/setup-ds.pl -u -s General.UpdateMode=offline"
            exit 0
        fi
        instances="$instances $inst"
    else
        echo "Instance $inst is not running"
    fi
    let "num_inst++"
done
if [ "$num_inst" -eq 0 ]; then
    echo "389-ds: There are no Instances to upgrade"
    exit 0
fi
echo "389-ds: Upgrading Instances"
if ! %_sbindir/setup-ds.pl -u -d -l %_logdir/%pkgname/upgrade.log -s \
General.UpdateMode=offline >%_logdir/%pkgname/upgrade.log 2>&1; then
    echo "Upgrade has not been completed successfully. Please check log file %_logdir/%pkgname/upgrade.log and run an upgrade by %_sbindir/setup-ds.pl -u -s General.UpdateMode=offline"
    exit 0
fi

for inst in $instances; do
    echo "Restarting Instance $inst"
    /bin/systemctl start "$inst" ||:
done

echo "389-ds: Upgrade has been completed successfully"
%endif
%post_service %pkgname-snmp

%preun
# Removal
if [ $1 -eq 0 ]; then
    # disabling all templated units
    /bin/systemctl -q disable %pkgname@
    # remove templated units
    rm -rf %_sysconfdir/systemd/system/%groupname.wants/* >/dev/null 2>&1 ||:
    # stopping by mask
    /bin/systemctl stop %pkgname@*.service
fi
%preun_service %pkgname-snmp

%files
%doc LICENSE LICENSE.GPLv3+ LICENSE.openssl README.md
%dir %_sysconfdir/%pkgname
%dir %_sysconfdir/%pkgname/schema
%config(noreplace)%_sysconfdir/%pkgname/schema/*.ldif
%dir %_sysconfdir/%pkgname/config
%dir %_sysconfdir/systemd/system/%groupname.wants
%config(noreplace)%_sysconfdir/%pkgname/config/slapd-collations.conf
%config(noreplace)%_sysconfdir/%pkgname/config/certmap.conf
%config(noreplace)%_sysconfdir/%pkgname/config/ldap-agent.conf
%dir %_datadir/%pkgname
%_datadir/%pkgname/data/
%_datadir/%pkgname/inf/
%_datadir/%pkgname/mibs/
%_datadir/%pkgname/schema/
%_unitdir/dirsrv-snmp.service
%_unitdir/dirsrv.target
%_unitdir/dirsrv@.service
%dir %_unitdir/dirsrv@.service.d
%_unitdir/dirsrv@.service.d/custom.conf

%_bindir/dbscan
%_bindir/ds-replcheck
%_bindir/ds-logpipe.py
%_bindir/ldclt
%_bindir/logconv.pl
%_bindir/pwdhash
%_bindir/readnsstate

%_sbindir/ldap-agent
%_sbindir/ns-slapd

%if_with perl
%_sbindir/bak2db
%_sbindir/db2bak
%_sbindir/db2index
%_sbindir/db2ldif
%_sbindir/dbverify
%_sbindir/ldif2db
%_sbindir/ldif2ldap
%_sbindir/restart-dirsrv
%_sbindir/start-dirsrv
%_sbindir/status-dirsrv
%_sbindir/stop-dirsrv
%_sbindir/upgradedb
%_sbindir/vlvindex
%endif

%dir %_libexecdir/%pkgname
%_libexecdir/%pkgname/ds_systemd_ask_password_acl
%dir %_libdir/%pkgname/python
%_libdir/%pkgname/python/*.py*
%dir %_libdir/%pkgname/plugins
%_libdir/%pkgname/plugins/*.so
%_datadir/gdb/auto-load/*
%_sysctldir/70-dirsrv.conf
%dir %_localstatedir/%pkgname
%dir %_logdir/%pkgname
%ghost %dir %_lockdir/%pkgname
%_man1dir/dbscan.1.*
%_man1dir/ds-replcheck.1.*
%_man1dir/ds-logpipe.py.1.*
%_man1dir/ldclt.1.*
%_man1dir/logconv.pl.1.*
%_man1dir/pwdhash.1.*
%_man1dir/readnsstate.1.*
%_man1dir/ldap-agent.1.*
%_man8dir/ldif2ldap.8.*
%_man8dir/ns-slapd.8.*
%_man8dir/bak2db.8.*
%_man8dir/db2bak.8.*
%_man8dir/db2index.8.*
%_man8dir/db2ldif.8.*
%_man8dir/dbverify.8.*
%_man8dir/ldif2db.8.*
%_man8dir/restart-dirsrv.8.*
%_man8dir/start-dirsrv.8.*
%_man8dir/status-dirsrv.8.*
%_man8dir/stop-dirsrv.8.*
%_man8dir/upgradedb.8.*
%_man8dir/vlvindex.8.*
%_man5dir/99user.ldif.5.*
%_man5dir/certmap.conf.5.*
%_man5dir/slapd-collations.conf.5.*
%_man5dir/dirsrv.5.*
%_man5dir/dirsrv.systemd.5.*

%files devel
%_includedir/%pkgname/
%_includedir/svrcore.h
%_libdir/libsvrcore.so
%_libdir/libslapd.so
%_libdir/libns-dshttpd.so
%_libdir/libnunc-stans.so
%_libdir/libsds.so
%_libdir/libldaputil.so
%_pkgconfigdir/dirsrv.pc
%_pkgconfigdir/libsds.pc
%_pkgconfigdir/svrcore.pc
%_pkgconfigdir/nunc-stans.pc
%_man3dir/*.3.*

%files libs
%dir %_libdir/%pkgname
%_libdir/libsvrcore.so.*
%_libdir/libns-dshttpd-*.so
%_libdir/libnunc-stans.so.*
%_libdir/libsds.so.*
%_libdir/libslapd.so.*
%_libdir/libldaputil.so.*

%files legacy-tools
%config(noreplace)%_sysconfdir/%pkgname/config/template-initconfig
%_bindir/infadd
%_bindir/ldif
%_bindir/migratecred
%_bindir/mmldif
%_bindir/rsearch

%if_with perl
%_sbindir/dbmon.sh
%_sbindir/dn2rdn
%_sbindir/monitor
%_sbindir/restoreconfig
%_sbindir/saveconfig
%_sbindir/suffix2instance
%_sbindir/upgradednformat
%endif

%_libexecdir/%pkgname/ds_selinux_enabled
%_libexecdir/%pkgname/ds_selinux_port_query

%_man1dir/cl-dump.1.*
%_man1dir/cl-dump.pl.1.*
%_man1dir/dbgen.pl.1.*
%_man1dir/repl-monitor.1.*
%_man1dir/repl-monitor.pl.1.*
%_man1dir/infadd.1.*
%_man1dir/ldif.1.*
%_man1dir/migratecred.1.*
%_man1dir/mmldif.1.*
%_man1dir/rsearch.1.*
%_man5dir/template-initconfig.5.*
%_man8dir/dbmon.sh.8.*
%_man8dir/dn2rdn.8.*
%_man8dir/monitor.8.*
%_man8dir/restoreconfig.8.*
%_man8dir/saveconfig.8.*
%_man8dir/suffix2instance.8.*
%_man8dir/upgradednformat.8.*
%_man8dir/bak2db.pl.8.*
%_man8dir/cleanallruv.pl.8.*
%_man8dir/db2bak.pl.8.*
%_man8dir/db2index.pl.8.*
%_man8dir/db2ldif.pl.8.*
%_man8dir/fixup-linkedattrs.pl.8.*
%_man8dir/fixup-memberof.pl.8.*
%_man8dir/ldif2db.pl.8.*
%_man8dir/migrate-ds.pl.8.*
%_man8dir/ns-accountstatus.pl.8.*
%_man8dir/ns-activate.pl.8.*
%_man8dir/ns-inactivate.pl.8.*
%_man8dir/ns-newpwpolicy.pl.8.*
%_man8dir/remove-ds.pl.8.*
%_man8dir/schema-reload.pl.8.*
%_man8dir/setup-ds.pl.8.*
%_man8dir/syntax-validate.pl.8.*
%_man8dir/usn-tombstone-cleanup.pl.8.*
%_man8dir/verify-db.pl.8.*

%if_with perl
%dir %_datadir/%pkgname/properties
%_datadir/%pkgname/properties/ns-slapd.properties
%_datadir/%pkgname/properties/*.res
%_datadir/%pkgname/script-templates
%_datadir/%pkgname/updates

%_bindir/cl-dump
%_bindir/cl-dump.pl
%_bindir/dbgen.pl
%_bindir/repl-monitor
%_bindir/repl-monitor.pl

%_sbindir/bak2db.pl
%_sbindir/cleanallruv.pl
%_sbindir/db2bak.pl
%_sbindir/db2index.pl
%_sbindir/db2ldif.pl
%_sbindir/fixup-linkedattrs.pl
%_sbindir/fixup-memberof.pl
%_sbindir/ldif2db.pl
%_sbindir/migrate-ds.pl
%_sbindir/ns-accountstatus.pl
%_sbindir/ns-activate.pl
%_sbindir/ns-inactivate.pl
%_sbindir/ns-newpwpolicy.pl
%_sbindir/remove-ds.pl
%_sbindir/schema-reload.pl
%_sbindir/setup-ds.pl
%_sbindir/syntax-validate.pl
%_sbindir/usn-tombstone-cleanup.pl
%_sbindir/verify-db.pl

%_libdir/%pkgname/perl/
%endif

%files -n python3-module-lib389
%_sbindir/dsconf
%_sbindir/dscontainer
%_sbindir/dscreate
%_sbindir/dsctl
%_sbindir/dsidm
%_man8dir/dsconf.8.*
%_man8dir/dscreate.8.*
%_man8dir/dsctl.8.*
%_man8dir/dsidm.8.*
%python3_sitelibdir_noarch/lib389/
%python3_sitelibdir_noarch/lib389-*-py%_python3_version.egg-info/

%if_with cockpit
%files -n cockpit-389-ds
%dir %_datadir/metainfo/389-console
%_datadir/metainfo/389-console/org.port389.cockpit_console.metainfo.xml
%dir %_datadir/cockpit/389-console
%_datadir/cockpit/389-console/manifest.json
%_datadir/cockpit/389-console/*.html
%_datadir/cockpit/389-console/*.js
%_datadir/cockpit/389-console/*.js.map
%_datadir/cockpit/389-console/css/
%endif

%changelog
