%define ver_major 3.2
%def_disable static
%def_enable gtk_doc
%def_enable introspection
%def_disable orbit
%def_enable gsettings

%define _libexecdir %_prefix/libexec
%define _rpmmacrosdir %_rpmlibdir/macros.d

%define oldname GConf2

Name: GConf
Version: %ver_major.6
Release: alt3

Provides: %oldname = %version
Obsoletes: %oldname < %version
# since 3.2.6
Obsoletes: %name-sanity-check

Summary: Gnome Config System
Summary(ru_RU.UTF-8): Система конфигурации Gnome
License: %lgpl2plus
Group: System/Servers
Url: http://projects.gnome.org/gconf/

Source: %name-%version.tar
#Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
Source1: gconf.rpmmacros
Source2: gconf2_set
Source3: gconf2_add
Source4: gconf2_get
Source5: gconf_sync_state

# stylesheet for strip translations (using XInclude)
# from gconf schema files. Thanks vyt@.
Source10: gconf2-strip-locales.xsl
# gconf2-strip-locales.sh for apply gconf2-strip-locales.xsl
# (%%gconf2_stripschemas rpm macros uses it).
Source11: gconf2-strip-locales.sh

Source15: libgconf.map
Source16: libgconf.lds
Patch1: %name-2.24.0-alt-symver.patch

# from Fedora: patch to reload GConf2 every time a schema is
# added or removed (gnome bug # 333353)
Patch2: GConf-2.18.0.1-reload.patch

# lfs support
Patch3: GConf-3.2.6-alt-lfs.patch

# https://bugzilla.redhat.com/show_bug.cgi?id=755992
# ALT #28916
Patch4: GConf-3.2.6-fc-workaround_crash.patch

%define ORBit_ver 2.12.1
%define glib_ver 2.25.12
%define libxml2_ver 2.6.17
%define gnome_common_ver 2.8.0
%define gir_ver 0.6.7
%define gio_ver 2.31.0

Requires: lib%name = %version-%release
Requires: dbus-tools-gui

# for patch2 /usr/bin/killall required
# Requires: psmisc

BuildPreReq: rpm-build-gnome rpm-build-licenses
BuildPreReq: gnome-common >= %gnome_common_ver
BuildPreReq: gtk-doc >= 1.0
BuildPreReq: intltool >= 0.35
BuildPreReq: gettext-tools
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %gio_ver
BuildPreReq: libxml2-devel >= %libxml2_ver
BuildPreReq: libldap-devel
BuildPreReq: libdbus-devel libdbus-glib-devel libpolkit1-devel polkit

%{?_enable_orbit:BuildPreReq: ORBit2-devel >= %ORBit_ver}
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= %gir_ver}
%{?_enable_gsettings:BuildPreReq: libgio-devel >= %gio_ver}

# to build manpages.
BuildPreReq: help2man

%description
GConf is the Configuration database system for GNOME. However it can be
used with plain GTK+, Xlib, KDE, or even text mode applications as well.

%package -n lib%name
Summary: Gnome Config System library package
Group: System/Libraries
Provides: lib%oldname = %version
Obsoletes: lib%oldname < %version

%description -n lib%name
GConf library package. Contains files needed for using GConf.

%package -n lib%name-devel
Summary: Gnome Config System development package
Group: Development/C
Provides: lib%oldname-devel = %version
Obsoletes: lib%oldname-devel < %version
Requires: lib%name = %version-%release

%description -n lib%name-devel
GConf development package. Contains files needed for doing
development using GConf.

%package -n lib%name-devel-doc
Summary: Development documentation for GConf
Group: Development/C
Conflicts: lib%name < %version
Provides: lib%oldname-devel-doc = %version
Obsoletes: lib%oldname-devel-doc < %version
BuildArch: noarch

%description -n lib%name-devel-doc
GConf is the GNOME Configuration database system.

This package contains development documentation for GConf.

%package -n lib%name-devel-static
Summary: Gnome Config System development package
Group: Development/GNOME and GTK+
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
GConf static libraries package. Contains libraries needed for doing
development using GConf.

%package -n lib%name-gir
Summary: GObject introspection data for the GConf library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the GConf library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the GConf library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the GConf library

%prep
%setup -q
install -p -m644 %_sourcedir/libgconf.{map,lds} gconf/
%patch1 -p1
%patch2 -p1 -b .reload
%patch3 -p1
%patch4 -p1

# disable localization for gconfd
%__subst 's,\(setlocale (.* \"\),\1C,' gconf/gconfd.c

%build
%autoreconf
%configure \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable static} \
	%{subst_enable introspection} \
	%{subst_enable orbit} \
	%{?_enable_gsettings:--enable-gsettings-backend}

# SMP-incompatible build
%make

%install
%make_install DESTDIR=%buildroot install

cat <<__EOF__ >%buildroot%_sysconfdir/gconf/schema-install-source
xml:readwrite:%_cachedir/gconf/gconf.xml.defaults
__EOF__

cat <<__EOF__ >>%buildroot%_sysconfdir/gconf/2/path
xml:readonly:%_cachedir/gconf/gconf.xml.defaults
__EOF__

mkdir -p %buildroot%_datadir/gconf
install -m644 %SOURCE10 %buildroot%_datadir/gconf/
install -m755 %SOURCE11 %buildroot%_datadir/gconf/

mkdir -p %buildroot%_cachedir/gconf/gconf.xml.{defaults,mandatory,system}
mkdir -p %buildroot%_sysconfdir/gconf/{schemas,gconf.xml.system}
chmod 755 %buildroot{%_sysconfdir,%_cachedir}/gconf/gconf.xml.{defaults,mandatory,system}

install -pD -m644 %SOURCE1 %buildroot%_rpmmacrosdir/%name

mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat <<__EOF__ >%buildroot%_sysconfdir/buildreqs/files/ignore.d/gconf
^%_rpmmacrosdir/%name
__EOF__

mkdir -p %buildroot{%_bindir,%_sbindir}
install -p -m755 %SOURCE2 %SOURCE3 %SOURCE4 %buildroot%_bindir/
install -p -m755 %SOURCE5 %buildroot%_sbindir/

cat <<__EOF__ >%buildroot%_sbindir/gconf_install_schema
#!/bin/sh -e

export GCONF_CONFIG_SOURCE=\$(gconftool-2 --get-default-source)
for S in \$*; do
    gconftool-2 --makefile-install-rule "%gconf_schemasdir/\$S.schemas" >/dev/null
done
%_sbindir/gconf_sync_state
__EOF__

cat <<__EOF__ >%buildroot%_sbindir/gconf_uninstall_schema
#!/bin/sh -e

export GCONF_CONFIG_SOURCE=\$(gconftool-2 --get-default-source)
for S in \$*; do
    gconftool-2 --makefile-uninstall-rule "%gconf_schemasdir/\$S.schemas" >/dev/null
done
%_sbindir/gconf_sync_state
__EOF__

chmod 755 %buildroot%_sbindir/gconf_{,un}install_schema

# build man page for gconftool-2
LD_LIBRARY_PATH=gconf/.libs \
help2man -N --name="is a tool to control GConf from the command line" \
	    --manual="Gnome Config System" \
	    gconf/.libs/gconftool-2 > gconftool-2.man

install -pD -m644 gconftool-2.man %buildroot%_man1dir/gconftool-2.1

%find_lang GConf2

%files -f GConf2.lang
%_bindir/*
%_sbindir/gconf*
%_libexecdir/gconfd-2
%_libexecdir/gconf-defaults-mechanism
%_datadir/sgml/gconf
%dir %_datadir/gconf
%dir %_datadir/GConf
%_datadir/GConf/*
%_datadir/gconf/gconf2-strip-locales.sh
%_datadir/gconf/gconf2-strip-locales.xsl
%_datadir/dbus-1/services/org.gnome.GConf.service
%_datadir/dbus-1/system-services/org.gnome.GConf.Defaults.service
%_datadir/polkit-1/actions/org.gnome.gconf.defaults.policy
%dir %_sysconfdir/gconf
%dir %_sysconfdir/gconf/2
%dir %_sysconfdir/gconf/gconf.xml.defaults
%dir %_sysconfdir/gconf/gconf.xml.mandatory
%dir %_sysconfdir/gconf/gconf.xml.system
%dir %_sysconfdir/gconf/schemas
%dir %_cachedir/gconf
%dir %_cachedir/gconf/gconf.xml.defaults
%dir %_cachedir/gconf/gconf.xml.mandatory
%dir %_cachedir/gconf/gconf.xml.system
%_sysconfdir/xdg/autostart/gsettings-data-convert.desktop
%config(noreplace) %_sysconfdir/gconf/2/path
%config(noreplace) %_sysconfdir/gconf/2/evoldap.conf
%config(noreplace) %_sysconfdir/gconf/schema-install-source
%config(noreplace) %_sysconfdir/dbus-1/system.d/org.gnome.GConf.Defaults.conf
%_man1dir/*
%doc AUTHORS NEWS README

%files -n lib%name
%_libdir/*.so.*
%dir %_libdir/GConf
%dir %_libdir/GConf/2
%_libdir/GConf/2/*.so
%_libdir/gio/modules/libgsettingsgconfbackend.so

%exclude %_libdir/gio/modules/libgsettingsgconfbackend.la

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_datadir/aclocal/*
%_rpmmacrosdir/%name
%_sysconfdir/buildreqs/files/ignore.d/gconf

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%_libdir/GConf/2/*.a
%endif

%exclude %_libdir/GConf/*/*.la

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*

%files -n lib%name-gir-devel
%_girdir/*
%endif

%changelog
