# Get Source0-3 from http://download.documentfoundation.org/libreoffice/src/$ver/
# Get Source10 (with selected components) from https://dev-www.libreoffice.org/src/
%def_without forky
%def_without python
%def_with parallelism
%def_without fetch
%def_without lto
%def_with dconf
%def_without orcus

# enable kde5 UI
%def_enable kde5

%ifarch mipsel
%def_without java
%else
%def_with java
%endif
%if_enabled kde5
%def_enable qt5
%else
%def_disable qt5
%endif
%def_disable mergelibs

Name: LibreOffice-still
%define hversion 7.0
%define urelease 6.2
Version: %hversion.%urelease
%define uversion %version.%urelease
%define lodir %_libdir/%name
%define uname libreoffice5
%define conffile %_sysconfdir/sysconfig/%uname
Release: alt2

Summary: LibreOffice Productivity Suite (Still version)
License: LGPL-3.0+ and MPL-2.0
Group: Office
URL: http://www.libreoffice.org

Requires: %name-integrated = %EVR
Requires: %name-common = %EVR
Requires: %name-mimetypes = %EVR
Requires: %name-extensions = %EVR

Provides: %name-full = %EVR
Provides: libreoffice = %EVR
Obsoletes: libreoffice < 3.99
Obsoletes: %name-full < %EVR
Obsoletes: LibreOffice4
Conflicts: LibreOffice

%define with_lang ru be de fr uk pt-BR es kk tt el
#Requires: java xdg-utils hunspell-en hyphen-en mythes-en
#Requires: gst-plugins-bad1.0 gst-plugins-good1.0 gst-plugins-nice1.0 gst-plugins-ugly1.0 gst-plugins-base1.0
Requires: gst-libav

Source:		libreoffice-%version.tar.xz
Source1:	libreoffice-dictionaries-%version.tar.xz
Source2:	libreoffice-help-%version.tar.xz
Source3:	libreoffice-translations-%version.tar.xz

Source10:	libreoffice-ext_sources.%version.tar
Source100:	forky.c
Source200:	key.gpg
Source300:	libreoffice.unused
Source400:	images_oxygen.zip

## FC patches
Patch1: FC-0001-disable-libe-book-support.patch
Patch2: FC-0001-disble-tip-of-the-day-dialog-by-default.patch
Patch3: FC-0001-don-t-suppress-crashes.patch
Patch4: FC-0001-Resolves-rhbz-1432468-disable-opencl-by-default.patch
Patch5: FC-0001-rhbz-1870501-crash-on-reexport-of-odg.patch

## ALT patches
Patch401: alt-001-MOZILLA_CERTIFICATE_FOLDER.patch
Patch402: alt-002-tmpdir.patch
Patch404: alt-004-shortint.patch
Patch410: alt-006-unversioned-desktop-files.patch
Patch411: alt-007-libqrcodegen-include-path.patch
Patch412: alt-008-mkdir-for-external-project.patch

## Upstream fixes
Patch500: 3236020.diff

%set_verify_elf_method unresolved=relaxed
%add_findreq_skiplist %lodir/share/config/webcast/*
%add_findreq_skiplist %lodir/sdk/examples/python/toolpanel/toolpanel.py 
%add_findprov_skiplist %_libdir/liblibreofficekitgtk.so
%add_python3_path %_libdir/%name/sdk/examples/python/

BuildRequires(pre): rpm-build-python3
BuildRequires: cppunit-devel flex fonts-ttf-liberation gcc-c++ git-core gperf gst-plugins1.0-devel hunspell-en imake libGConf-devel libGLEW-devel libabw-devel libbluez-devel libcdr-devel libclucene-core-devel libcmis-devel libcups-devel libdbus-glib-devel libetonyek-devel libexpat-devel libexttextcat-devel libfreehand-devel libglm-devel libgtk+2-devel libgtk+3-devel libharfbuzz-devel libhunspell-devel libhyphen-devel libjpeg-devel liblangtag-devel liblcms2-devel libldap-devel liblpsolve-devel libmspub-devel libmwaw-devel libmythes-devel libneon-devel libnss-devel libodfgen-devel libredland-devel libsane-devel libvigra-devel libvisio-devel libwpd10-devel libwpg-devel libwps-devel libxslt-devel mdds-devel perl-Archive-Zip postgresql-devel python3-dev unzip xorg-cf-files zip
BuildRequires: python2.7(distutils) libunixODBC-devel libX11-devel libXext-devel libXinerama-devel libXrandr-devel libXrender-devel libXt-devel libssl-devel
BuildRequires: xsltproc

# 4.4
BuildRequires: libavahi-devel libpagemaker-devel boost-signals-devel
BuildRequires: libe-book-devel
# 5.1
%if_with java
BuildRequires: junit xsltproc
BuildRequires: ant apache-commons-httpclient apache-commons-lang bsh
BuildRequires: pentaho-reporting-flow-engine
%endif
# 5.1.2
BuildRequires: libgtk+3-gir-devel
# 5.2.0
#BuildRequires: libCoinMP-devel
# 5.3.0
BuildRequires: libzmf-devel libstaroffice-devel libepoxy-devel libmysqlcppconn-devel libmysqlclient-devel
# 5.3.3
BuildRequires: doxygen e2fsprogs
# 5.4.0
BuildRequires: libxmlsec1-nss-devel libgpgme-devel
# 6.0.1
BuildRequires: libepubgen-devel libqxp-devel boost-locale-devel boost-filesystem-devel
# 6.0.5
%if_enabled qt5
BuildRequires: qt5-base-devel
%endif
# 6.1.0
BuildRequires: libnumbertext-devel
# 6.1.1
BuildRequires: python3-module-setuptools
# 6.1.3.1 kde5 UI
%if_enabled kde5
BuildRequires: qt5-base-devel qt5-x11extras-devel
BuildRequires: kf5-kconfig-devel kf5-kcoreaddons-devel
BuildRequires: kf5-ki18n-devel kf5-kio-devel kf5-kwindowsystem-devel
BuildRequires: kf5-kdelibs4support
%endif
# 6.1.5.2
#BuildRequires: libpoppler-devel
# 6.3.5.2
BuildRequires: fontforge
# 6.4.5.2
%if_with orcus
# Build with system liborcus
BuildRequires: liborcus-devel >= 0.15.0
%else
# Build with bundled liborcus
BuildRequires: boost-devel-headers boost-interprocess-devel boost-program_options-devel gcc-c++ zlib-devel boost-filesystem-devel mdds-devel python3-devel
%endif
BuildRequires: libqrcodegen-cpp-devel
BuildRequires: libxcbutil-icccm-devel
BuildRequires: libeot-devel
BuildRequires: libgraphite2-devel
%if_with java
# 7.0.4.2
BuildRequires:  java-9-openjdk-devel
%endif

%if_without python
BuildRequires: python3-dev
%endif

%if_with dconf
BuildRequires: libdconf-devel
%endif

%description
LibreOffice is a productivity suite that is compatible with other major
office suites.

This package provides maximum possible installation of %name along winth
other office packages, except of language packs and GNOME/KDE bindings.

%package common
Summary: Basic installation of %name
Group: Office
Obsoletes: LibreOffice4-common
Conflicts: LibreOffice-common
AutoReqProv: yes, noshell, nopython
# Strict requirements
%if_with java
Requires: pentaho-reporting-flow-engine
%endif

%description common
Common part of %name that does not interfere with other packages

%package integrated
Summary: Binaries, icons and desktop files for %name
Group: Office
Provides: %uname = %EVR
Obsoletes: LibreOffice4-integrated
Conflicts: LibreOffice-integrated
Requires: %name-common = %EVR
%description integrated
Wrapper scripts, icons and desktop files for running %name

%package gtk3
Summary: GTK3 Extensions for %name
Group:  Office
Requires: %uname = %EVR
Requires: %name-common = %EVR
Provides: %name-gnome = %EVR
Obsoletes: %name-gnome < %EVR
Conflicts: LibreOffice-gtk3
%description gtk3
GTK3 extensions for %name

%if_enabled qt5
%package qt5
Summary: Qt5 Extensions for %name
Group:  Office
Requires: %uname = %EVR
Requires: %name-common = %EVR
Conflicts: LibreOffice-qt5
%description qt5
qt5 extensions for %name
%endif

%if_enabled kde5
%package kde5
Summary: KDE5 Extensions for %name
Group:  Office
Requires: %uname = %EVR
Requires: %name-common = %EVR
Provides:  %name-kde4 = %EVR
Obsoletes: %name-kde4 < %EVR
Provides:  LibreOffice4-kde4 = %EVR
Obsoletes: LibreOffice4-kde4 < %EVR
%description kde5
KDE5 extensions for %name
%endif

%package -n libreofficekit-still
Summary: A library providing access to LibreOffice functionality
Group: Graphical desktop/GNOME
License: MPL-2.0
Conflicts: libreofficekit
%description -n libreofficekit-still
LibreOfficeKit can be used to access LibreOffice functionality
through C/C++, without any need to use UNO.

%package -n libreofficekit-still-devel
Summary: Development files for libreofficekit
Group: Development/GNOME and GTK+
Conflicts: libreofficekit-devel
License: MPL-2.0
%description -n libreofficekit-still-devel
The libreofficekit-devel package contains libraries and header files for
developing applications that use libreofficekit.

%package extensions
Summary: Additional extensions for %name
Group:  Office
Requires: %uname = %EVR
AutoReqProv: yes, noshell, nopython
Obsoletes: LibreOffice4-extensions
Conflicts: LibreOffice-extensions
%description extensions
Additional extensions for %name.
One can choose either to install this package at once,
or to download and install (possibly newer) extensions manually.

%package mimetypes
Summary: Mimetype keys support for %name
Group: Office
BuildArch: noarch
Obsoletes: LibreOffice4-mimetypes
Conflicts: LibreOffice-mimetypes
%description mimetypes
%name is distributed along with some mimetype settings and files.
This package installs them.

%package sdk
Group: Development/Other
Summary: Software Development Kit for LibreOffice (Still version)
Conflicts: LibreOffice-sdk

%description sdk
The SDK is a development kit for LibreOffice 5.3, which
eases the development of office components. It provides a set of
libraries, binaries, header, and IDL files which have final API's
and can only be extended with new functionality. This set of libraries
and binaries is the minimum set of functions needed to use system
abstraction for base functionality and for using UNO (Universal
Network Objects) component technology. The UNO component model is the
base of the whole Office API. The SDK provides everything necessary
to use the Office API from external programs (e.g. Java, C++) or to
extend the Office functionality with new components (e.g. new filter
components, CalcAddin functions). It is compatible over several
versions because the API remains unaffected and will only be extended
with new functions.

# TODO redefine %%lang adding corr langpack
# define macro for quick langpack description
%define langpack(l:n:mh) \
%define lang %{-l:%{-l*}}%{!-l:%{error:Language code not defined}} \
%define pkgname langpack-%{lang} \
%define langname %{-n:%{-n*}}%{!-n:%{error:Language name not defined}} \
\
%package %{pkgname} \
Summary: %{langname} language pack for %name \
Group:  Office \
Requires: %uname = %EVR \
%{-m:Requires: mythes-%lang} \
%{-h:Requires: hyphen-%lang} \
Obsoletes: LibreOffice4-%{pkgname} \
%description %{pkgname} \
Provides additional %{langname} translations and resources for %name. \
\
%files %{pkgname} -f %{lang}.lang \
%{nil}

%prep
%if_with forky
echo Using forky
%else
echo Direct build
%endif
%setup -q -n libreoffice-%version -a10 -b1 -b2 -b3

## FC apply patches
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

## ALT apply patches
%patch401 -p0
%patch402 -p1
%patch404 -p1
%patch410 -p1
%patch411 -p1
%patch412 -p1

# Apply upstream patches
%patch500 -p1

# Hack in proper LibreOffice PATH in libreofficekit
sed -i 's@/libreoffice/@/LibreOffice/@g' libreofficekit/Library_libreofficekitgtk.mk

# Hack hardcoded lsattr path
for f in `grep -rl '/usr/sbin/lsattr' *`; do sed -i 's@/usr/sbin/lsattr@/usr/bin/lsattr@g' $f; done

# Hack in MimeType=application/vnd.ms-visio.drawing.main+xml
fgrep -q "application/vnd.ms-visio.drawing.main+xml" sysui/desktop/menus/draw.desktop || sed -i 's@MimeType=@MimeType=application/vnd.ms-visio.drawing.main+xml;@' sysui/desktop/menus/draw.desktop

# hack hardcoded libodbc version
sed -i 's/libodbc.so.1/libodbc.so.2/g' connectivity/source/drivers/odbc/OFunctions.cxx

rm -fr %name-tnslations/git-hooks

install -D %SOURCE100 forky.c

# create shell wrappers
for n in office writer impress calc base draw math qstart; do
	oname=lo$n
	case "$n" in 
		office) opt=""; oname=libreoffice;;
		qstart) opt="--quickstart --nologo --nodefault";;
		*) opt="--$n";;
	esac
	cat > $oname.sh <<@@@
#!/bin/sh
exec %lodir/program/soffice $opt "\$@"
@@@
done

# Now create a config file
grep -r getenv * | sed -n 's/.*getenv *( *"\([^"]*\).*/\1/p' | sort -u | egrep 'STAR_|SAL_|OOO_' > %name.config.ENV

sed -n '/# STAR_PROFILE_LOCKING_DISABLED/,/#.*JITC_PROCESSOR_TYPE_EXPORT/p' < desktop/scripts/soffice.sh > libreoffice.config
test -n "libreoffice.config"
sed -i '/# STAR_PROFILE_LOCKING_DISABLED/i\
test -r %conffile && . %conffile ||:
/# STAR_PROFILE_LOCKING_DISABLED/,/#.*JITC_PROCESSOR_TYPE_EXPORT/d' desktop/scripts/soffice.sh

%build
export CC=%_target_platform-gcc
export CXX=%_target_platform-g++
%ifarch mipsel
export CFLAGS="-Os --param ggc-min-expand=20 --param ggc-min-heapsize=32768 -g0"
export CXXFLAGS="$CFLAGS"
%else
export CFLAGS="-fPIC"
export CXXFLAGS="$CFLAGS"
%endif

PARALLEL=$(nproc)
%ifarch ppc64le
# reduce excessive resource use
if [ "$PARALLEL" -gt 24 ] ; then
        PARALLEL=24
fi
%endif

./autogen.sh \
	--prefix=%_prefix \
	--libdir=%_libdir \
	--disable-lto \
        --with-vendor="ALT Linux Team" \
        --without-system-poppler \
        %{?_without_orcus:--without-system-orcus } \
        %{subst_enable mergelibs} \
        --enable-odk \
	--disable-firebird-sdbc \
	--disable-coinmp \
        --enable-dbus \
        --enable-evolution2 \
        --enable-gio \
	--enable-build-opensymbol \
	--enable-avahi \
        %{subst_with java} \
        --without-fonts \
        --without-myspell-dicts \
        --without-doxygen \
	\
        --with-external-dict-dir=%_datadir/myspell \
        --with-external-hyph-dir=%_datadir/hyphen \
        --with-external-thes-dir=%_datadir/mythes \
        --with-lang="en-US %with_lang" \
        --with-external-tar=`pwd`/ext_sources \
	\
	--enable-ext-nlpsolver \
	--enable-ext-numbertext \
	--enable-ext-wiki-publisher \
	--enable-ext-ct2n \
	--enable-ext-languagetool \
  \
	--enable-release-build \
	--with-help \
  \
        %{subst_enable qt5} \
	--enable-gtk3 \
	--enable-cipher-openssl-backend \
%if_enabled kde5
        --enable-kde5 \
%endif
%if_with lto
  	--enable-lto \
%endif
%if_with parallelism
	--with-parallelism="$PARALLEL" \
%else   
        --without-parallelism \
%endif
%if_with python
	--enable-python=internal \
%endif
%if_with dconf
	--enable-dconf \
%endif
	--enable-eot \
%if_with fetch
	--enable-fetch-external
%else
	--with-system-libs \
	--disable-fetch-external
%endif

%if_with forky
# Make forky
gcc -g -DHAVE_CONFIG_H -shared -O3 -fomit-frame-pointer -fPIC forky.c -oforky.so -ldl
%endif

%make bootstrap

%if_with parallelism
export _JAVA_OPTIONS="-XX:ParallelGCThreads=2 $_JAVA_OPTIONS"
%endif

%if_with forky
# TODO prefect forky_max tune
echo Using forky
export forky_divider=21
export forky_max_procs=`awk '/^Max processes/{print int(5*$3/'$forky_divider')}' < /proc/self/limits`
export forky_max_rss=6400000
export forky_max_vsz=9600000
export forky_verbose=1
echo "max_procs $forky_max_procs / max_vsz $forky_max_vsz / max_rss $forky_max_rss" | tee $HOME/forky.log
export LD_PRELOAD=`pwd`/forky.so

%make build-nocheck || { tail -100 $HOME/forky.log; head -1 $HOME/forky.log; wc $HOME/forky.log; false; }
test -r $HOME/forky.log && echo "Fork() was `wc -l $HOME/forky.log` times delayed" || :
%else
%make build-nocheck
%endif

# Generate typelib files
## TODO use stuff generated here
export DESTDIR=../output
export KDEMAINDIR=/usr
export GNOMEDIR=/usr
export GNOME_MIME_THEME=hicolor
export PREFIXDIR=/usr
. ./bin/get_config_variables PRODUCTVERSIONSHORT PRODUCTVERSION SRCDIR WORKDIR PKG_CONFIG INSTDIR
export PRODUCTVERSIONSHORT PRODUCTVERSION SRCDIR WORKDIR PKG_CONFIG INSTDIR
cd $WORKDIR/CustomTarget/sysui/share/libreoffice
./create_tree.sh

%install
%makeinstall DESTDIR=%buildroot INSTALLDIR=%lodir

%if_with python
# Ignore dull /usr/local/bin/python hack
chmod -x %buildroot%lodir/program/python-core*/lib/cgi.py
%endif

# Pick up LOO-generated file lists
for l in %with_lang; do
	ll="`echo "$l" | tr '-' '_'`"
	cat %buildroot/gid_*_$ll | sort -u > $l.lang
done

# Create gtk3 plugin list
find %buildroot%lodir -name "*_gtk3*" ! -name "*_kf5*" | sed 's@^%buildroot@@' > files.gtk3

# Create qt5 plugin list
find %buildroot%lodir -name "*qt5*"   | sed 's@^%buildroot@@' > files.qt5

# Create kde5 plugin list
find %buildroot%lodir -name "*_kf5*" -o -name "libkf5*" | sed 's@^%buildroot@@' > files.kde5

# Generate base filelist by removing files from  separated packages
{ cat %buildroot/gid_* | sort -u ; cat *.lang files.gtk3 files.kde5 files.qt5; echo %lodir/program/liblibreofficekitgtk.so; } | sort | uniq -u | grep -v '~$' | egrep -v '/share/extensions/.|%lodir/sdk/.' > files.nolang

# Return Oxygen icon theme from LibreOffice 5.3 (see https://bugs.documentfoundation.org/show_bug.cgi?id=110353 for details)
install -D %SOURCE400 %buildroot%lodir/share/config/images_oxygen.zip
echo "%lodir/share/config/images_oxygen.zip" >> files.nolang

unset RPM_PYTHON

# Install wrappers
for n in lo*.sh; do install -m755 -D $n %buildroot%_bindir/${n%%.sh}; done
install -Dm755 libreoffice.sh %buildroot%_bindir/libreoffice
install -Dm755 libreoffice.sh %buildroot%_bindir/loffice
ln -s loffice %buildroot%_bindir/soffice
ln -s ../%_lib/%name/program/unopkg %buildroot%_bindir/unopkg

# Install icons
for f in `( cd sysui/desktop/icons; find hicolor -type f )`; do
	d=`dirname "$f"`; n=`basename "$f"`
	if [[ "$d" == *apps ]]; then
		# Add prefix to apps icons
		install -D sysui/desktop/icons/$f %buildroot%_iconsdir/$d/libreoffice-$n
	else
		install -D sysui/desktop/icons/$f %buildroot%_iconsdir/$d/$n
	fi
done

# Install desktop files
# Hack out "Education" category from Math
subst 's/Education;//' %buildroot%lodir/share/xdg/math.desktop
for f in %buildroot%lodir/share/xdg/*.desktop; do
	n=`basename "$f"`
	install -Dpm0644 "$f" %buildroot%_desktopdir/libreoffice-$n
done

# TODO some other hack with .mime (?)
mkdir -p %buildroot%_datadir/mime-info %buildroot%_datadir/mimelnk/application %buildroot%_datadir/application-registry
install sysui/desktop/mimetypes/*.keys %buildroot%_datadir/mime-info/
install sysui/desktop/mimetypes/*.mime %buildroot%_datadir/mime-info/
install sysui/desktop/mimetypes/*.desktop %buildroot%_datadir/mimelnk/application/
install sysui/desktop/mimetypes/*.applications %buildroot%_datadir/application-registry/

# Install mime package bundle for LibreOffice MIME types
install -Dm0644 workdir/CustomTarget/sysui/share/output/usr/share/mime/packages/libreoffice%hversion.xml %buildroot%_datadir/mime/packages/libreoffice%hversion.xml

# Config file
install -D libreoffice.config %buildroot%conffile

# Typelib/GIR stuff
#install -D workdir/CustomTarget/sysui/share/output/girepository-1.0/LOKDocView-0.1.typelib %buildroot%_typelibdir/LOKDocView-0.1.typelib
#install -D workdir/CustomTarget/sysui/share/output/usr/share/gir-1.0/LOKDocView-0.1.gir %buildroot%_girdir/LOKDocView-0.1.gir
mv %buildroot%lodir/program/liblibreofficekitgtk.so %buildroot%_libdir/
mkdir -p %buildroot%_includedir/LibreOfficeKit
install -p include/LibreOfficeKit/* %{buildroot}%{_includedir}/LibreOfficeKit

# Make symkinks for x-office-* icons
# oasis-text -> x-office-document
# oasis-spreadsheet -> x-office-spreadsheet
# oasis-presentation -> x-office-presentation
# oasis-drawing -> image-x-generic
for dir in `ls -d %buildroot%_iconsdir/hicolor/*`; do
	for type in text spreadsheet presentation drawing; do
		target="$type"
		if [ "$type" == "text" ]; then
			target="x-office-document"
		elif ["$type" == "drawing" ]; then
			target="image-x-generic"
		else
			target="x-office-$type"
		fi
		for format in png svg; do
			if [ -e $dir/mimetypes/oasis-$type.$format ]; then
				ln -s oasis-$type.$format $dir/mimetypes/$target.$format
			fi
		done
	done
done

# Install appdata files
mkdir -p %buildroot%_datadir/metainfo
cp -a sysui/desktop/appstream-appdata/*.xml %buildroot%_datadir/metainfo

# Install man pages
install -Dpm0644 sysui/desktop/man/libreoffice.1 %buildroot%_man1dir/libreoffice.1
install -Dpm0644 sysui/desktop/man/unopkg.1 %buildroot%_man1dir/unopkg.1

%files

%files sdk
%lodir/sdk

%files common -f files.nolang
%exclude /gid_Module*
%_bindir/libreoffice
%_bindir/unopkg
%config %conffile
%lodir/share/extensions/package.txt
%_iconsdir/*/*/apps/libreoffice-*.*g
%_datadir/metainfo/*.appdata.xml
%_man1dir/libreoffice.1*
%_man1dir/unopkg.1*

%files integrated
%_bindir/*
%exclude %_bindir/libreoffice
%exclude %_bindir/unopkg
%_desktopdir/libreoffice-*.desktop
%_iconsdir/*/*/mimetypes/*
%_iconsdir/*/*/apps/*
%exclude %_iconsdir/*/*/apps/libreoffice-*.*g

%files gtk3 -f files.gtk3

%if_enabled qt5
%files qt5 -f files.qt5
%endif

%if_enabled kde5
%files kde5 -f files.kde5
%_datadir/metainfo/org.libreoffice.kde.metainfo.xml
%endif

%files extensions
%lodir/share/extensions/*
%exclude %lodir/share/extensions/package.txt

%files mimetypes
%_datadir/mime/packages/libreoffice%hversion.xml
%_datadir/mime-info/*
%_datadir/mimelnk/application/*
%_datadir/application-registry/*

%langpack -m -h -l ru -n Russian
%langpack    -h -l be -n Belorussian
%langpack -m -h -l de -n German
%langpack -m -h -l fr -n French
%langpack -m -h -l uk -n Ukrainian
%langpack       -l pt-BR -n Brazilian Portuguese
%langpack -m -h -l es -n Espanian
%langpack       -l kk -n Kazakh
%langpack    -h -l tt -n Tatar
%langpack -m -h -l el -n Greek

%files -n libreofficekit-still
#_typelibdir/LOKDocView-*.typelib
%_libdir/liblibreofficekitgtk.so

%files -n libreofficekit-still-devel
#_girdir/LOKDocView-*.gir
%_includedir/LibreOfficeKit

%changelog
