%define nm_version 1.18.10-alt3
#define git_hash .g5d8a9fda
%define git_hash %nil

%define _unpackaged_files_terminate_build 1

%def_without appindicator
%def_with team
%def_without selinux

%ifarch %e2k
%define more_warnings no
%else
%define more_warnings error
%endif

Name: NetworkManager-applet-gtk
Version: 1.24.0
Release: alt1%git_hash
License: GPLv2+
Group: Graphical desktop/GNOME
Summary: Panel applet for use with NetworkManager
Url: https://wiki.gnome.org/Projects/NetworkManager
Vcs: https://gitlab.gnome.org/GNOME/network-manager-applet.git
Source: nm-applet-%version.tar
Patch: nm-applet-%version-%release.patch

BuildRequires(pre): meson

BuildRequires: libgtk+3-devel libtool
BuildRequires: libnotify-devel
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnm-gir-devel >= %nm_version
BuildRequires: libgudev-devel
BuildRequires: libmm-glib-devel
BuildRequires: libsecret-devel
BuildRequires: libnma-devel >= 1.8.28-alt1
%{?_with_appindicator:BuildRequires: libappindicator-gtk3-devel}
%{?_with_team:BuildRequires: libjansson-devel}
%{?_with_selinux:BuildRequires: libselinux-devel}

Requires: NetworkManager-daemon >= %nm_version
Requires: dbus-tools-gui
Requires: mobile-broadband-provider-info
Requires: iso-codes

Obsoletes: NetworkManager-gnome < 0.9.8.4
Provides: NetworkManager-gnome = %version-%release

%description
This package contains GNOME utilities and applications for use with
NetworkManager, including a panel applet for wireless networks.

%prep
%setup -n nm-applet-%version
%patch -p1
%build
%meson \
    --libexecdir==%_libexecdir/NetworkManager \
    --localstatedir=%_var \
%if_with selinux
    -Dselinux=true \
%else
    -Dselinux=false \
%endif
%if_with appindicator
    -Dappindicator=yes \
%else
    -Dappindicator=no \
%endif
%if_with team
    -Dteam=true \
%else
    -Dteam=false \
%endif
	-Dwwan=true

%meson_build -v

%install
%meson_install
%find_lang nm-applet

# For VPN plugins
mkdir -p %buildroot/%_datadir/gnome-vpn-properties

%check
%meson_test

%files -f nm-applet.lang
%_bindir/*
%_iconsdir/hicolor/*/apps/*
%_sysconfdir/xdg/autostart/nm-applet.desktop
%_datadir/GConf/gsettings/nm-applet.convert
%doc %_man1dir/*.*

%_datadir/applications/*.desktop
%_datadir/metainfo/*.xml
%dir %_datadir/gnome-vpn-properties

%changelog
