%define origver 2020.1

Name: SimGear
Version: %origver
Release: alt1

Summary: Simulator Construction Tools

License: GPL
Group: System/Libraries
Url: http://www.flightgear.org

Packager: Michael Shigorin <mike@altlinux.org>

# Source-url: https://sourceforge.net/projects/flightgear/files/release-%origver/simgear-%version.tar.bz2
Source: %name-%version.tar
Patch0: simgear-3.2.0-fedora-format.patch
Patch1: simgear-3.6.0-fedora-aarch64.patch
Patch2: %name-g++8.patch
Patch3: simgear-2018.2.2-alt-e2k.patch

# Automatically added by buildreq on Sat Mar 03 2012
# optimized out: cmake-modules libGL-devel libICE-devel libOpenThreads-devel libSM-devel libX11-devel libXau-devel libXext-devel libopenal-devel libstdc++-devel xorg-kbproto-devel xorg-xproto-devel
BuildRequires: boost-devel-headers cmake gcc-c++ libGLU-devel libOpenSceneGraph-devel libXi-devel libXt-devel libalut-devel libapr1-devel zlib-devel libcurl-devel

BuildRequires: cmake libapr1-devel
BuildRequires: libexpat-devel

%description
SimGear is a set of open-source libraries designed to be used
as building blocks for quickly assembling 3d simulations, games,
and visualization applications.

%package -n libsimgear
Summary: Simulation library
Group: System/Libraries

%description -n libsimgear
SimGear is a set of open-source libraries designed to be used
as building blocks for quickly assembling 3d simulations, games,
and visualization applications.

%package -n libsimgear-devel
Summary: Simulation library (development part)
Group: Development/C
Provides: SimGear = %version
Provides: SimGear-devel = %version
Obsoletes: SimGear-devel < 1.0.0
Conflicts: SimGear-devel < 1.0.0

# from SimGearTargets.cmake
Requires: libOpenSceneGraph-devel libOpenThreads-devel
Requires: zlib-devel libcurl-devel libopenal-devel libGL-devel libGLU-devel

%description -n libsimgear-devel
SimGear is a set of open-source libraries designed to be used as
building blocks for quickly assembling 3d simulations, games,
and visualization applications.

This package contains header files for SimGear.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p2
%patch3 -p2
#sed -i "s|\${CMAKE_INSTALL_LIBDIR}/cmake/SimGear|%_libdir/cmake/SimGear|" CMakeLists.txt

%build
%add_optflags %optflags_shared
# /usr/src/RPM/BUILD/SimGear-2020.1/simgear/io/HTTPRepository.cxx:267:16: error: return-statement with a value, in function returning 'void' [-fpermissive]
#         return "";
%add_optflags -fpermissive
%ifarch e2k
%add_optflags -fno-error-always-inline
%endif
%cmake_insource \
	-DCMAKE_BUILD_TYPE=Release \
	-DSIMGEAR_SHARED=ON \
	-DSYSTEM_EXPAT=ON \
	-DENABLE_TESTS=OFF
%make_build

%install
%makeinstall_std

%files -n libsimgear
%doc AUTHORS README* Thanks
%_libdir/*.so.*

%files -n libsimgear-devel
%_libdir/*.so
%_includedir/simgear
%_libdir/cmake/%name/

%changelog
