Name: accel-ppp
Version: 1.12.0
Release: alt4
Summary: High performance PPTP/L2TP/PPPoE server
Group: System/Servers

Packager: Alexei Takaseev <taf@altlinux.ru>

License: GPLv2
Url: http://sourceforge.net/projects/accel-ppp/
Source0: %name-%version.tar
Patch0: %name-%version-%release.patch
Requires: snmp-mibs-std
AutoProv: yes

BuildRequires: cmake libnet-snmp-devel libpcre-devel libnl-devel libssl-devel liblua5.3-devel glibc-kernheaders
BuildPreReq: rpm-build-kernel

%description
The ACCEL-PPP is completly new implementation of PPTP/PPPoE/L2TP
which was written from scratch. Userspace daemon has its own PPP
implementation, so it does not uses pppd and one process (multi-threaded)
manages all connections. ACCEL-PPP uses only kernel-mode implementations
of pptp/l2tp/pppoe.

Features:
- IPoE server
- PPTP server
- PPPoE server
- L2TPv2 server
- Radius CoA/DM (PoD)
- Built-in shaper (htb)
- Command line interface (telnet)
- SNMP
- IPv6 (including builtin Neighbor Discovery and DHCPv6)

%package -n kernel-source-%name
Summary: Kernel module for accel-ppp IPoE
License: GPLv2
Group: Development/Kernel
BuildArch: noarch

%description -n kernel-source-%name
Provide accel-ppp ipoe kernel module


%prep
%setup
%patch0 -p1
tar -cjf ../%name-%version.tar.bz2 ../%name-%version

%build
%cmake \
      -DCMAKE_SKIP_RPATH:BOOL=FALSE \
      -DCMAKE_SKIP_INSTALL_RPATH:BOOL=FALSE \
      -DBUILD_DRIVER=FALSE \
      -DCMAKE_INSTALL_PREFIX=%prefix \
      -DRADIUS=TRUE \
      -DNETSNMP=TRUE \
      -DLOG_PGSQL=FALSE \
      -DLUA=5.3 \
      -DBUILD_INSTALL_PREFIX=%buildroot \
      -DCMAKE_BUILD_TYPE=Debug \
      -DMEMDEBUG=TRUE

%cmake_build

%install
make install/fast DESTDIR=%buildroot -C BUILD

install -Dpm 644 alt-linux/%name.tmpfiles %buildroot%_tmpfilesdir/%name.conf
install -d %buildroot%_sysconfdir/{rc.d/init.d,sysconfig,logrotate.d}
install -pDm0644 alt-linux/%name.sysconfig	%buildroot%_sysconfdir/sysconfig/%name
install -pDm0755 alt-linux/%name.init		%buildroot%_initdir/%name
install -pDm0644 alt-linux/%name.logrotate	%buildroot%_sysconfdir/logrotate.d/%name
mkdir -p %buildroot%_runtimedir/accel-ppp

mkdir -p %kernel_srcdir
install -pDm0644 ../%name-%version.tar.bz2 %kernel_srcdir/%name-%version.tar.bz2

%post
%post_service %name

%preun
%preun_service %name

%files
%doc COPYING README accel-pppd/extra/net-snmp/ACCEL-PPP-MIB.txt alt-linux/IPoE_ru.txt alt-linux/IPoE_dhcp_lua_ru.txt
%config(noreplace) %_initdir/*
%config(noreplace) %_sysconfdir/sysconfig/*
%config %_sysconfdir/logrotate.d/*
%config(noreplace) %_tmpfilesdir/*
%_sysconfdir/accel-ppp.conf.dist
%_bindir/accel-cmd
%_sbindir/accel-pppd
%_libdir/%name
%_datadir/accel-ppp/
%_mandir/man1/accel-cmd*
%_mandir/man5/accel-ppp.conf.5*
%_runtimedir/accel-ppp/
%_logdir/accel-ppp/

%files -n kernel-source-%name
%attr(0644,root,root) %kernel_src/%name-%version.tar.bz2

%changelog
