Name: alterator
Version: 5.3
Release: alt1.qa1

Summary: ALT Linux configurator engine
License: GPLv2+
Group: System/Configuration/Other
Url: http://wiki.sisyphus.ru/Alterator

Source: %name-%version.tar
Patch: alterator-5.1-compilation-workaround.patch
Patch1: alterator-guile20.patch
Patch2: alterator-5.1-call-cc-via-shift.patch
Patch3: alterator-5.1-eval-set-fix.patch

#backward compatibility
Provides: %name-common = %version , %name-menu = %version, %name-help = %version, %name-sdk = %version, %name-autoinstall = %version
Obsoletes: %name-common, %name-menu, %name-help, %name-sdk, %name-autoinstall

Requires: rpm-macros-%name = %version-%release
Requires: alterator-l10n >= 2.0-alt2
Requires: alterator-sh-functions
%ifarch %e2k
Requires: guile20 libguile20
%else
Requires: guile22
%endif
%{?!_with_bootstrap:Requires: alterator-lookout}

Requires(pre): libguile-vhttpd >= 0.7.8-alt1
Requires(pre): shadow-utils

#incompatibility
Conflicts: alterator-lookout < 1.3-alt13
Conflicts: alterator-fbi < 5.24-alt1
Conflicts: alterator-xkb < 2.0-alt3
Conflicts: alterator-vm <= 0.3-alt31
Conflicts: installer-stage2 <= 0.8-alt1

BuildRequires: /proc
%ifarch %e2k
BuildRequires: guile20-devel libguile20-devel libexpat-devel pam_userpass-devel
%else
BuildRequires: guile22-devel >= 2.2.0-alt2 libexpat-devel pam_userpass-devel
%endif
BuildRequires: libguile-vhttpd

%define _alterator_datadir %_datadir/%name
%define _alterator_libdir %_libexecdir/%name

%add_findreq_skiplist %_alterator_datadir/build/profiles/*
%add_findreq_skiplist %_alterator_datadir/build/xgettext/*
%add_findreq_skiplist %_alterator_datadir/build/msgfmt/*

%description
ALT Linux configurator engine

%package doc
Summary: documentation and samples for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: %name = %version-%release

%description doc
documentation and samples for %name

%package -n rpm-macros-%name
Summary: Set of RPM macros for packaging %name-based applications
Group: Development/Other
BuildArch: noarch
Conflicts: %name < 4.7-alt6

%description -n rpm-macros-%name
Set of RPM macros for packaging %name-based applications for ALT Linux.
Install this package if you want to create RPM packages that use %name.

%prep
%setup
%patch -p2
%ifarch %e2k
sed -i "s:guile/2.2:guile/2.0:g" build/guile-ext.mak
%patch1 -p2
%patch2 -p2
%endif
%patch3 -p2

%build
%make_build GUILE_VERSION=%guile_version

%check
%make check-api

%install
export LTDL_LIBRARY_PATH=src/libguile-gettext:src/libguile-pipe:%_libdir/guile/%guile_version
%makeinstall GUILE_VERSION=%guile_version unitdir=%buildroot%_unitdir \
	     GUILE_LOAD_PATH=%_alterator_datadir/lookout
ln -s ../bin/alterator-cmdline %buildroot%_sbindir/

#create special directories
mkdir -p %buildroot%_runtimedir/alteratord
mkdir -p %buildroot%_cachedir/%name
mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_sysconfdir/%name
mkdir -p %buildroot%_tmpfilesdir
mkdir -p %buildroot%_rpmmacrosdir

install -Dpm640 alterator-chkpwd.pamd %buildroot%_sysconfdir/pam.d/alterator-chkpwd

cat >%buildroot%_rpmmacrosdir/%name<<EOF
%%_alterator_datadir %%_datadir/%name
%%_alterator_libdir %%_libexecdir/%name

%%_alterator_backend2dir %%_alterator_libdir/backend2
%%_alterator_backend3dir %%_alterator_libdir/backend3
EOF

cat >%buildroot%_tmpfilesdir/%name.conf<<EOF
d /var/run/alteratord 0710 root _alteratord -
EOF

%pre
/usr/sbin/groupadd -r -f _alteratord

%post
%post_service alteratord

%preun
%preun_service alteratord

%files
%_bindir/*

%dir %_alterator_libdir
%_alterator_libdir/backend3
%attr(700,root,root) %dir %_alterator_libdir/hooks
%_alterator_libdir/interfaces
%{?!_with_bootstrap:%_alterator_libdir/lookout}
%_alterator_libdir/type
%_alterator_libdir/ui

%_alterator_datadir

%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/menu
%attr(700,root,root) %dir %_cachedir/%name
%attr(700,root,root) %dir %_localstatedir/%name
%_tmpfilesdir/%name.conf

%_datadir/guile/site/%guile_version/alterator
%guile_ccachedir/alterator
%guile_extensiondir/*.so

%_sbindir/*
%_initdir/*
%_mandir/man?/*
%attr(710,root,_alteratord) %dir /var/run/alteratord

%_unitdir/alteratord.service
%_unitdir/alteratord.socket

%attr(640,root,root) %_sysconfdir/pam.d/alterator-chkpwd

%files doc
%doc doc/samples doc/internals

%files -n rpm-macros-%name
%_rpmmacrosdir/*

%changelog
