Name: aqualung
Summary: Aqualung is a music player for the GNU/Linux operating system
Version: 1.0
Release: alt3
License: GPL
Group: Sound
# http://aqualung.factorial.hu/download.php?key=svntgzd
Source: %name-%version.tar.gz
Patch: use_glib_instead_of_libmac_for_charconv.patch
Patch1: %name-%version-upstream-ffmpeg.patch
#Source:			%name-%version.tar.gz
Url: http://aqualung.sf.net

# Automatically added by buildreq on Mon Sep 14 2015
# optimized out: fontconfig fontconfig-devel glib2-devel libatk-devel libavcodec-devel libavutil-devel libcairo-devel libcdio-devel libcdio-paranoia libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libjson-c libogg-devel libopencore-amrnb0 libopencore-amrwb0 libp11-kit libpango-devel libstdc++-devel libusb-compat libwayland-client libwayland-server pkg-config raptor2-devel xz zlib-devel
BuildRequires: gcc-c++ libalsa-devel libavformat-devel libcddb-devel libcdio-paranoia-devel libflac-devel libgtk+2-devel libifp-devel libjack-devel liblame-devel liblrdf-devel lua-devel libmac-devel libmad-devel libmodplug-devel libmpcdec-devel liboggz-devel libpulseaudio-devel libsamplerate-devel libsndfile-devel libspeex-devel libusb-compat-devel libvorbis-devel libwavpack-devel libxml2-devel

%description
Aqualung is a music player for the GNU/Linux operating system.

It plays audio files from your filesystem and has the feature of
inserting no gaps between adjacent tracks. It also supports high
quality sample rate conversion between the file and the output
device, when necessary.

Almost all sample-based, uncompressed formats (eg. WAV, AIFF, AU
etc.) are supported. Files encoded with FLAC (the Free Lossless
Audio Codec), Ogg Vorbis, MPEG Audio (including the infamous MP3
format) and MOD files (MOD, S3M, XM, IT, etc.) are also supported.

The program can play the music through OSS, ALSA or the JACK Audio
Connection Kit.

Aqualung supports the LADSPA 1.1 plugin standard. You can use any
suitable plugin to enhance the music you are listening to.

Other features of the program: internally working volume and balance
controls (not touching the soundcard mixer), multiple skin support,
random seeking during playback, track repeat, list repeat and shuffle
mode (besides normal playback). It will come up in the same state as
it was when you closed it, including playback modes, volume & balance
settings, currently processing LADSPA plugins, window sizes,
positions & visibility, and other miscellaneous options.

You can control any running instance of the program remotely from the
command line (start, stop, pause etc.). Remote loading or enqueueing
soundfiles as well as complete playlists is also supported.

In addition to all this, Aqualung provides a so-called Music Store
that is an XML-based music database, capable of storing various
metadata about music on your computer (including, but not limited
to, the names of artists, and the titles of records and tracks).
You can (and should) organize your music into a tree of
Artists/Records/Tracks, thereby making life easier than with the
all-in-one Winamp/XMMS playlist.

Author: Tom Szilagyi <tszilagyi@users.sourceforge.net>

%prep
%setup
%patch
%patch1 -p1

sed -i 's/\[mad], \[mad],/[mad], [libmad],/' configure.ac

%build
%autoreconf
%configure \
	--enable-debug \
	--prefix=%prefix \
	--with-alsa=yes \
	--with-cdda=yes \
	--with-cddb=yes \
	--with-flac=yes \
	--with-ifp=yes \
	--with-jack=yes \
	--with-ladspa=yes \
	--with-lame=yes \
	--with-lavc=yes \
	--with-mac=yes \
	--with-mpc=yes \
	--with-mpeg=yes \
	--with-mod=yes \
	--with-oss=yes \
	--with-sndfile=yes \
	--with-speex=yes \
	--with-src=yes \
	--with-pulse=yes \
	--with-vorbisenc=yes \
	--with-wavpack=yes

# *64 patch
sed -i 's@/usr/lib/@%_libdir/@g' src/plugin.c

%make_build

%install
%makeinstall

# icon
install -Dm 644 src/img/icon_48.png %buildroot%_liconsdir/%name.png

# menu-entry
install -dm 755 %buildroot/%_desktopdir
cat > %name.desktop << EOF
[Desktop Entry]
Type=Application
Comment=A music player with LADSPA plugins support
Categories=AudioVideo;Audio;Player;
Terminal=false
Exec=%name
Icon=%name
Name=Aqualung
EOF
install -m 0644 %name.desktop \
	%buildroot/%_desktopdir/%name.desktop

%find_lang %name

%files -f %name.lang
%doc AUTHORS ChangeLog COPYING README
%doc %_defaultdocdir/aqualung
%_bindir/%name
%_mandir/man1/*
%dir %_datadir/%name
%_datadir/%name/*
%_liconsdir/%name.png
%_desktopdir/%name.desktop

%changelog
