Name: aspell
Version: 0.60.8
Release: alt1

Summary: An Open Source interactive spelling checker program
License: LGPL-2.1
Group: Text tools
Url: http://%name.net/

Source: http://ftp.gnu.org/gnu/%name/%name-%version.tar.gz
Source101: %name-ispell.alternatives

BuildRequires(pre): rpm-macros-alternatives
BuildRequires: gcc-c++ libncursesw-devel
Requires: lib%name = %version-%release

%def_disable static
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
GNU Aspell is a spell checker designed to eventually replace Ispell.
It can either be used as a library or as an independent spell checker.
Its main feature is that it does a much better job of coming up with
possible suggestions than just about any other spell checker out there
for the English language, including Ispell and Microsoft Word. It
also has many other technical enhancements over Ispell such as using
shared memory for dictionaries and intelligently handling personal
dictionaries when more than one Aspell process is open at once.

%package -n %name-ispell
Summary: Spell and Ispell compatibility scripts for Aspell
Group: Text tools
BuildArch: noarch
Requires(post,preun): alternatives >= 0.2
Requires: %name = %version-%release
Provides: ispell
Provides: /usr/bin/spell
Obsoletes: pspell-ispell

%description -n %name-ispell
Two simple scripts: Spell and Ispell compatibility scripts for Aspell.

%package -n lib%name
Summary: Shared libraries required for %name-based software
Group: System/Libraries
Provides: libpspell
Obsoletes: libpspell

%description -n lib%name
Shared libraries required for %name-based software.

%package -n lib%name-devel
Summary: Development files needed to build applications with %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Development files needed to build applications with %name.

%package -n lib%name-devel-static
Summary: Static library needed to build static applications with %name
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
Static library needed to build statically linked applications with %name.

%prep
%setup

%build
%autoreconf
%configure %{subst_enable static} \
	--enable-pkgdatadir=%_datadir/%name \
	--enable-pkglibdir=%_libdir/%name \
	--enable-wide-curses
%make_build


%install
%make_install DESTDIR=%buildroot install
ln -sf cp1251.cset %buildroot%_datadir/%name/windows-1251.cset
mv %buildroot%_datadir/%name/ispell %buildroot%_bindir/%name-ispell
mv %buildroot%_datadir/%name/spell %buildroot%_bindir/%name-spell
install -d %buildroot%_altdir
install -p -m 644 %SOURCE101 %buildroot%_altdir/%name-ispell

cp modules/filter/*.info %buildroot%_libdir/%name/
rm -rf %buildroot%_libdir/%name/*.la

%find_lang %name

%files -n lib%name
%_datadir/%name
%dir %_libdir/%name
%_libdir/*.so.*
%_libdir/%name/*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_infodir/aspell-dev.*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files -n %name-ispell
%_altdir/%name-ispell
%_bindir/%name-ispell
%_bindir/%name-spell

%files -f %name.lang
%doc README TODO
%_bindir/aspell
%_bindir/aspell-import
%_bindir/pspell-config
%_bindir/pre*
%_bindir/run-with-aspell
%_bindir/word-list-compress
%_infodir/aspell.info.*
%_man1dir/*.1.*

%changelog
