%define ver_major 2.32
%define api_ver 2.0
%define _libexecdir %_prefix/libexec
%def_enable introspection
%def_enable x11
%def_disable xevie
%def_enable doc
%def_disable check

Name: at-spi2-core
Version: %ver_major.1
Release: alt1.1

Summary: Protocol definitions and daemon for D-Bus at-spi
Group: System/Libraries
License: LGPLv2+
Url: http://www.linuxfoundation.org/en/AT-SPI_on_D-Bus

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Requires: lib%name = %version-%release
Requires: dbus-tools-gui

BuildRequires(pre): meson
BuildRequires: libgio-devel >= 2.36.0 libdbus-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_x11:BuildRequires: libXtst-devel libXext-devel libXi-devel libICE-devel libSM-devel}
%{?_enable_xevie:BuildRequires: libXevie-devel}
%{?_enable_doc:BuildRequires: gtk-doc}

%description
at-spi allows assistive technologies to access GTK-based
applications. Essentially it exposes the internals of applications for
automation, so tools such as screen readers, magnifiers, or even
scripting interfaces can query and interact with GUI controls.

This version of at-spi is a major break from previous versions.
It has been completely rewritten to use D-Bus rather than
ORBIT/CORBA for its transport protocol.

%package -n lib%name
Summary: Shared at-spi library
Group: System/Libraries

%description -n lib%name
This package contains shared library needed to run at-spi daemon.

%package -n lib%name-devel
Summary: Development files and headers for at-spi2-core
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package includes the header files and API documentation for
libatspi.

%package -n lib%name-gir
Summary: GObject introspection data for at-spi2-core
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for at-spi library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for at-spi2-core
Group: Development/Other
BuildArch: noarch
Requires: lib%name-devel = %version-%release
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the at-spi library.

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
This package contains documentation for developing applications that use
%name library.

%prep
%setup

%build
%meson \
    -Ddbus_daemon=/bin/dbus-daemon \
    %{?_disable_x11:-Denable-x11=false} \
    %{?_disable_introspection:-Denable-introspection=false} \
    %{?_enable_doc:-Ddocs=true}

%meson_build

%install
%meson_install
%find_lang %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %name.lang
%_libexecdir/at-spi2-registryd
%_libexecdir/at-spi-bus-launcher
%_datadir/dbus-1/accessibility-services/org.a11y.atspi.Registry.service
%_datadir/dbus-1/services/org.a11y.Bus.service
%_datadir/defaults/at-spi2/accessibility.conf
%_sysconfdir/xdg/autostart/at-spi-dbus-bus.desktop
%_prefix/lib/systemd/user/at-spi-dbus-bus.service
%doc AUTHORS README NEWS

%files -n lib%name
%_libdir/libatspi.so.*

%files -n lib%name-devel
%_libdir/libatspi.so
%_includedir/at-spi-%api_ver
%_pkgconfigdir/atspi-2.pc

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/Atspi-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Atspi-%api_ver.gir
%endif

%if_enabled doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/libatspi
%endif

%changelog
