Group: File tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           autoarchive
Version:        1.3.0
Release:        alt1_7
Summary:        A simple backup tool that uses tar

License:        GPLv3
URL:            http://autoarchive.sourceforge.net/
Source0:        http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.bz2
# Fix tests. Cannot submit upstream as issue tracker is locked
Patch0:         autoarchive-1.3.0-fix_tests.patch
BuildArch:      noarch

BuildRequires:  python3-devel
BuildRequires:  python3-module-mock

Requires:       xz
Requires:       tar
Requires:       gzip gzip-utils
Requires:       bzip2
Requires:       xz
Source44: import.info

%description
AutoArchive is a simple utility for making backups more easily. It
uses tar for creating archives. The idea of the program is that every 
information needed for making a backup is in one file - the archive 
spec file. Path to this file is passed as a parameter to 'aa' command 
which reads information from it and creates desired backup.

%prep
%setup -q
%patch0 -p1

%build
# Need to set LANG to ensure we get utf-8 as default codec, or setup.py
# crashes
export LANG=en_US.UTF-8
%python3_build

%install
# Need to set LANG to ensure we get utf-8 as default codec, or setup.py
# crashes
export LANG=en_US.UTF-8
%python3_install
rm -rf %{buildroot}%{_defaultdocdir}/%{name}-%{version}/

%check
pushd AutoArchive
%{__python3} tests/run_tests.py
popd

%files
%doc NEWS README README.sk
%doc --no-dereference COPYING
%config(noreplace) %{_sysconfdir}/aa/
%{_mandir}/man?/*.*
%{_bindir}/autoarchive
%{_bindir}/aa
%{python3_sitelibdir_noarch}/AutoArchive/
%{python3_sitelibdir_noarch}/%{name}*.egg-info

%changelog
