%define _unpackaged_files_terminate_build 1
Name: autorepo-altnode-config
Version: 0.16
Release: alt1
BuildArch: noarch
Packager: Igor Yu. Vlasenko <viy@altlinux.org>

Summary: automated packaging node common configs
Group: System/Configuration/Other
License: GPLv2+
# TODO: change to appropriate page when ready
# Url: https://www.altlinux.org/Autorepo
Url: https://watch.altlinux.org
Source: %name-%version.tar

Requires(pre): postfix rsync-server anonftp vsftpd
Requires: autorepo-altnode-config-apt = %EVR

%description
%summary

%package nginx
Group: System/Configuration/Other
Summary: generic nginx config for the automated packaging node
Requires(pre): nginx
Requires: autorepo-altnode-config = %EVR

%description nginx
%summary nginx

%package apt
Group: System/Configuration/Other
Summary: generic apt config for the automated packaging node
Requires: apt
Conflicts: autorepo-altnode-config < 0.13

%description apt
%summary apt

%prep
%setup

%build

%install
mkdir -p %buildroot%_sysconfdir/autorepo/apt
install -m 644 apt.conf.* sources.list.* %buildroot%_sysconfdir/autorepo/apt/
install -D -m 644 nginx/autoports.conf %buildroot%_sysconfdir/nginx/sites-enabled.d/autorepo.conf

mkdir -p %buildroot%_sysconfdir/monitrc.d
install -m 644 monit/* %buildroot%_sysconfdir/monitrc.d

%post
# postfix
if ! grep '^relayhost' /etc/postfix/main.cf; then
    cat >> /etc/postfix/main.cf <<EOF
# altnode auto configuration
relayhost = [192.168.1.7]
EOF
    service postfix restart ||:
fi
# rsync-server
if ! grep '^\[pub\]' /etc/rsyncd.conf; then
    cat >> /etc/rsyncd.conf <<EOF
# altnode auto configuration
[pub]
path=/var/ftp/pub
#use chroot
read only
list
EOF
    chkconfig rsync on
fi
if ! grep '^\[altnode\]' /etc/rsyncd.conf; then
    cat >> /etc/rsyncd.conf <<EOF
# altnode auto configuration
[altnode]
path=/var/ftp/altnode
use chroot
read only
list
EOF
    chkconfig rsync on
fi
# ftpd
chkconfig vsftpd on ||:
if grep 'only_from = 127.0.0.1' /etc/xinetd.conf; then
    sed -i -e 's,only_from = .*,only_from = 0.0.0.0,' /etc/xinetd.conf
fi
service xinetd restart
service monit restart ||:

%post nginx
chkconfig nginx on ||:
service nginx restart ||:

if [ "$RPM_INSTALL_ARG1" -eq 1 ]; then
    service monit restart ||:
fi

%files
%config %_sysconfdir/monitrc.d/00base.conf
%config %_sysconfdir/monitrc.d/10mail.conf
%config %_sysconfdir/monitrc.d/20httpd.conf
%config %_sysconfdir/monitrc.d/crond.conf
%config %_sysconfdir/monitrc.d/filesystems.conf
%config %_sysconfdir/monitrc.d/nginx.conf
%config %_sysconfdir/monitrc.d/postfix.conf
%config(noreplace) %_sysconfdir/monitrc.d/sshd.conf
%config %_sysconfdir/monitrc.d/system.conf
%config %_sysconfdir/monitrc.d/xinetd.conf
%exclude %_sysconfdir/monitrc.d/nginx.conf

%files nginx
%_sysconfdir/nginx/sites-enabled.d/autorepo.conf
%config %_sysconfdir/monitrc.d/nginx.conf

%files apt
%_sysconfdir/autorepo/apt/apt.conf.*
%_sysconfdir/autorepo/apt/sources.list.*

%changelog
